/*
 * Decompiled with CFR 0.152.
 */
package me.PauMAVA.TTR;

import me.PauMAVA.TTR.commands.EnableDisableCommand;
import me.PauMAVA.TTR.commands.StartMatchCommand;
import me.PauMAVA.TTR.config.TTRConfigManager;
import me.PauMAVA.TTR.match.AutoStarter;
import me.PauMAVA.TTR.match.MatchStatus;
import me.PauMAVA.TTR.match.TTRMatch;
import me.PauMAVA.TTR.teams.TTRTeamHandler;
import me.PauMAVA.TTR.ui.TTRCustomTab;
import me.PauMAVA.TTR.ui.TTRScoreboard;
import me.PauMAVA.TTR.util.EventListener;
import me.PauMAVA.TTR.world.TTRWorldHandler;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TTRCore
extends JavaPlugin {
    private static TTRCore instance;
    private boolean enabled = false;
    private TTRMatch match;
    private TTRTeamHandler teamHandler;
    private TTRConfigManager configManager;
    private TTRWorldHandler worldHandler;
    private TTRCustomTab customTab;
    private TTRScoreboard scoreboard;
    private AutoStarter autoStarter;
    private boolean isCounting = false;

    public void onEnable() {
        instance = this;
        if (this.getConfig().getBoolean("enable_on_start")) {
            this.enabled = true;
        } else {
            this.getLogger().warning("TTR is disabled on server start. Use /ttrenable to enable it on start. Make sure to be using the desired map.");
        }
        this.configManager = new TTRConfigManager(this.getConfig());
        if (this.enabled) {
            this.customTab = new TTRCustomTab();
            this.scoreboard = new TTRScoreboard();
            this.match = new TTRMatch(MatchStatus.PREGAME);
            this.customTab.runTaskTimer((Plugin)this, 0L, 20L);
            this.teamHandler = new TTRTeamHandler();
            this.teamHandler.setUpDefaultTeams();
            this.worldHandler = new TTRWorldHandler(this, (World)this.getServer().getWorlds().get(0));
            this.worldHandler.setUpWorld();
            this.getServer().getPluginManager().registerEvents((Listener)new EventListener(), (Plugin)this);
        } else {
            this.match = new TTRMatch(MatchStatus.DISABLED);
        }
        this.getCommand("ttrstart").setExecutor((CommandExecutor)new StartMatchCommand());
        EnableDisableCommand enableDisableCommand = new EnableDisableCommand(this);
        this.getCommand("ttrenable").setExecutor((CommandExecutor)enableDisableCommand);
        this.getCommand("ttrdisable").setExecutor((CommandExecutor)enableDisableCommand);
        this.autoStarter = new AutoStarter(this, this.getConfig());
    }

    public void onDisable() {
        try {
            this.customTab.cancel();
            this.scoreboard.removeScoreboard();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static TTRCore getInstance() {
        return instance;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public TTRMatch getCurrentMatch() {
        return this.match;
    }

    public TTRTeamHandler getTeamHandler() {
        return this.teamHandler;
    }

    public TTRConfigManager getConfigManager() {
        return this.configManager;
    }

    public TTRWorldHandler getWorldHandler() {
        return this.worldHandler;
    }

    public TTRScoreboard getScoreboard() {
        return this.scoreboard;
    }

    public boolean isCounting() {
        return this.isCounting;
    }

    public void setCounting(boolean counting) {
        this.isCounting = counting;
    }

    public AutoStarter getAutoStarter() {
        return this.autoStarter;
    }
}

