/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_19_R2;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_19_R2.block.CraftBlock;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.v1_19_R2.CustomBiomeHandler;

public class TerraformWorldProviderBiome
extends WorldChunkManager {
    private final TerraformWorld tw;
    private final IRegistry<BiomeBase> registry;
    private final WorldChunkManager delegate;
    private static boolean debug = false;

    private static List<Holder<BiomeBase>> biomeListToBiomeBaseList(IRegistry<BiomeBase> registry) {
        ArrayList<Holder<BiomeBase>> biomeBases = new ArrayList<Holder<BiomeBase>>();
        for (Biome biome : Biome.values()) {
            if (biome == null || biome == Biome.CUSTOM) continue;
            biomeBases.add((Holder<BiomeBase>)CraftBlock.biomeToBiomeBase(registry, (Biome)biome));
        }
        for (CustomBiomeType customBiomeType : CustomBiomeType.values()) {
            if (customBiomeType == CustomBiomeType.NONE) continue;
            ResourceKey<BiomeBase> rkey = CustomBiomeHandler.terraformGenBiomeRegistry.get((Object)customBiomeType);
            Optional holder = registry.b(rkey);
            holder.ifPresent(biomeBases::add);
        }
        return biomeBases;
    }

    public TerraformWorldProviderBiome(TerraformWorld tw, WorldChunkManager delegate) {
        super(TerraformWorldProviderBiome.biomeListToBiomeBaseList(CustomBiomeHandler.getBiomeRegistry()));
        this.tw = tw;
        this.delegate = delegate;
        this.registry = CustomBiomeHandler.getBiomeRegistry();
    }

    protected Codec<? extends WorldChunkManager> a() {
        throw new UnsupportedOperationException("Cannot serialize TerraformWorldProviderBiome");
    }

    public Holder<BiomeBase> getNoiseBiome(int x, int y, int z, Climate.Sampler arg3) {
        BiomeBank bank = this.tw.getBiomeBank(x << 2, z << 2);
        if (bank.getHandler().getCustomBiome() == CustomBiomeType.NONE) {
            return CraftBlock.biomeToBiomeBase(this.registry, (Biome)bank.getHandler().getBiome());
        }
        ResourceKey<BiomeBase> rkey = CustomBiomeHandler.terraformGenBiomeRegistry.get((Object)bank.getHandler().getCustomBiome());
        Optional holder = this.registry.b(rkey);
        if (holder.isEmpty()) {
            TerraformGeneratorPlugin.logger.error("Custom biome was not found in the vanilla registry!");
        }
        if (holder.isPresent()) {
            return (Holder)holder.get();
        }
        return CraftBlock.biomeToBiomeBase(this.registry, (Biome)bank.getHandler().getBiome());
    }

    public static class TerraformBiomeResolverProxy
    implements BiomeResolver {
        TerraformWorldProviderBiome delegate;

        public TerraformBiomeResolverProxy(TerraformWorldProviderBiome delegate) {
            this.delegate = delegate;
        }

        public Holder<BiomeBase> getNoiseBiome(int arg0, int arg1, int arg2, Climate.Sampler arg3) {
            return this.delegate.getNoiseBiome(arg0, arg1, arg2, arg3);
        }
    }
}

