/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_19_R2;

import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_19_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R2.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_19_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_19_R2.util.RandomSourceWrapper;
import org.bukkit.entity.EntityType;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.bukkit.NativeGeneratorPatcherPopulator;
import org.terraform.coregen.populatordata.IPopulatorDataBaseHeightAccess;
import org.terraform.coregen.populatordata.IPopulatorDataBeehiveEditor;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.v1_19_R2.NMSChunkGenerator;

public class PopulatorData
extends PopulatorDataAbstract
implements IPopulatorDataBaseHeightAccess,
IPopulatorDataBeehiveEditor {
    private final int chunkX;
    private final int chunkZ;
    private int radius = 1;
    private final NMSChunkGenerator gen;
    GeneratorAccessSeed rlwa;
    IChunkAccess ica;
    private static final HashMap<EntityType, EntityTypes<?>> entityTypesDict = new HashMap();

    public PopulatorData(GeneratorAccessSeed rlwa, IChunkAccess ica, NMSChunkGenerator gen, int chunkX, int chunkZ) {
        this.rlwa = rlwa;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.gen = gen;
        this.ica = ica;
        if (entityTypesDict.size() == 0) {
            for (EntityType type : EntityType.values()) {
                if (type == EntityType.ENDER_SIGNAL || type == EntityType.UNKNOWN) continue;
                try {
                    Optional et = EntityTypes.a((String)type.toString());
                    et.ifPresent(entityTypes -> entityTypesDict.put(type, (EntityTypes<?>)entityTypes));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public Material getType(int x, int y, int z) {
        try {
            return CraftMagicNumbers.getMaterial((Block)this.rlwa.a_(new BlockPosition(x, y, z)).b());
        }
        catch (Exception e) {
            Bukkit.getLogger().info("Error chunk: " + this.chunkX + "," + this.chunkZ + "--- Block Coords: " + 16 * this.chunkX + "," + 16 * this.chunkZ + " for coords " + x + "," + y + "," + z);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        return CraftBlockData.fromData((IBlockData)this.rlwa.a_(new BlockPosition(x, y, z)));
    }

    @Override
    public void setType(int x, int y, int z, Material type) {
        if (Math.abs((x >> 4) - this.chunkX) > this.radius || Math.abs((z >> 4) - this.chunkZ) > this.radius) {
            if (this.radius > 0) {
                NativeGeneratorPatcherPopulator.pushChange(this.rlwa.getMinecraftWorld().getWorld().getName(), x, y, z, Bukkit.createBlockData((Material)type));
            } else {
                new Exception("Tried to call adjacent chunk with populator radius 0: (" + x + "," + y + "," + z + ") for chunk (" + this.chunkX + "," + this.chunkZ + ")").printStackTrace();
            }
        } else {
            this.rlwa.a(new BlockPosition(x, y, z), ((CraftBlockData)Bukkit.createBlockData((Material)type)).getState(), 0);
        }
    }

    @Override
    public void setBlockData(int x, int y, int z, BlockData data) {
        if (Math.abs((x >> 4) - this.chunkX) > this.radius || Math.abs((z >> 4) - this.chunkZ) > this.radius) {
            if (this.radius > 0) {
                NativeGeneratorPatcherPopulator.pushChange(this.rlwa.getMinecraftWorld().getWorld().getName(), x, y, z, data);
            } else {
                new Exception("Tried to call adjacent chunk with populator radius 0: (" + x + "," + y + "," + z + ") for chunk (" + this.chunkX + "," + this.chunkZ + ")").printStackTrace();
            }
        } else {
            this.rlwa.a(new BlockPosition(x, y, z), ((CraftBlockData)data).getState(), 0);
        }
    }

    @Override
    public Biome getBiome(int rawX, int rawZ) {
        TerraformWorld tw = this.gen.getTerraformWorld();
        return tw.getBiomeBank(rawX, rawZ).getHandler().getBiome();
    }

    @Override
    public int getChunkX() {
        return this.chunkX;
    }

    @Override
    public int getChunkZ() {
        return this.chunkZ;
    }

    @Override
    public void addEntity(int rawX, int rawY, int rawZ, EntityType type) {
        if (Math.abs((rawX >> 4) - this.chunkX) > 1 || Math.abs((rawZ >> 4) - this.chunkZ) > 1) {
            TerraformGeneratorPlugin.logger.info("Failed to spawn " + type + " as it was out of bounds.");
            return;
        }
        CraftLimitedRegion clr = new CraftLimitedRegion(this.rlwa, this.ica.f());
        Entity e = clr.createEntity(new Location(this.gen.getTerraformWorld().getWorld(), (double)rawX, (double)rawY, (double)rawZ), type.getEntityClass());
        this.rlwa.b(e);
    }

    @Override
    public void setSpawner(int rawX, int rawY, int rawZ, EntityType type) {
        BlockPosition pos = new BlockPosition(rawX, rawY, rawZ);
        this.setType(rawX, rawY, rawZ, Material.SPAWNER);
        TileEntity tileentity = this.rlwa.c_(pos);
        if (tileentity instanceof TileEntityMobSpawner) {
            try {
                EntityTypes<?> nmsEntity = entityTypesDict.get(type);
                ((TileEntityMobSpawner)tileentity).a(nmsEntity, (RandomSource)new RandomSourceWrapper(new Random()));
            }
            catch (IllegalArgumentException | SecurityException e) {
                e.printStackTrace();
            }
        } else {
            TerraformGeneratorPlugin.logger.error("Failed to fetch mob spawner entity at (," + rawX + "," + rawY + "," + rawZ + ")");
        }
    }

    @Override
    public void lootTableChest(int x, int y, int z, TerraLootTable table) {
        BlockPosition pos = new BlockPosition(x, y, z);
        TileEntityLootable.a((IBlockAccess)this.rlwa, (RandomSource)RandomSource.a((long)this.gen.getTerraformWorld().getHashedRand(x, y, z).nextLong()), (BlockPosition)pos, (MinecraftKey)this.getLootTable(table));
    }

    private MinecraftKey getLootTable(TerraLootTable table) {
        switch (table) {
            case EMPTY: {
                return LootTables.a;
            }
            case SPAWN_BONUS_CHEST: {
                return LootTables.b;
            }
            case END_CITY_TREASURE: {
                return LootTables.c;
            }
            case SIMPLE_DUNGEON: {
                return LootTables.d;
            }
            case VILLAGE_WEAPONSMITH: {
                return LootTables.e;
            }
            case VILLAGE_TOOLSMITH: {
                return LootTables.f;
            }
            case VILLAGE_ARMORER: {
                return LootTables.g;
            }
            case VILLAGE_CARTOGRAPHER: {
                return LootTables.h;
            }
            case VILLAGE_MASON: {
                return LootTables.i;
            }
            case VILLAGE_SHEPHERD: {
                return LootTables.j;
            }
            case VILLAGE_BUTCHER: {
                return LootTables.k;
            }
            case VILLAGE_FLETCHER: {
                return LootTables.l;
            }
            case VILLAGE_FISHER: {
                return LootTables.m;
            }
            case VILLAGE_TANNERY: {
                return LootTables.n;
            }
            case VILLAGE_TEMPLE: {
                return LootTables.o;
            }
            case VILLAGE_DESERT_HOUSE: {
                return LootTables.p;
            }
            case VILLAGE_PLAINS_HOUSE: {
                return LootTables.q;
            }
            case VILLAGE_TAIGA_HOUSE: {
                return LootTables.r;
            }
            case VILLAGE_SNOWY_HOUSE: {
                return LootTables.s;
            }
            case VILLAGE_SAVANNA_HOUSE: {
                return LootTables.t;
            }
            case ABANDONED_MINESHAFT: {
                return LootTables.u;
            }
            case NETHER_BRIDGE: {
                return LootTables.v;
            }
            case STRONGHOLD_LIBRARY: {
                return LootTables.w;
            }
            case STRONGHOLD_CROSSING: {
                return LootTables.x;
            }
            case STRONGHOLD_CORRIDOR: {
                return LootTables.y;
            }
            case DESERT_PYRAMID: {
                return LootTables.z;
            }
            case JUNGLE_TEMPLE: {
                return LootTables.A;
            }
            case JUNGLE_TEMPLE_DISPENSER: {
                return LootTables.B;
            }
            case IGLOO_CHEST: {
                return LootTables.C;
            }
            case WOODLAND_MANSION: {
                return LootTables.D;
            }
            case UNDERWATER_RUIN_SMALL: {
                return LootTables.E;
            }
            case UNDERWATER_RUIN_BIG: {
                return LootTables.F;
            }
            case BURIED_TREASURE: {
                return LootTables.G;
            }
            case SHIPWRECK_MAP: {
                return LootTables.H;
            }
            case SHIPWRECK_SUPPLY: {
                return LootTables.I;
            }
            case SHIPWRECK_TREASURE: {
                return LootTables.J;
            }
            case PILLAGER_OUTPOST: {
                return LootTables.K;
            }
            case ANCIENT_CITY: {
                return LootTables.P;
            }
            case ANCIENT_CITY_ICE_BOX: {
                return LootTables.Q;
            }
            case RUINED_PORTAL: {
                return LootTables.R;
            }
        }
        return null;
    }

    @Override
    public TerraformWorld getTerraformWorld() {
        return this.gen.getTerraformWorld();
    }

    @Override
    public int getBaseHeight(int rawX, int rawZ) {
        return 100;
    }

    @Override
    public void setBeehiveWithBee(int rawX, int rawY, int rawZ) {
        BlockPosition pos = new BlockPosition(rawX, rawY, rawZ);
        this.setType(rawX, rawY, rawZ, Material.BEE_NEST);
        try {
            TileEntityBeehive tileentity = (TileEntityBeehive)this.rlwa.c_(pos);
            if (tileentity == null) {
                this.setType(rawX, rawY, rawZ, Material.BEE_NEST);
                tileentity = (TileEntityBeehive)this.rlwa.c_(pos);
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.a("id", "minecraft:bee");
            tileentity.a(nbttagcompound, 0, false);
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException e) {
            e.printStackTrace();
        }
    }
}

