/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_19_R2;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.structures.BuriedTreasureStructure;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import net.minecraft.world.level.levelgen.structure.structures.StrongholdStructure;
import net.minecraft.world.level.levelgen.structure.structures.WoodlandMansionStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_19_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R2.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_19_R2.util.CraftMagicNumbers;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.terraform.biome.custombiomes.CustomBiomeSupportedBiomeGrid;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.TerraformPopulator;
import org.terraform.coregen.bukkit.TerraformBukkitBlockPopulator;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.MegaChunk;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfigOption;
import org.terraform.structure.StructureLocator;
import org.terraform.structure.monument.MonumentPopulator;
import org.terraform.structure.pillager.mansion.MansionPopulator;
import org.terraform.structure.small.buriedtreasure.BuriedTreasurePopulator;
import org.terraform.structure.stronghold.StrongholdPopulator;
import org.terraform.utils.BlockUtils;
import org.terraform.v1_19_R2.PopulatorData;
import org.terraform.v1_19_R2.PopulatorDataICA;
import org.terraform.v1_19_R2.TerraformWorldProviderBiome;

public class NMSChunkGenerator
extends ChunkGenerator {
    private final ChunkGenerator delegate;
    private final WorldServer world;
    private final TerraformPopulator pop;
    private final TerraformWorld tw;
    private final TerraformWorldProviderBiome twpb;

    public NMSChunkGenerator(String worldname, long seed, ChunkGenerator delegate) {
        super(delegate.c(), delegate.d);
        this.tw = TerraformWorld.get(worldname, seed);
        this.delegate = delegate;
        this.twpb = new TerraformWorldProviderBiome(this.tw, delegate.c());
        this.pop = new TerraformPopulator(this.tw);
        this.world = ((CraftWorld)Bukkit.getWorld((String)worldname)).getHandle();
        try {
            this.modifyCaveCarverLists(WorldGenCarverAbstract.a);
            this.modifyCaveCarverLists(WorldGenCarverAbstract.b);
            this.modifyCaveCarverLists(WorldGenCarverAbstract.c);
        }
        catch (Exception e) {
            TerraformGeneratorPlugin.logger.error("Failed to modify vanilla cave carver lists. You may see floating blocks above caves.");
            e.printStackTrace();
        }
    }

    public WorldChunkManager c() {
        return this.twpb;
    }

    public TerraformWorld getTerraformWorld() {
        return this.tw;
    }

    public CompletableFuture<IChunkAccess> a(Executor executor, RandomState randomstate, Blender blender, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        return CompletableFuture.supplyAsync(SystemUtils.a((String)"init_biomes", () -> ichunkaccess), SystemUtils.f());
    }

    public Pair<BlockPosition, Holder<Structure>> a(WorldServer worldserver, HolderSet<Structure> holderset, BlockPosition blockposition, int i, boolean flag) {
        int pX = blockposition.u();
        int pZ = blockposition.w();
        for (Holder holder : holderset) {
            Structure feature = (Structure)holder.a();
            TerraformGeneratorPlugin.logger.info("Vanilla locate for " + feature.getClass().getName() + " invoked.");
            if (((Structure)holder.a()).getClass() == StrongholdStructure.class) {
                int[] coords = new StrongholdPopulator().getNearestFeature(this.tw, pX, pZ);
                return new Pair((Object)new BlockPosition(coords[0], 20, coords[1]), (Object)holder);
            }
            if (TConfigOption.DEVSTUFF_VANILLA_LOCATE_DISABLE.getBoolean()) continue;
            if (((Structure)holder.a()).getClass() == OceanMonumentStructure.class) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new MonumentPopulator(), TConfigOption.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS.getInt());
                return new Pair((Object)new BlockPosition(coords[0], 50, coords[1]), (Object)holder);
            }
            if (((Structure)holder.a()).getClass() == WoodlandMansionStructure.class) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new MansionPopulator(), TConfigOption.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS.getInt());
                return new Pair((Object)new BlockPosition(coords[0], 50, coords[1]), (Object)holder);
            }
            if (((Structure)holder.a()).getClass() != BuriedTreasureStructure.class) continue;
            int[] coords = StructureLocator.locateMultiMegaChunkStructure(this.tw, new MegaChunk(pX, 0, pZ), new BuriedTreasurePopulator(), TConfigOption.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS.getInt());
            if (coords == null) {
                return null;
            }
            return new Pair((Object)new BlockPosition(coords[0], 50, coords[1]), (Object)holder);
        }
        return null;
    }

    public void a(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager) {
        int chunkX = ichunkaccess.f().e;
        int chunkZ = ichunkaccess.f().f;
        PopulatorData popDat = new PopulatorData(generatoraccessseed, ichunkaccess, this, chunkX, chunkZ);
        this.pop.populate(this.tw, this.tw.getHashedRand(8292012L, chunkX, chunkZ), popDat);
        CraftWorld world = generatoraccessseed.getMinecraftWorld().getWorld();
        if (!world.getPopulators().isEmpty()) {
            CraftLimitedRegion limitedRegion = new CraftLimitedRegion(generatoraccessseed, ichunkaccess.f());
            int x = ichunkaccess.f().e;
            int z = ichunkaccess.f().f;
            for (BlockPopulator populator : world.getPopulators()) {
                if (populator instanceof TerraformBukkitBlockPopulator) continue;
                populator.populate((WorldInfo)world, this.tw.getHashedRand(generatoraccessseed.B(), x, z), x, z, (LimitedRegion)limitedRegion);
            }
            limitedRegion.saveEntities();
            limitedRegion.breakLink();
        }
    }

    public void a(RegionLimitedWorldAccess regionlimitedworldaccess, long seed, RandomState randomstate, BiomeManager biomemanager, StructureManager structuremanager, IChunkAccess ichunkaccess, WorldGenStage.Features worldgenstage_features) {
        ichunkaccess.a((BiomeResolver)this.twpb, null);
        try {
            TerraformGenerator generator = new TerraformGenerator();
            int chunkX = ichunkaccess.f().e;
            int chunkZ = ichunkaccess.f().f;
            Random random = this.tw.getRand(3L);
            random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
            CustomBiomeGrid biomegrid = new CustomBiomeGrid(ichunkaccess);
            PopulatorDataAbstract data = new PopulatorData((GeneratorAccessSeed)regionlimitedworldaccess, ichunkaccess, this, chunkX, chunkZ);
            data.setRadius(0);
            data = new PopulatorDataICA(data, this.tw, this.world, ichunkaccess, chunkX, chunkZ);
            generator.addPopulatorData(data);
            ChunkGenerator.ChunkData cd = generator.generateChunkData(this.tw.getWorld(), random, chunkX, chunkZ, biomegrid);
            this.delegate.a(regionlimitedworldaccess, seed, randomstate, biomemanager, structuremanager, ichunkaccess, worldgenstage_features);
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int rawX = chunkX * 16 + x;
                    int rawZ = chunkZ * 16 + z;
                    for (int height = this.tw.maxY - 1; !CraftBlockData.fromData((IBlockData)ichunkaccess.a_(new BlockPosition(rawX, height, rawZ))).getMaterial().isSolid() && height > TerraformGenerator.seaLevel; --height) {
                        ichunkaccess.a(new BlockPosition(rawX, height, rawZ), Blocks.a.n(), false);
                    }
                    generator.fillSeaAndRivers(cd, x, z, HeightMap.getBlockHeight(this.tw, rawX, rawZ));
                }
            }
        }
        catch (IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
        }
    }

    private void modifyCaveCarverLists(WorldGenCarverAbstract<?> carverAbstract) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        HashSet<Block> temp = new HashSet<Block>();
        for (Material mat : BlockUtils.caveDecoratorMaterials) {
            temp.add(CraftMagicNumbers.getBlock((Material)mat));
        }
        for (Material mat : BlockUtils.badlandsStoneLike) {
            temp.add(CraftMagicNumbers.getBlock((Material)mat));
        }
        temp.add(CraftMagicNumbers.getBlock((Material)Material.WATER));
        temp.add(CraftMagicNumbers.getBlock((Material)Material.LAVA));
        Field field = WorldGenCarverAbstract.class.getDeclaredField("h");
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        field.set(carverAbstract, ImmutableSet.copyOf(temp));
    }

    public int e() {
        return this.delegate.e();
    }

    public void a(IRegistryCustom iregistrycustom, ChunkGeneratorStructureState chunkgeneratorstructurestate, StructureManager structuremanager, IChunkAccess ichunkaccess, StructureTemplateManager structuretemplatemanager) {
    }

    public int a(LevelHeightAccessor levelheightaccessor) {
        return 64;
    }

    public CompletableFuture<IChunkAccess> a(Executor executor, Blender blender, RandomState randomstate, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        return this.delegate.a(executor, blender, randomstate, structuremanager, ichunkaccess);
    }

    public void a(RegionLimitedWorldAccess regionlimitedworldaccess, StructureManager structuremanager, RandomState randomstate, IChunkAccess ichunkaccess) {
    }

    public void a(GeneratorAccessSeed gas, StructureManager manager, IChunkAccess ica) {
        this.delegate.a(gas, manager, ica);
    }

    protected Codec<? extends ChunkGenerator> a() {
        return Codec.unit(null);
    }

    public BlockColumn a(int i, int j, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.delegate.a(i, j, levelheightaccessor, randomstate);
    }

    public void a(RegionLimitedWorldAccess regionlimitedworldaccess) {
        this.delegate.a(regionlimitedworldaccess);
    }

    public int d() {
        return this.delegate.d();
    }

    public int f() {
        return this.delegate.f();
    }

    public int b(int i, int j, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.a(i, j, heightmap_type, levelheightaccessor, randomstate);
    }

    public int c(int i, int j, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.a(i, j, heightmap_type, levelheightaccessor, randomstate) - 1;
    }

    public int a(int i, int j, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return 100;
    }

    public void a(List<String> list, RandomState randomstate, BlockPosition blockposition) {
    }

    private static class CustomBiomeGrid
    extends CustomBiomeSupportedBiomeGrid
    implements ChunkGenerator.BiomeGrid {
        private final IChunkAccess biome;

        public CustomBiomeGrid(IChunkAccess biome) {
            this.biome = biome;
        }

        public Biome getBiome(int x, int z) {
            return this.getBiome(x, TerraformGenerator.seaLevel, z);
        }

        public void setBiome(int x, int z, Biome bio) {
        }

        public Biome getBiome(int x, int y, int z) {
            try {
                return CraftBlock.biomeBaseToBiome((IRegistry)this.biome.biomeRegistry, (Holder)this.biome.getNoiseBiome(x >> 2, y >> 2, z >> 2));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return null;
            }
        }

        public void setBiome(int x, int y, int z, Biome bio) {
        }

        @Override
        public void setBiome(int x, int y, int z, CustomBiomeType bio, Biome fallback) {
        }
    }
}

