/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_18_R2;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import org.bukkit.Bukkit;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.v1_18_R2.CustomBiomeHandler;

public class TerraformWorldProviderBiome
extends WorldChunkManager {
    private final TerraformWorld tw;
    private final IRegistry<BiomeBase> registry;
    private final WorldChunkManager delegate;
    private static boolean debug = false;

    private static List<Holder<BiomeBase>> biomeListToBiomeBaseList(IRegistry<BiomeBase> registry) {
        ArrayList<Holder<BiomeBase>> biomeBases = new ArrayList<Holder<BiomeBase>>();
        for (Biome biome : Biome.values()) {
            if (biome == null || biome == Biome.CUSTOM) continue;
            biomeBases.add((Holder<BiomeBase>)CraftBlock.biomeToBiomeBase(registry, (Biome)biome));
        }
        for (CustomBiomeType customBiomeType : CustomBiomeType.values()) {
            ResourceKey<BiomeBase> rkey;
            Holder holder;
            if (customBiomeType == CustomBiomeType.NONE || (holder = registry.g(rkey = CustomBiomeHandler.terraformGenBiomeRegistry.get((Object)customBiomeType))) == null) continue;
            biomeBases.add((Holder<BiomeBase>)holder);
        }
        return biomeBases;
    }

    public TerraformWorldProviderBiome(TerraformWorld tw, WorldChunkManager delegate) {
        super(TerraformWorldProviderBiome.biomeListToBiomeBaseList((IRegistry<BiomeBase>)((CraftServer)Bukkit.getServer()).getServer().aU().b(IRegistry.aP)));
        this.tw = tw;
        this.delegate = delegate;
        this.registry = ((CraftServer)Bukkit.getServer()).getServer().aU().b(IRegistry.aP);
    }

    protected Codec<? extends WorldChunkManager> a() {
        throw new UnsupportedOperationException("Cannot serialize TerraformWorldProviderBiome");
    }

    public WorldChunkManager a(long arg0) {
        throw new UnsupportedOperationException("Cannot serialize TerraformWorldProviderBiome");
    }

    public Holder<BiomeBase> getNoiseBiome(int x, int y, int z, Climate.Sampler arg3) {
        BiomeBank bank = this.tw.getBiomeBank(x << 2, z << 2);
        DedicatedServer dedicatedserver = ((CraftServer)Bukkit.getServer()).getServer();
        IRegistry iregistry = dedicatedserver.aU().b(IRegistry.aP);
        if (bank.getHandler().getCustomBiome() == CustomBiomeType.NONE) {
            return CraftBlock.biomeToBiomeBase(this.registry, (Biome)bank.getHandler().getBiome());
        }
        ResourceKey<BiomeBase> rkey = CustomBiomeHandler.terraformGenBiomeRegistry.get((Object)bank.getHandler().getCustomBiome());
        Holder holder = iregistry.g(rkey);
        if (holder == null) {
            TerraformGeneratorPlugin.logger.error("Custom biome was not found in the vanilla registry!");
        }
        if (holder != null) {
            return holder;
        }
        return CraftBlock.biomeToBiomeBase(this.registry, (Biome)bank.getHandler().getBiome());
    }
}

