/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_18_R2;

import java.lang.reflect.Field;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R2.CraftChunk;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.generator.CustomChunkGenerator;
import org.bukkit.entity.Player;
import org.terraform.coregen.BlockDataFixerAbstract;
import org.terraform.coregen.NMSInjectorAbstract;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.coregen.populatordata.PopulatorDataICAAbstract;
import org.terraform.coregen.populatordata.PopulatorDataPostGen;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.v1_18_R2.BlockDataFixer;
import org.terraform.v1_18_R2.CustomBiomeHandler;
import org.terraform.v1_18_R2.NMSChunkGenerator;
import org.terraform.v1_18_R2.PopulatorData;
import org.terraform.v1_18_R2.PopulatorDataICA;

public class NMSInjector
extends NMSInjectorAbstract {
    @Override
    public void startupTasks() {
        CustomBiomeHandler.init();
    }

    @Override
    public BlockDataFixerAbstract getBlockDataFixer() {
        return new BlockDataFixer();
    }

    @Override
    public boolean attemptInject(World world) {
        CraftWorld cw = (CraftWorld)world;
        WorldServer ws = cw.getHandle();
        TerraformWorld.get((World)world).minY = -64;
        TerraformWorld.get((World)world).maxY = 320;
        NMSChunkGenerator bpg = new NMSChunkGenerator(world.getName(), (int)world.getSeed(), ws.k().g());
        TerraformGeneratorPlugin.logger.info("NMSChunkGenerator Delegate is of type " + ws.k().g().getClass().getSimpleName());
        if (ws.k().g() instanceof CustomChunkGenerator) {
            try {
                ChunkGenerator delegate = null;
                Field f = CustomChunkGenerator.class.getDeclaredField("delegate");
                f.setAccessible(true);
                delegate = (ChunkGenerator)f.get(ws.k().g());
                TerraformGeneratorPlugin.logger.info("CustomChunkGenerator Delegate is of type " + delegate.getClass().getSimpleName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TerraformGeneratorPlugin.logger.info("- minY " + ws.q_().k() + "   " + world.getMinHeight());
        TerraformGeneratorPlugin.logger.info("- Height " + ws.q_().l() + "   " + world.getMaxHeight());
        TerraformGeneratorPlugin.logger.info("- LogicalHeight " + ws.q_().m() + "   " + world.getLogicalHeight());
        PlayerChunkMap pcm = ws.k().a;
        try {
            TerraformGeneratorPlugin.privateFieldHandler.injectField((Object)pcm, "u", (Object)bpg);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public PopulatorDataICAAbstract getICAData(org.bukkit.Chunk chunk) {
        Chunk ica = ((CraftChunk)chunk).getHandle();
        CraftWorld cw = (CraftWorld)chunk.getWorld();
        WorldServer ws = cw.getHandle();
        TerraformWorld tw = TerraformWorld.get(chunk.getWorld());
        return new PopulatorDataICA(new PopulatorDataPostGen(chunk), tw, ws, (IChunkAccess)ica, chunk.getX(), chunk.getZ());
    }

    @Override
    public PopulatorDataICAAbstract getICAData(PopulatorDataAbstract data) {
        if (data instanceof PopulatorData) {
            PopulatorData pdata = (PopulatorData)data;
            IChunkAccess ica = pdata.ica;
            WorldServer ws = ((PopulatorData)data).rlwa.getMinecraftWorld();
            TerraformWorld tw = TerraformWorld.get(ws.getWorld().getName(), ws.D());
            return new PopulatorDataICA(data, tw, ws, ica, data.getChunkX(), data.getChunkZ());
        }
        return null;
    }

    @Override
    public int getMinY() {
        return -64;
    }

    @Override
    public int getMaxY() {
        return 320;
    }

    @Override
    public void debugTest(Player p) {
    }
}

