/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_18_R2;

import com.mojang.serialization.Lifecycle;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.Biomes;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.main.TerraformGeneratorPlugin;

public class CustomBiomeHandler {
    public static final HashMap<CustomBiomeType, ResourceKey<BiomeBase>> terraformGenBiomeRegistry = new HashMap();

    public static void init() {
        CraftServer craftserver = (CraftServer)Bukkit.getServer();
        DedicatedServer dedicatedserver = craftserver.getServer();
        IRegistryWritable registrywritable = (IRegistryWritable)dedicatedserver.aU().b(IRegistry.aP);
        try {
            Field frozen = RegistryMaterials.class.getDeclaredField("bL");
            frozen.setAccessible(true);
            frozen.set(registrywritable, false);
            TerraformGeneratorPlugin.logger.info("Unfreezing biome registry...");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            e1.printStackTrace();
        }
        BiomeBase forestbiome = (BiomeBase)registrywritable.a(Biomes.h);
        for (CustomBiomeType type : CustomBiomeType.values()) {
            if (type == CustomBiomeType.NONE) continue;
            try {
                CustomBiomeHandler.registerCustomBiomeBase(type, dedicatedserver, (IRegistryWritable<BiomeBase>)registrywritable, forestbiome);
                TerraformGeneratorPlugin.logger.info("Registered custom biome: " + type.toString().toLowerCase());
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                TerraformGeneratorPlugin.logger.error("Failed to register custom biome: " + type.getKey());
                e.printStackTrace();
            }
        }
        try {
            Field frozen = RegistryMaterials.class.getDeclaredField("bL");
            frozen.setAccessible(true);
            frozen.set(registrywritable, true);
            TerraformGeneratorPlugin.logger.info("Freezing biome registry");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            e1.printStackTrace();
        }
    }

    private static void registerCustomBiomeBase(CustomBiomeType biomeType, DedicatedServer dedicatedserver, IRegistryWritable<BiomeBase> registrywritable, BiomeBase forestbiome) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ResourceKey newKey = ResourceKey.a((ResourceKey)IRegistry.aP, (MinecraftKey)new MinecraftKey("terraformgenerator", biomeType.toString().toLowerCase()));
        BiomeBase.a newBiomeBuilder = new BiomeBase.a();
        Field f = BiomeBase.class.getDeclaredField("l");
        f.setAccessible(true);
        newBiomeBuilder.a((BiomeBase.Geography)f.get(forestbiome));
        newBiomeBuilder.a(forestbiome.c());
        Field biomeSettingMobsField = BiomeBase.class.getDeclaredField("k");
        biomeSettingMobsField.setAccessible(true);
        BiomeSettingsMobs biomeSettingMobs = (BiomeSettingsMobs)biomeSettingMobsField.get(forestbiome);
        newBiomeBuilder.a(biomeSettingMobs);
        Field biomeSettingGenField = BiomeBase.class.getDeclaredField("j");
        biomeSettingGenField.setAccessible(true);
        BiomeSettingsGeneration biomeSettingGen = (BiomeSettingsGeneration)biomeSettingGenField.get(forestbiome);
        newBiomeBuilder.a(biomeSettingGen);
        newBiomeBuilder.a(0.7f);
        newBiomeBuilder.b(biomeType.getRainFall());
        if (biomeType.isCold()) {
            newBiomeBuilder.a(BiomeBase.TemperatureModifier.b);
        } else {
            newBiomeBuilder.a(BiomeBase.TemperatureModifier.a);
        }
        BiomeFog.a newFog = new BiomeFog.a();
        newFog.a(BiomeFog.GrassColor.a);
        newFog.a(biomeType.getFogColor().equals("") ? forestbiome.f() : Integer.parseInt(biomeType.getFogColor(), 16));
        newFog.b(biomeType.getWaterColor().equals("") ? forestbiome.k() : Integer.parseInt(biomeType.getWaterColor(), 16));
        newFog.c(biomeType.getWaterFogColor().equals("") ? forestbiome.l() : Integer.parseInt(biomeType.getWaterFogColor(), 16));
        newFog.d(biomeType.getSkyColor().equals("") ? forestbiome.a() : Integer.parseInt(biomeType.getSkyColor(), 16));
        newFog.e(biomeType.getFoliageColor().equals("") ? forestbiome.g() : Integer.parseInt(biomeType.getFoliageColor(), 16));
        newFog.f(biomeType.getGrassColor().equals("") ? Integer.parseInt("79C05A", 16) : Integer.parseInt(biomeType.getGrassColor(), 16));
        newBiomeBuilder.a(newFog.a());
        BiomeBase biome = newBiomeBuilder.a();
        RegistryGeneration.a((IRegistry)RegistryGeneration.i, (ResourceKey)newKey, (Object)biome);
        RegistryMaterials registry = (RegistryMaterials)dedicatedserver.aU().b(IRegistry.aP);
        registry.a(newKey, (Object)biome, Lifecycle.stable());
        terraformGenBiomeRegistry.put(biomeType, (ResourceKey<BiomeBase>)newKey);
    }
}

