/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_18_R1;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.WorldGenMonumentPieces;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R1.block.data.CraftBlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.coregen.NaturalSpawnType;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.coregen.populatordata.PopulatorDataICABiomeWriterAbstract;
import org.terraform.data.TerraformWorld;

public class PopulatorDataICA
extends PopulatorDataICABiomeWriterAbstract {
    private PopulatorDataAbstract parent;
    private final IChunkAccess ica;
    private final int chunkX;
    private final int chunkZ;
    private final WorldServer ws;
    private final TerraformWorld tw;

    public PopulatorDataICA(PopulatorDataAbstract parent, TerraformWorld tw, WorldServer ws, IChunkAccess ica, int chunkX, int chunkZ) {
        this.ica = ica;
        this.parent = parent;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.ws = ws;
        this.tw = tw;
    }

    @Override
    public Material getType(int x, int y, int z) {
        IBlockData ibd = this.ica.a_(new BlockPosition(x, y, z));
        return CraftBlockData.fromData((IBlockData)ibd).getMaterial();
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        IBlockData ibd = this.ica.a_(new BlockPosition(x, y, z));
        return CraftBlockData.fromData((IBlockData)ibd);
    }

    @Override
    public void setBiome(int rawX, int rawY, int rawZ, CustomBiomeType cbt, Biome fallback) {
        BiomeBase targetBiome;
        DedicatedServer dedicatedserver = ((CraftServer)Bukkit.getServer()).getServer();
        IRegistryWritable registrywritable = dedicatedserver.aV().b(IRegistry.aR);
        if (cbt == CustomBiomeType.NONE) {
            targetBiome = CraftBlock.biomeToBiomeBase((IRegistry)this.ica.biomeRegistry, (Biome)fallback);
        } else {
            ResourceKey rkey = ResourceKey.a((ResourceKey)IRegistry.aR, (MinecraftKey)new MinecraftKey(cbt.getKey()));
            BiomeBase base = (BiomeBase)registrywritable.a(rkey);
            if (base == null) {
                String[] split = cbt.getKey().split(":");
                ResourceKey newrkey = ResourceKey.a((ResourceKey)IRegistry.aR, (MinecraftKey)new MinecraftKey(split[0], split[1]));
                base = (BiomeBase)registrywritable.a(newrkey);
            }
            targetBiome = base != null ? base : CraftBlock.biomeToBiomeBase((IRegistry)this.ica.biomeRegistry, (Biome)fallback);
        }
        this.ica.setBiome(rawX >> 2, rawY >> 2, rawZ >> 2, targetBiome);
    }

    @Override
    public void setBiome(int rawX, int rawY, int rawZ, Biome biome) {
        this.ica.setBiome(rawX >> 2, rawY >> 2, rawZ >> 2, CraftBlock.biomeToBiomeBase((IRegistry)this.ica.biomeRegistry, (Biome)biome));
    }

    @Override
    public void setType(int x, int y, int z, Material type) {
        this.ica.a(new BlockPosition(x, y, z), ((CraftBlockData)Bukkit.createBlockData((Material)type)).getState(), false);
    }

    @Override
    public void setBlockData(int x, int y, int z, BlockData data) {
        this.ica.a(new BlockPosition(x, y, z), ((CraftBlockData)data).getState(), false);
    }

    @Override
    public Biome getBiome(int rawX, int rawZ) {
        return this.parent.getBiome(rawX, rawZ);
    }

    @Override
    public int getChunkX() {
        return this.chunkX;
    }

    @Override
    public int getChunkZ() {
        return this.chunkZ;
    }

    @Override
    public void addEntity(int rawX, int rawY, int rawZ, EntityType type) {
        this.parent.addEntity(rawX, rawY, rawZ, type);
    }

    @Override
    public void setSpawner(int rawX, int rawY, int rawZ, EntityType type) {
        this.parent.setSpawner(rawX, rawY, rawZ, type);
    }

    @Override
    public void lootTableChest(int x, int y, int z, TerraLootTable table) {
        BlockPosition pos = new BlockPosition(x, y, z);
        TileEntityLootable.a((IBlockAccess)this.ica, (Random)this.tw.getHashedRand(x, y, z), (BlockPosition)pos, (MinecraftKey)this.getLootTable(table));
    }

    @Override
    public void registerNaturalSpawns(NaturalSpawnType type, int x0, int y0, int z0, int x1, int y1, int z1) {
        StructureGenerator generator = StructureGenerator.m;
        switch (type) {
            case GUARDIAN: {
                generator = StructureGenerator.m;
                break;
            }
            case PILLAGER: {
                generator = StructureGenerator.c;
            }
        }
        WorldGenMonumentPieces.WorldGenMonumentPiece1 customBoundPiece = new WorldGenMonumentPieces.WorldGenMonumentPiece1(new Random(), x0, z0, EnumDirection.a);
        PiecesContainer container = new PiecesContainer((List)new ArrayList<StructurePiece>((StructurePiece)customBoundPiece){
            final /* synthetic */ StructurePiece val$customBoundPiece;
            {
                this.val$customBoundPiece = structurePiece;
                this.add(this.val$customBoundPiece);
            }
        });
        StructureStart start = new StructureStart(generator, new ChunkCoordIntPair(this.chunkX, this.chunkZ), 0, container);
        try {
            Field i = StructureStart.class.getDeclaredField("g");
            i.setAccessible(true);
            i.set(start, new StructureBoundingBox(x0, y0, z0, x1, y1, z1));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        IChunkAccess sa = this.ica;
        sa.a(generator, start);
        sa.a(generator, new ChunkCoordIntPair(this.chunkX, this.chunkZ).a());
    }

    @Override
    public void spawnMinecartWithChest(int x, int y, int z, TerraLootTable table, Random random) {
        EntityMinecartChest entityminecartchest = new EntityMinecartChest((World)this.ws.getMinecraftWorld(), (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f));
        entityminecartchest.a(this.getLootTable(table), random.nextLong());
        this.ws.addFreshEntity((Entity)entityminecartchest, CreatureSpawnEvent.SpawnReason.CHUNK_GEN);
    }

    private MinecraftKey getLootTable(TerraLootTable table) {
        switch (table) {
            case EMPTY: {
                return LootTables.a;
            }
            case SPAWN_BONUS_CHEST: {
                return LootTables.b;
            }
            case END_CITY_TREASURE: {
                return LootTables.c;
            }
            case SIMPLE_DUNGEON: {
                return LootTables.d;
            }
            case VILLAGE_WEAPONSMITH: {
                return LootTables.e;
            }
            case VILLAGE_TOOLSMITH: {
                return LootTables.f;
            }
            case VILLAGE_ARMORER: {
                return LootTables.g;
            }
            case VILLAGE_CARTOGRAPHER: {
                return LootTables.h;
            }
            case VILLAGE_MASON: {
                return LootTables.i;
            }
            case VILLAGE_SHEPHERD: {
                return LootTables.j;
            }
            case VILLAGE_BUTCHER: {
                return LootTables.k;
            }
            case VILLAGE_FLETCHER: {
                return LootTables.l;
            }
            case VILLAGE_FISHER: {
                return LootTables.m;
            }
            case VILLAGE_TANNERY: {
                return LootTables.n;
            }
            case VILLAGE_TEMPLE: {
                return LootTables.o;
            }
            case VILLAGE_DESERT_HOUSE: {
                return LootTables.p;
            }
            case VILLAGE_PLAINS_HOUSE: {
                return LootTables.q;
            }
            case VILLAGE_TAIGA_HOUSE: {
                return LootTables.r;
            }
            case VILLAGE_SNOWY_HOUSE: {
                return LootTables.s;
            }
            case VILLAGE_SAVANNA_HOUSE: {
                return LootTables.t;
            }
            case ABANDONED_MINESHAFT: {
                return LootTables.u;
            }
            case NETHER_BRIDGE: {
                return LootTables.v;
            }
            case STRONGHOLD_LIBRARY: {
                return LootTables.w;
            }
            case STRONGHOLD_CROSSING: {
                return LootTables.x;
            }
            case STRONGHOLD_CORRIDOR: {
                return LootTables.y;
            }
            case DESERT_PYRAMID: {
                return LootTables.z;
            }
            case JUNGLE_TEMPLE: {
                return LootTables.A;
            }
            case JUNGLE_TEMPLE_DISPENSER: {
                return LootTables.B;
            }
            case IGLOO_CHEST: {
                return LootTables.C;
            }
            case WOODLAND_MANSION: {
                return LootTables.D;
            }
            case UNDERWATER_RUIN_SMALL: {
                return LootTables.E;
            }
            case UNDERWATER_RUIN_BIG: {
                return LootTables.F;
            }
            case BURIED_TREASURE: {
                return LootTables.G;
            }
            case SHIPWRECK_MAP: {
                return LootTables.H;
            }
            case SHIPWRECK_SUPPLY: {
                return LootTables.I;
            }
            case SHIPWRECK_TREASURE: {
                return LootTables.J;
            }
            case PILLAGER_OUTPOST: {
                return LootTables.K;
            }
            case RUINED_PORTAL: {
                return LootTables.P;
            }
        }
        return null;
    }

    @Override
    public TerraformWorld getTerraformWorld() {
        return this.tw;
    }
}

