/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_18_R1;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeaturePillagerOutpost;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureSwampHut;
import net.minecraft.world.level.levelgen.feature.WorldGenMonument;
import net.minecraft.world.level.levelgen.feature.WorldGenNether;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.bukkit.Bukkit;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R1.generator.CraftLimitedRegion;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.terraform.biome.custombiomes.CustomBiomeSupportedBiomeGrid;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.TerraformPopulator;
import org.terraform.coregen.bukkit.TerraformBukkitBlockPopulator;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.MegaChunk;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfigOption;
import org.terraform.structure.StructureLocator;
import org.terraform.structure.monument.MonumentPopulator;
import org.terraform.structure.pillager.mansion.MansionPopulator;
import org.terraform.structure.small.buriedtreasure.BuriedTreasurePopulator;
import org.terraform.structure.stronghold.StrongholdPopulator;
import org.terraform.v1_18_R1.PopulatorData;
import org.terraform.v1_18_R1.PopulatorDataICA;
import org.terraform.v1_18_R1.TerraformWorldProviderBiome;

public class NMSChunkGenerator
extends ChunkGenerator {
    private final ChunkGenerator delegate;
    private final WorldServer world;
    private final TerraformPopulator pop;
    private final TerraformWorld tw;
    private static boolean biomeDebug = false;

    public NMSChunkGenerator(String worldname, long seed, ChunkGenerator delegate) {
        super((WorldChunkManager)new TerraformWorldProviderBiome(TerraformWorld.get(worldname, seed), delegate.e()), delegate.d());
        this.tw = TerraformWorld.get(worldname, seed);
        this.delegate = delegate;
        this.pop = new TerraformPopulator(this.tw);
        this.world = ((CraftWorld)Bukkit.getWorld((String)worldname)).getHandle();
        try {
            this.modifyCaveCarverLists(WorldGenCarverAbstract.a);
            this.modifyCaveCarverLists(WorldGenCarverAbstract.b);
            this.modifyCaveCarverLists(WorldGenCarverAbstract.c);
        }
        catch (Exception e) {
            TerraformGeneratorPlugin.logger.error("Failed to modify vanilla cave carver lists. You may see floating blocks above caves.");
            e.printStackTrace();
        }
    }

    public WorldChunkManager e() {
        if (!(this.b instanceof TerraformWorldProviderBiome)) {
            TerraformGeneratorPlugin.logger.error("b was not an instance of TerraformWorldProviderBiome!");
        }
        return this.b;
    }

    public TerraformWorld getTerraformWorld() {
        return this.tw;
    }

    public CompletableFuture<IChunkAccess> a(IRegistry<BiomeBase> iregistry, Executor executor, Blender blender, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        return CompletableFuture.supplyAsync(SystemUtils.a((String)"init_biomes", () -> ichunkaccess), SystemUtils.f());
    }

    public BlockPosition a(WorldServer worldserver, StructureGenerator<?> structuregenerator, BlockPosition blockposition, int i, boolean flag) {
        int pX = blockposition.u();
        int pZ = blockposition.w();
        TerraformGeneratorPlugin.logger.info("Vanilla locate for " + structuregenerator.getClass().getName() + " invoked.");
        if (structuregenerator == StructureGenerator.l) {
            int[] coords = new StrongholdPopulator().getNearestFeature(this.tw, pX, pZ);
            return new BlockPosition(coords[0], 20, coords[1]);
        }
        if (!TConfigOption.DEVSTUFF_VANILLA_LOCATE_DISABLE.getBoolean()) {
            if (structuregenerator == StructureGenerator.m) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new MonumentPopulator(), TConfigOption.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS.getInt());
                return new BlockPosition(coords[0], 50, coords[1]);
            }
            if (structuregenerator == StructureGenerator.e) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new MansionPopulator(), TConfigOption.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS.getInt());
                return new BlockPosition(coords[0], 50, coords[1]);
            }
            if (structuregenerator.getClass().getName().equals("net.minecraft.world.level.levelgen.feature.WorldGenBuriedTreasure")) {
                int[] coords = StructureLocator.locateMultiMegaChunkStructure(this.tw, new MegaChunk(pX, 0, pZ), new BuriedTreasurePopulator(), TConfigOption.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS.getInt());
                return new BlockPosition(coords[0], 50, coords[1]);
            }
        }
        return null;
    }

    public void a(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager) {
        int chunkX = ichunkaccess.f().c;
        int chunkZ = ichunkaccess.f().d;
        PopulatorData popDat = new PopulatorData(generatoraccessseed, ichunkaccess, this, chunkX, chunkZ);
        this.pop.populate(this.tw, this.tw.getHashedRand(8292012L, chunkX, chunkZ), popDat);
        CraftWorld world = generatoraccessseed.getMinecraftWorld().getWorld();
        if (!world.getPopulators().isEmpty()) {
            CraftLimitedRegion limitedRegion = new CraftLimitedRegion(generatoraccessseed, ichunkaccess.f());
            int x = ichunkaccess.f().c;
            int z = ichunkaccess.f().d;
            for (BlockPopulator populator : world.getPopulators()) {
                if (populator instanceof TerraformBukkitBlockPopulator) continue;
                SeededRandom seededrandom = new SeededRandom((RandomSource)new LegacyRandomSource(generatoraccessseed.E()));
                seededrandom.a(generatoraccessseed.E(), x, z);
                populator.populate((WorldInfo)world, (Random)seededrandom, x, z, (LimitedRegion)limitedRegion);
            }
            limitedRegion.saveEntities();
            limitedRegion.breakLink();
        }
    }

    public void a(RegionLimitedWorldAccess regionlimitedworldaccess, long var2, BiomeManager var4, StructureManager var5, IChunkAccess ichunkaccess, WorldGenStage.Features var7) {
        ichunkaccess.a((arg_0, arg_1, arg_2, arg_3) -> ((WorldChunkManager)this.b).getNoiseBiome(arg_0, arg_1, arg_2, arg_3), this.c());
        try {
            TerraformGenerator generator = new TerraformGenerator();
            int chunkX = ichunkaccess.f().c;
            int chunkZ = ichunkaccess.f().d;
            Random random = this.tw.getRand(3L);
            random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
            CustomBiomeGrid biomegrid = new CustomBiomeGrid(ichunkaccess);
            PopulatorDataAbstract data = new PopulatorData((GeneratorAccessSeed)regionlimitedworldaccess, ichunkaccess, this, chunkX, chunkZ);
            data.setRadius(0);
            data = new PopulatorDataICA(data, this.tw, this.world, ichunkaccess, chunkX, chunkZ);
            generator.addPopulatorData(data);
            ChunkGenerator.ChunkData cd = generator.generateChunkData(this.tw.getWorld(), random, chunkX, chunkZ, biomegrid);
            this.delegate.a(regionlimitedworldaccess, var2, var4, var5, ichunkaccess, var7);
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int rawX = chunkX * 16 + x;
                    int rawZ = chunkZ * 16 + z;
                    for (int height = this.tw.maxY - 1; !CraftBlockData.fromData((IBlockData)ichunkaccess.a_(new BlockPosition(rawX, height, rawZ))).getMaterial().isSolid() && height > TerraformGenerator.seaLevel; --height) {
                        ichunkaccess.a(new BlockPosition(rawX, height, rawZ), Blocks.a.n(), false);
                    }
                    generator.fillSeaAndRivers(cd, x, z, HeightMap.getBlockHeight(this.tw, rawX, rawZ));
                }
            }
        }
        catch (IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
        }
    }

    private void modifyCaveCarverLists(WorldGenCarverAbstract<?> carverAbstract) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ImmutableSet immutableCarverList = ImmutableSet.of((Object)Blocks.A, (Object)Blocks.b, (Object)Blocks.c, (Object)Blocks.e, (Object)Blocks.g, (Object)Blocks.j, (Object[])new Block[]{Blocks.k, Blocks.l, Blocks.i, Blocks.hf, Blocks.fS, Blocks.fT, Blocks.fU, Blocks.fV, Blocks.fW, Blocks.fX, Blocks.fY, Blocks.fZ, Blocks.ga, Blocks.gb, Blocks.gc, Blocks.gd, Blocks.ge, Blocks.gf, Blocks.gg, Blocks.gh, Blocks.az, Blocks.hU, Blocks.ec, Blocks.cK, Blocks.hh, Blocks.pN, Blocks.oM, Blocks.C, Blocks.D, Blocks.E, Blocks.oL, Blocks.c, Blocks.H, Blocks.I, Blocks.qj, Blocks.oU, Blocks.oV, Blocks.qk, Blocks.D, Blocks.ij, Blocks.ie, Blocks.lJ, Blocks.lO, Blocks.m, Blocks.iS, Blocks.cM, Blocks.bP});
        Field field = WorldGenCarverAbstract.class.getDeclaredField("h");
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        field.set(carverAbstract, immutableCarverList);
    }

    public int g() {
        return 256;
    }

    public void a(IRegistryCustom iregistrycustom, StructureManager structuremanager, IChunkAccess ichunkaccess, DefinedStructureManager definedstructuremanager, long i) {
    }

    public int a(LevelHeightAccessor levelheightaccessor) {
        return 64;
    }

    public CompletableFuture<IChunkAccess> a(Executor executor, Blender blender, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        return this.delegate.a(executor, blender, structuremanager, ichunkaccess);
    }

    public void a(RegionLimitedWorldAccess regionlimitedworldaccess, StructureManager structuremanager, IChunkAccess ichunkaccess) {
    }

    public void a(GeneratorAccessSeed gas, StructureManager manager, IChunkAccess ica) {
        this.delegate.a(gas, manager, ica);
    }

    public WeightedRandomList a(BiomeBase biomebase, StructureManager structuremanager, EnumCreatureType enumcreaturetype, BlockPosition blockposition) {
        if (!structuremanager.a(blockposition)) {
            return super.a(biomebase, structuremanager, enumcreaturetype, blockposition);
        }
        if (structuremanager.b(blockposition, StructureGenerator.k).b()) {
            if (enumcreaturetype == EnumCreatureType.a) {
                return WorldGenFeatureSwampHut.a;
            }
            if (enumcreaturetype == EnumCreatureType.b) {
                return WorldGenFeatureSwampHut.w;
            }
        }
        if (enumcreaturetype == EnumCreatureType.a) {
            if (structuremanager.a(blockposition, StructureGenerator.c).b()) {
                return WorldGenFeaturePillagerOutpost.a;
            }
            if (structuremanager.a(blockposition, StructureGenerator.m).b()) {
                return WorldGenMonument.a;
            }
            if (structuremanager.b(blockposition, StructureGenerator.o).b()) {
                return WorldGenNether.a;
            }
        }
        return (enumcreaturetype == EnumCreatureType.e || enumcreaturetype == EnumCreatureType.d) && structuremanager.a(blockposition, StructureGenerator.m).b() ? BiomeSettingsMobs.b : super.a(biomebase, structuremanager, enumcreaturetype, blockposition);
    }

    protected Codec<? extends ChunkGenerator> a() {
        return ChunkGeneratorAbstract.d;
    }

    public BlockColumn a(int var0, int var1, LevelHeightAccessor var2) {
        return this.delegate.a(var0, var1, var2);
    }

    public ChunkGenerator a(long seed) {
        return new NMSChunkGenerator(this.tw.getName(), (int)seed, this.delegate);
    }

    public void a(RegionLimitedWorldAccess regionlimitedworldaccess) {
        this.delegate.a(regionlimitedworldaccess);
    }

    public int f() {
        return this.delegate.f();
    }

    public Climate.Sampler c() {
        return this.delegate.c();
    }

    public int h() {
        return this.delegate.h();
    }

    protected boolean a(IRegistry<BiomeBase> iregistry, Predicate<ResourceKey<BiomeBase>> predicate, BiomeBase biomebase) {
        return true;
    }

    public int b(int i, int j, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor) {
        return this.a(i, j, heightmap_type, levelheightaccessor);
    }

    public int c(int i, int j, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor) {
        return this.a(i, j, heightmap_type, levelheightaccessor) - 1;
    }

    public int a(int x, int z, HeightMap.Type var2, LevelHeightAccessor var3) {
        return 100;
    }

    public BiomeBase getNoiseBiome(int x, int y, int z) {
        if (!biomeDebug) {
            biomeDebug = true;
            TerraformGeneratorPlugin.logger.info("[getNoiseBiome] called for " + x + "," + y + "," + z);
        }
        return this.b.getNoiseBiome(x, y, z, null);
    }

    private class CustomBiomeGrid
    extends CustomBiomeSupportedBiomeGrid
    implements ChunkGenerator.BiomeGrid {
        private final IChunkAccess biome;

        public CustomBiomeGrid(IChunkAccess biome) {
            this.biome = biome;
        }

        public Biome getBiome(int x, int z) {
            return this.getBiome(x, TerraformGenerator.seaLevel, z);
        }

        public void setBiome(int x, int z, Biome bio) {
        }

        public Biome getBiome(int x, int y, int z) {
            try {
                return CraftBlock.biomeBaseToBiome((IRegistry)this.biome.biomeRegistry, (BiomeBase)this.biome.getNoiseBiome(x >> 2, y >> 2, z >> 2));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return null;
            }
        }

        public void setBiome(int x, int y, int z, Biome bio) {
        }

        @Override
        public void setBiome(int x, int y, int z, CustomBiomeType bio, Biome fallback) {
        }
    }
}

