/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_18_R1;

import com.mojang.serialization.Lifecycle;
import java.lang.reflect.Field;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.Biomes;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.main.TerraformGeneratorPlugin;

public class CustomBiomeHandler {
    public static void init() {
        CraftServer craftserver = (CraftServer)Bukkit.getServer();
        DedicatedServer dedicatedserver = craftserver.getServer();
        IRegistryWritable registrywritable = dedicatedserver.aV().b(IRegistry.aR);
        BiomeBase forestbiome = (BiomeBase)registrywritable.a(Biomes.h);
        for (CustomBiomeType type : CustomBiomeType.values()) {
            if (type == CustomBiomeType.NONE) continue;
            try {
                CustomBiomeHandler.registerCustomBiomeBase(type, dedicatedserver, (IRegistryWritable<BiomeBase>)registrywritable, forestbiome);
                TerraformGeneratorPlugin.logger.info("Registered custom biome: " + type.toString().toLowerCase());
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                TerraformGeneratorPlugin.logger.error("Failed to register custom biome: " + type.getKey());
                e.printStackTrace();
            }
        }
    }

    private static void registerCustomBiomeBase(CustomBiomeType biomeType, DedicatedServer dedicatedserver, IRegistryWritable<BiomeBase> registrywritable, BiomeBase forestbiome) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ResourceKey newKey = ResourceKey.a((ResourceKey)IRegistry.aR, (MinecraftKey)new MinecraftKey("terraformgenerator", biomeType.toString().toLowerCase()));
        BiomeBase.a newBiome = new BiomeBase.a();
        newBiome.a(forestbiome.r());
        newBiome.a(forestbiome.c());
        Field biomeSettingMobsField = BiomeBase.class.getDeclaredField("l");
        biomeSettingMobsField.setAccessible(true);
        BiomeSettingsMobs biomeSettingMobs = (BiomeSettingsMobs)biomeSettingMobsField.get(forestbiome);
        newBiome.a(biomeSettingMobs);
        Field biomeSettingGenField = BiomeBase.class.getDeclaredField("k");
        biomeSettingGenField.setAccessible(true);
        BiomeSettingsGeneration biomeSettingGen = (BiomeSettingsGeneration)biomeSettingGenField.get(forestbiome);
        newBiome.a(biomeSettingGen);
        newBiome.a(0.7f);
        newBiome.b(biomeType.getRainFall());
        if (biomeType.isCold()) {
            newBiome.a(BiomeBase.TemperatureModifier.b);
        } else {
            newBiome.a(BiomeBase.TemperatureModifier.a);
        }
        BiomeFog.a newFog = new BiomeFog.a();
        newFog.a(BiomeFog.GrassColor.a);
        newFog.a(biomeType.getFogColor().equals("") ? forestbiome.f() : Integer.parseInt(biomeType.getFogColor(), 16));
        newFog.b(biomeType.getWaterColor().equals("") ? forestbiome.k() : Integer.parseInt(biomeType.getWaterColor(), 16));
        newFog.c(biomeType.getWaterFogColor().equals("") ? forestbiome.l() : Integer.parseInt(biomeType.getWaterFogColor(), 16));
        newFog.d(biomeType.getSkyColor().equals("") ? forestbiome.a() : Integer.parseInt(biomeType.getSkyColor(), 16));
        newFog.e(biomeType.getFoliageColor().equals("") ? forestbiome.g() : Integer.parseInt(biomeType.getFoliageColor(), 16));
        newFog.f(biomeType.getGrassColor().equals("") ? Integer.parseInt("79C05A", 16) : Integer.parseInt(biomeType.getGrassColor(), 16));
        newBiome.a(newFog.a());
        dedicatedserver.aV().b(IRegistry.aR).a(newKey, (Object)newBiome.a(), Lifecycle.stable());
    }
}

