/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_18_R1;

import org.bukkit.Keyed;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Wall;
import org.bukkit.util.Vector;
import org.terraform.coregen.BlockDataFixerAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.utils.BlockUtils;

public class BlockDataFixer
extends BlockDataFixerAbstract {
    @Override
    public String updateSchematic(double schematicVersion, String schematic) {
        return schematic;
    }

    @Override
    public void correctFacing(Vector v, SimpleBlock b, BlockData data, BlockFace face) {
        if (data == null && b != null) {
            data = b.getBlockData();
        }
        if (!this.hasFlushed && data instanceof Wall) {
            this.pushChanges(v);
            return;
        }
        if (data instanceof Wall && b != null) {
            BlockDataFixer.correctSurroundingWallData(b);
        }
    }

    public static void correctWallData(SimpleBlock target) {
        if (!(target.getBlockData() instanceof Wall)) {
            return;
        }
        Wall data = (Wall)target.getBlockData();
        for (BlockFace face : BlockUtils.directBlockFaces) {
            if (target.getRelative(face).getType().isSolid() && !target.getRelative(face).getType().toString().contains("PRESSURE_PLATE")) {
                data.setHeight(face, Wall.Height.LOW);
                if (!target.getRelative(BlockFace.UP).getType().isSolid()) continue;
                data.setHeight(face, Wall.Height.TALL);
                continue;
            }
            data.setHeight(face, Wall.Height.NONE);
        }
    }

    public static void correctSurroundingWallData(SimpleBlock target) {
        if (!(target.getBlockData() instanceof Wall)) {
            return;
        }
        BlockDataFixer.correctWallData(target);
        for (BlockFace face : BlockUtils.directBlockFaces) {
            if (!Tag.WALLS.isTagged((Keyed)target.getRelative(face).getType())) continue;
            BlockDataFixer.correctWallData(target.getRelative(face));
        }
    }
}

