/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_17_R1;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.Registry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.BiomeStorage;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftBlock;
import org.bukkit.generator.ChunkGenerator;
import org.terraform.biome.custombiomes.CustomBiomeSupportedBiomeGrid;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.TerraformPopulator;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.data.MegaChunk;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfigOption;
import org.terraform.structure.StructureLocator;
import org.terraform.structure.monument.MonumentPopulator;
import org.terraform.structure.pillager.mansion.MansionPopulator;
import org.terraform.structure.small.buriedtreasure.BuriedTreasurePopulator;
import org.terraform.structure.stronghold.StrongholdPopulator;
import org.terraform.v1_17_R1.CustomBiomeSource;
import org.terraform.v1_17_R1.PopulatorData;

public class NMSChunkGenerator
extends ChunkGenerator {
    private static Class<?> chunkDataClass = null;
    private static Method getTiles;
    private static Method getTypeId;
    private final ChunkGenerator delegate;
    private final WorldServer world;
    private final TerraformPopulator pop;
    private final TerraformWorld tw;
    private static boolean debug;
    private static Field biomeBaseRegistry;

    public NMSChunkGenerator(String worldname, int seed, ChunkGenerator delegate, WorldChunkManager worldchunkmanager, WorldChunkManager worldchunkmanager1, StructureSettings structuresettings, long i) {
        super((WorldChunkManager)new CustomBiomeSource(worldchunkmanager), (WorldChunkManager)new CustomBiomeSource(worldchunkmanager1), structuresettings, i);
        if (chunkDataClass == null) {
            try {
                chunkDataClass = Class.forName("org.bukkit.craftbukkit.v1_17_R1.generator.OldCraftChunkData");
                TerraformGeneratorPlugin.logger.stdout("Detected new worldgen API. Adjusting accordingly.");
            }
            catch (ClassNotFoundException e) {
                try {
                    chunkDataClass = Class.forName("org.bukkit.craftbukkit.v1_17_R1.generator.CraftChunkData");
                    TerraformGeneratorPlugin.logger.stdout("Detected old worldgen API. Adjusting accordingly.");
                }
                catch (ClassNotFoundException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                getTiles = chunkDataClass.getDeclaredMethod("getTiles", new Class[0]);
                getTiles.setAccessible(true);
                getTypeId = chunkDataClass.getDeclaredMethod("getTypeId", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException | SecurityException e1) {
                e1.printStackTrace();
            }
        }
        this.tw = TerraformWorld.get(worldname, seed);
        this.delegate = delegate;
        this.pop = new TerraformPopulator(this.tw);
        this.world = ((CraftWorld)Bukkit.getWorld((String)worldname)).getHandle();
        try {
            this.modifyCaveCarverLists(WorldGenCarverAbstract.a);
            this.modifyCaveCarverLists(WorldGenCarverAbstract.b);
            this.modifyCaveCarverLists(WorldGenCarverAbstract.c);
            this.modifyCaveCarverLists(WorldGenCarverAbstract.d);
            this.modifyCaveCarverLists(WorldGenCarverAbstract.e);
        }
        catch (Exception e) {
            TerraformGeneratorPlugin.logger.error("Failed to modify vanilla cave carver lists. You may see floating blocks above caves.");
            e.printStackTrace();
        }
    }

    public TerraformWorld getTerraformWorld() {
        return this.tw;
    }

    public void createBiomes(IRegistry<BiomeBase> iregistry, IChunkAccess ichunkaccess) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.getPos();
        ((ProtoChunk)ichunkaccess).a(new BiomeStorage(iregistry, (LevelHeightAccessor)ichunkaccess, chunkcoordintpair, this.c));
    }

    public BlockPosition findNearestMapFeature(WorldServer worldserver, StructureGenerator<?> structuregenerator, BlockPosition blockposition, int i, boolean flag) {
        int pX = blockposition.getX();
        int pZ = blockposition.getZ();
        TerraformGeneratorPlugin.logger.info("Vanilla locate for " + structuregenerator.getClass().getName() + " invoked.");
        if (structuregenerator == StructureGenerator.k) {
            int[] coords = new StrongholdPopulator().getNearestFeature(this.tw, pX, pZ);
            return new BlockPosition(coords[0], 20, coords[1]);
        }
        if (!TConfigOption.DEVSTUFF_VANILLA_LOCATE_DISABLE.getBoolean()) {
            if (structuregenerator == StructureGenerator.l) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new MonumentPopulator(), TConfigOption.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS.getInt());
                return new BlockPosition(coords[0], 50, coords[1]);
            }
            if (structuregenerator == StructureGenerator.d) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new MansionPopulator(), TConfigOption.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS.getInt());
                return new BlockPosition(coords[0], 50, coords[1]);
            }
            if (structuregenerator.getClass().getName().equals("net.minecraft.world.level.levelgen.feature.WorldGenBuriedTreasure")) {
                int[] coords = StructureLocator.locateMultiMegaChunkStructure(this.tw, new MegaChunk(pX, 0, pZ), new BuriedTreasurePopulator(), TConfigOption.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS.getInt());
                return new BlockPosition(coords[0], 50, coords[1]);
            }
        }
        return null;
    }

    public void addDecorations(RegionLimitedWorldAccess rlwa, StructureManager structuremanager) {
        int chunkX = rlwa.a().b;
        int chunkZ = rlwa.a().c;
        PopulatorData popDat = new PopulatorData(rlwa, this, chunkX, chunkZ);
        this.pop.populate(this.tw, rlwa.getRandom(), popDat);
    }

    public void doCarving(long i, BiomeManager biomemanager, IChunkAccess ichunkaccess, WorldGenStage.Features worldgenstage_features) {
        super.doCarving(i, biomemanager, ichunkaccess, worldgenstage_features);
    }

    private void modifyCaveCarverLists(WorldGenCarverAbstract<?> carverAbstract) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ImmutableSet immutableCarverList = ImmutableSet.of((Object)Blocks.b, (Object)Blocks.c, (Object)Blocks.e, (Object)Blocks.g, (Object)Blocks.j, (Object)Blocks.k, (Object[])new Block[]{Blocks.l, Blocks.i, Blocks.hf, Blocks.fS, Blocks.fT, Blocks.fU, Blocks.fV, Blocks.fW, Blocks.fX, Blocks.fY, Blocks.fZ, Blocks.ga, Blocks.gb, Blocks.gc, Blocks.gd, Blocks.ge, Blocks.gf, Blocks.gg, Blocks.gh, Blocks.az, Blocks.hU, Blocks.ec, Blocks.cK, Blocks.hh, Blocks.pN, Blocks.oL, Blocks.c, Blocks.H, Blocks.I, Blocks.qj, Blocks.oU, Blocks.oV, Blocks.qk, Blocks.D, Blocks.ij, Blocks.ie, Blocks.lJ, Blocks.lO, Blocks.m, Blocks.iS, Blocks.cM, Blocks.bP});
        Field field = WorldGenCarverAbstract.class.getDeclaredField("k");
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        field.set(carverAbstract, immutableCarverList);
    }

    public int getSeaLevel() {
        return TerraformGenerator.seaLevel;
    }

    public void createStructures(IRegistryCustom iregistrycustom, StructureManager structuremanager, IChunkAccess ichunkaccess, DefinedStructureManager definedstructuremanager, long i) {
    }

    public int getSpawnHeight(LevelHeightAccessor levelheightaccessor) {
        return 64;
    }

    public CompletableFuture<IChunkAccess> buildNoise(Executor executor, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildBase(RegionLimitedWorldAccess regionlimitedworldaccess, IChunkAccess ichunkaccess) {
        try {
            ChunkGenerator.ChunkData data;
            TerraformGenerator generator = new TerraformGenerator();
            int x = ichunkaccess.getPos().b;
            int z = ichunkaccess.getPos().c;
            Random random = this.tw.getRand(3L);
            random.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
            CustomBiomeGrid biomegrid = new CustomBiomeGrid(new BiomeStorage((Registry)this.world.t().d(IRegistry.aO), (LevelHeightAccessor)regionlimitedworldaccess, ichunkaccess.getPos(), this.getWorldChunkManager()));
            if (generator.isParallelCapable()) {
                data = generator.generateChunkData((World)this.world.getWorld(), random, x, z, biomegrid);
            } else {
                NMSChunkGenerator nMSChunkGenerator = this;
                synchronized (nMSChunkGenerator) {
                    data = generator.generateChunkData((World)this.world.getWorld(), random, x, z, biomegrid);
                }
            }
            Method getRawChunkData = chunkDataClass.getDeclaredMethod("getRawChunkData", new Class[0]);
            getRawChunkData.setAccessible(true);
            ChunkSection[] sections = (ChunkSection[])getRawChunkData.invoke((Object)data, new Object[0]);
            ChunkSection[] csect = ichunkaccess.getSections();
            int scnt = Math.min(csect.length, sections.length);
            for (int sec = 0; sec < scnt; ++sec) {
                ChunkSection section;
                if (sections[sec] == null) continue;
                csect[sec] = section = sections[sec];
            }
            ((ProtoChunk)ichunkaccess).a(biomegrid.biome);
            Set tiles = (Set)getTiles.invoke((Object)data, new Object[0]);
            if (tiles != null) {
                for (BlockPosition pos : tiles) {
                    int tx = pos.getX();
                    int ty = pos.getY();
                    int tz = pos.getZ();
                    IBlockData block = (IBlockData)getTypeId.invoke((Object)data, tx, ty, tz);
                    if (!block.isTileEntity()) continue;
                    TileEntity tile = ((ITileEntity)block).createTile(new BlockPosition((x << 4) + tx, ty, (z << 4) + tz), block);
                    ichunkaccess.setTileEntity(tile);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public WeightedRandomList getMobsFor(BiomeBase biomebase, StructureManager structuremanager, EnumCreatureType enumcreaturetype, BlockPosition blockposition) {
        if (structuremanager.a(blockposition, true, (StructureGenerator)StructureGenerator.j).e()) {
            if (enumcreaturetype == EnumCreatureType.a) {
                return StructureGenerator.j.c();
            }
            if (enumcreaturetype == EnumCreatureType.b) {
                return StructureGenerator.j.h();
            }
        }
        if (enumcreaturetype == EnumCreatureType.a) {
            if (structuremanager.a(blockposition, false, StructureGenerator.b).e()) {
                return StructureGenerator.b.c();
            }
            if (structuremanager.a(blockposition, false, StructureGenerator.l).e()) {
                return StructureGenerator.l.c();
            }
            if (structuremanager.a(blockposition, true, StructureGenerator.n).e()) {
                return StructureGenerator.n.c();
            }
        }
        return biomebase.b().a(enumcreaturetype);
    }

    public int getBaseHeight(int x, int z, HeightMap.Type var2, LevelHeightAccessor var3) {
        return HeightMap.getBlockHeight(this.tw, x, z);
    }

    protected Codec<? extends ChunkGenerator> a() {
        return ChunkGeneratorAbstract.d;
    }

    public BlockColumn getBaseColumn(int var0, int var1, LevelHeightAccessor var2) {
        return this.delegate.getBaseColumn(var0, var1, var2);
    }

    public ChunkGenerator withSeed(long arg0) {
        return new NMSChunkGenerator(this.tw.getName(), (int)arg0, this.delegate, this.getWorldChunkManager(), this.getWorldChunkManager(), this.getSettings(), 0L);
    }

    static {
        debug = true;
        biomeBaseRegistry = null;
    }

    private class CustomBiomeGrid
    extends CustomBiomeSupportedBiomeGrid
    implements ChunkGenerator.BiomeGrid {
        private final BiomeStorage biome;

        public CustomBiomeGrid(BiomeStorage biome) {
            this.biome = biome;
            if (biomeBaseRegistry == null) {
                try {
                    biomeBaseRegistry = BiomeStorage.class.getField("registry");
                }
                catch (NoSuchFieldException e) {
                    try {
                        biomeBaseRegistry = BiomeStorage.class.getField("e");
                    }
                    catch (Throwable e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }

        public Biome getBiome(int x, int z) {
            return this.getBiome(x, 0, z);
        }

        public void setBiome(int x, int z, Biome bio) {
            for (int y = 0; y < NMSChunkGenerator.this.tw.getWorld().getMaxHeight(); ++y) {
                this.setBiome(x, y, z, bio);
            }
        }

        public Biome getBiome(int x, int y, int z) {
            try {
                BiomeBase sad;
                if (debug && (sad = this.biome.getBiome(x >> 2, y >> 2, z >> 2)).g() == 0xFF0000) {
                    TerraformGeneratorPlugin.logger.info("GET-biome called! Water color correct.");
                    debug = false;
                }
                return CraftBlock.biomeBaseToBiome((IRegistry)((IRegistry)biomeBaseRegistry.get(this.biome)), (BiomeBase)this.biome.getBiome(x >> 2, y >> 2, z >> 2));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                return null;
            }
        }

        public void setBiome(int x, int y, int z, Biome bio) {
            try {
                this.biome.setBiome(x >> 2, y >> 2, z >> 2, CraftBlock.biomeToBiomeBase((IRegistry)((IRegistry)biomeBaseRegistry.get(this.biome)), (Biome)bio));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void setBiome(int x, int y, int z, CustomBiomeType bio, Biome fallback) {
            ResourceKey rkey;
            BiomeBase base = null;
            DedicatedServer dedicatedserver = ((CraftServer)Bukkit.getServer()).getServer();
            IRegistryWritable registrywritable = dedicatedserver.getCustomRegistry().b(IRegistry.aO);
            base = (BiomeBase)registrywritable.a(rkey = ResourceKey.a((ResourceKey)IRegistry.aO, (MinecraftKey)new MinecraftKey(bio.getKey())));
            if (base == null) {
                String[] split = bio.getKey().split(":");
                ResourceKey newrkey = ResourceKey.a((ResourceKey)IRegistry.aO, (MinecraftKey)new MinecraftKey(split[0], split[1]));
                base = (BiomeBase)registrywritable.a(newrkey);
            }
            if (base != null) {
                this.biome.setBiome(x >> 2, y >> 2, z >> 2, base);
            } else {
                this.setBiome(x, y, z, fallback);
            }
        }
    }
}

