/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_16_R3;

import java.util.Random;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.Blocks;
import net.minecraft.server.v1_16_R3.ChunkCoordIntPair;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityMinecartChest;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumMobSpawn;
import net.minecraft.server.v1_16_R3.IBlockAccess;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.IChunkAccess;
import net.minecraft.server.v1_16_R3.LootTables;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.StructureGenerator;
import net.minecraft.server.v1_16_R3.StructureStart;
import net.minecraft.server.v1_16_R3.TileEntity;
import net.minecraft.server.v1_16_R3.TileEntityLootable;
import net.minecraft.server.v1_16_R3.TileEntityMobSpawner;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldAccess;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;
import org.bukkit.entity.EntityType;
import org.terraform.coregen.NaturalSpawnType;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataICAAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.v1_16_R3.TerraStructureStart;

public class PopulatorDataICA
extends PopulatorDataICAAbstract {
    private final IChunkAccess ica;
    private final int chunkX;
    private final int chunkZ;
    private final WorldServer ws;
    private final TerraformWorld tw;

    public PopulatorDataICA(TerraformWorld tw, WorldServer ws, IChunkAccess ica, int chunkX, int chunkZ) {
        this.ica = ica;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.ws = ws;
        this.tw = tw;
    }

    private static MinecraftKey getLootTable(TerraLootTable table) {
        switch (table) {
            case SPAWN_BONUS_CHEST: {
                return LootTables.b;
            }
            case END_CITY_TREASURE: {
                return LootTables.c;
            }
            case SIMPLE_DUNGEON: {
                return LootTables.d;
            }
            case VILLAGE_WEAPONSMITH: {
                return LootTables.e;
            }
            case VILLAGE_TOOLSMITH: {
                return LootTables.f;
            }
            case VILLAGE_ARMORER: {
                return LootTables.g;
            }
            case VILLAGE_CARTOGRAPHER: {
                return LootTables.h;
            }
            case VILLAGE_MASON: {
                return LootTables.i;
            }
            case VILLAGE_SHEPHERD: {
                return LootTables.j;
            }
            case VILLAGE_BUTCHER: {
                return LootTables.k;
            }
            case VILLAGE_FLETCHER: {
                return LootTables.l;
            }
            case VILLAGE_FISHER: {
                return LootTables.m;
            }
            case VILLAGE_TANNERY: {
                return LootTables.n;
            }
            case VILLAGE_TEMPLE: {
                return LootTables.o;
            }
            case VILLAGE_DESERT_HOUSE: {
                return LootTables.p;
            }
            case VILLAGE_PLAINS_HOUSE: {
                return LootTables.q;
            }
            case VILLAGE_TAIGA_HOUSE: {
                return LootTables.r;
            }
            case VILLAGE_SNOWY_HOUSE: {
                return LootTables.s;
            }
            case VILLAGE_SAVANNA_HOUSE: {
                return LootTables.t;
            }
            case ABANDONED_MINESHAFT: {
                return LootTables.u;
            }
            case NETHER_BRIDGE: {
                return LootTables.v;
            }
            case STRONGHOLD_LIBRARY: {
                return LootTables.w;
            }
            case STRONGHOLD_CROSSING: {
                return LootTables.x;
            }
            case STRONGHOLD_CORRIDOR: {
                return LootTables.y;
            }
            case DESERT_PYRAMID: {
                return LootTables.z;
            }
            case JUNGLE_TEMPLE: {
                return LootTables.A;
            }
            case JUNGLE_TEMPLE_DISPENSER: {
                return LootTables.B;
            }
            case IGLOO_CHEST: {
                return LootTables.C;
            }
            case WOODLAND_MANSION: {
                return LootTables.D;
            }
            case UNDERWATER_RUIN_SMALL: {
                return LootTables.E;
            }
            case UNDERWATER_RUIN_BIG: {
                return LootTables.F;
            }
            case BURIED_TREASURE: {
                return LootTables.G;
            }
            case SHIPWRECK_MAP: {
                return LootTables.H;
            }
            case SHIPWRECK_SUPPLY: {
                return LootTables.I;
            }
            case SHIPWRECK_TREASURE: {
                return LootTables.J;
            }
            case PILLAGER_OUTPOST: {
                return LootTables.K;
            }
            case RUINED_PORTAL: {
                return LootTables.P;
            }
        }
        return null;
    }

    @Override
    public Material getType(int x, int y, int z) {
        IBlockData ibd = this.ica.getType(new BlockPosition(x, y, z));
        return CraftBlockData.fromData((IBlockData)ibd).getMaterial();
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        IBlockData ibd = this.ica.getType(new BlockPosition(x, y, z));
        return CraftBlockData.fromData((IBlockData)ibd);
    }

    @Override
    public void setType(int x, int y, int z, Material type) {
        this.ica.setType(new BlockPosition(x, y, z), ((CraftBlockData)Bukkit.createBlockData((Material)type)).getState(), false);
    }

    @Override
    public void setBlockData(int x, int y, int z, BlockData data) {
        this.ica.setType(new BlockPosition(x, y, z), ((CraftBlockData)data).getState(), false);
    }

    @Override
    public Biome getBiome(int rawX, int rawZ) {
        return this.tw.getBiomeBank(rawX, rawZ).getHandler().getBiome();
    }

    @Override
    public int getChunkX() {
        return this.chunkX;
    }

    @Override
    public int getChunkZ() {
        return this.chunkZ;
    }

    @Override
    public void addEntity(int rawX, int rawY, int rawZ, EntityType type) {
        try {
            EntityTypes et = (EntityTypes)EntityTypes.class.getDeclaredField(type.toString()).get(null);
            Entity e = et.a((World)this.ws.getMinecraftWorld());
            e.setPositionRotation((double)rawX + 0.5, (double)rawY, (double)rawZ + 0.5, 0.0f, 0.0f);
            if (e instanceof EntityInsentient) {
                ((EntityInsentient)e).setPersistent();
                ((EntityInsentient)e).prepare((WorldAccess)this.ws, this.ws.getDamageScaler(new BlockPosition(rawX, rawY, rawZ)), EnumMobSpawn.STRUCTURE, null, null);
            }
            this.ws.addEntity(e);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void setSpawner(int rawX, int rawY, int rawZ, EntityType type) {
        BlockPosition pos = new BlockPosition(rawX, rawY, rawZ);
        this.ica.setType(pos, Blocks.SPAWNER.getBlockData(), true);
        TileEntity tileentity = this.ica.getTileEntity(pos);
        if (tileentity instanceof TileEntityMobSpawner) {
            try {
                ((TileEntityMobSpawner)tileentity).getSpawner().setMobName((EntityTypes)EntityTypes.class.getField(type.toString()).get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        } else {
            TerraformGeneratorPlugin.logger.error("Failed to fetch mob spawner entity at (," + pos.getX() + "," + pos.getY() + "," + pos.getZ() + ")");
        }
    }

    @Override
    public void lootTableChest(int x, int y, int z, TerraLootTable table) {
        BlockPosition pos = new BlockPosition(x, y, z);
        TileEntityLootable.a((IBlockAccess)this.ica, (Random)this.tw.getHashedRand(x, y, z), (BlockPosition)pos, (MinecraftKey)PopulatorDataICA.getLootTable(table));
    }

    @Override
    public void registerNaturalSpawns(NaturalSpawnType type, int x0, int y0, int z0, int x1, int y1, int z1) {
        StructureGenerator generator = StructureGenerator.MONUMENT;
        switch (type) {
            case GUARDIAN: {
                generator = StructureGenerator.MONUMENT;
                break;
            }
            case PILLAGER: {
                generator = StructureGenerator.PILLAGER_OUTPOST;
            }
        }
        TerraStructureStart start = new TerraStructureStart(generator, this.chunkX, this.chunkZ, null, z1, z1);
        start.setStructureBounds(x0, y0, z0, x1, y1, z1);
        IChunkAccess sa = this.ica;
        sa.a(generator, (StructureStart)start);
        sa.a(generator, new ChunkCoordIntPair(this.chunkX, this.chunkZ).pair());
    }

    @Override
    public void spawnMinecartWithChest(int x, int y, int z, TerraLootTable table, Random random) {
        EntityMinecartChest entityminecartchest = new EntityMinecartChest((World)this.ws.getMinecraftWorld(), (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f));
        entityminecartchest.setLootTable(PopulatorDataICA.getLootTable(table), random.nextLong());
        this.ws.addEntity((Entity)entityminecartchest);
    }

    @Override
    public TerraformWorld getTerraformWorld() {
        return this.tw;
    }
}

