/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.v1_16_R3;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.server.v1_16_R3.BiomeBase;
import net.minecraft.server.v1_16_R3.BiomeManager;
import net.minecraft.server.v1_16_R3.BiomeSettingsGeneration;
import net.minecraft.server.v1_16_R3.BiomeSettingsMobs;
import net.minecraft.server.v1_16_R3.BiomeStorage;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.Blocks;
import net.minecraft.server.v1_16_R3.ChunkCoordIntPair;
import net.minecraft.server.v1_16_R3.ChunkGenerator;
import net.minecraft.server.v1_16_R3.ChunkGeneratorAbstract;
import net.minecraft.server.v1_16_R3.ChunkSection;
import net.minecraft.server.v1_16_R3.DefinedStructureManager;
import net.minecraft.server.v1_16_R3.EnumCreatureType;
import net.minecraft.server.v1_16_R3.GeneratorAccess;
import net.minecraft.server.v1_16_R3.HeightMap;
import net.minecraft.server.v1_16_R3.IBlockAccess;
import net.minecraft.server.v1_16_R3.IChunkAccess;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.IRegistryCustom;
import net.minecraft.server.v1_16_R3.ITileEntity;
import net.minecraft.server.v1_16_R3.ProtoChunk;
import net.minecraft.server.v1_16_R3.RegionLimitedWorldAccess;
import net.minecraft.server.v1_16_R3.Registry;
import net.minecraft.server.v1_16_R3.SeededRandom;
import net.minecraft.server.v1_16_R3.StructureGenerator;
import net.minecraft.server.v1_16_R3.StructureManager;
import net.minecraft.server.v1_16_R3.StructureSettings;
import net.minecraft.server.v1_16_R3.TileEntity;
import net.minecraft.server.v1_16_R3.WorldChunkManager;
import net.minecraft.server.v1_16_R3.WorldGenCanyonOcean;
import net.minecraft.server.v1_16_R3.WorldGenCarverAbstract;
import net.minecraft.server.v1_16_R3.WorldGenCarverWrapper;
import net.minecraft.server.v1_16_R3.WorldGenCavesOcean;
import net.minecraft.server.v1_16_R3.WorldGenStage;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.generator.CraftChunkData;
import org.bukkit.generator.ChunkGenerator;
import org.terraform.biome.BiomeType;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.TerraformPopulator;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.data.MegaChunk;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfigOption;
import org.terraform.structure.StructureLocator;
import org.terraform.structure.monument.MonumentPopulator;
import org.terraform.structure.pillager.mansion.MansionPopulator;
import org.terraform.structure.small.buriedtreasure.BuriedTreasurePopulator;
import org.terraform.structure.stronghold.StrongholdPopulator;
import org.terraform.v1_16_R3.PopulatorData;

public class NMSChunkGenerator
extends ChunkGenerator {
    private final WorldServer world;
    private final TerraformPopulator pop;
    private final TerraformWorld tw;
    private static Field biomeBaseRegistry = null;

    public NMSChunkGenerator(String worldname, int seed, WorldChunkManager worldchunkmanager, WorldChunkManager worldchunkmanager1, StructureSettings structuresettings, long i) {
        super(worldchunkmanager, worldchunkmanager1, structuresettings, i);
        this.tw = TerraformWorld.get(worldname, seed);
        this.pop = new TerraformPopulator(this.tw);
        this.world = ((CraftWorld)Bukkit.getWorld((String)worldname)).getHandle();
        try {
            this.modifyCaveCarverLists(WorldGenCarverAbstract.a);
            this.modifyCaveCarverLists(WorldGenCarverAbstract.b);
            this.modifyCaveCarverLists(WorldGenCarverAbstract.c);
            this.modifyCaveCarverLists(WorldGenCarverAbstract.d);
            this.modifyCaveCarverLists(WorldGenCarverAbstract.e);
        }
        catch (Exception e) {
            TerraformGeneratorPlugin.logger.error("Failed to modify vanilla cave carver lists. You may see floating blocks above caves.");
            e.printStackTrace();
        }
    }

    public TerraformWorld getTerraformWorld() {
        return this.tw;
    }

    public void createBiomes(IRegistry<BiomeBase> iregistry, IChunkAccess ichunkaccess) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.getPos();
        ((ProtoChunk)ichunkaccess).a(new BiomeStorage(iregistry, chunkcoordintpair, this.c));
    }

    public BlockPosition findNearestMapFeature(WorldServer worldserver, StructureGenerator<?> structuregenerator, BlockPosition blockposition, int i, boolean flag) {
        int pX = blockposition.getX();
        int pZ = blockposition.getZ();
        if (structuregenerator == StructureGenerator.STRONGHOLD) {
            int[] coords = new StrongholdPopulator().getNearestFeature(this.tw, pX, pZ);
            return new BlockPosition(coords[0], 20, coords[1]);
        }
        if (!TConfigOption.DEVSTUFF_VANILLA_LOCATE_DISABLE.getBoolean()) {
            if (structuregenerator == StructureGenerator.MONUMENT) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new MonumentPopulator(), TConfigOption.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS.getInt());
                return new BlockPosition(coords[0], 50, coords[1]);
            }
            if (structuregenerator == StructureGenerator.MANSION) {
                int[] coords = StructureLocator.locateSingleMegaChunkStructure(this.tw, pX, pZ, new MansionPopulator(), TConfigOption.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS.getInt());
                return new BlockPosition(coords[0], 50, coords[1]);
            }
            if (structuregenerator == StructureGenerator.BURIED_TREASURE) {
                int[] coords = StructureLocator.locateMultiMegaChunkStructure(this.tw, new MegaChunk(pX, 0, pZ), new BuriedTreasurePopulator(), TConfigOption.DEVSTUFF_VANILLA_LOCATE_TIMEOUTMILLIS.getInt());
                return new BlockPosition(coords[0], 50, coords[1]);
            }
        }
        return null;
    }

    public void addDecorations(RegionLimitedWorldAccess rlwa, StructureManager structuremanager) {
        int chunkX = rlwa.a();
        int chunkZ = rlwa.b();
        PopulatorData popDat = new PopulatorData(rlwa, this, chunkX, chunkZ);
        this.pop.populate(this.tw, rlwa.getRandom(), popDat);
    }

    public void doCarving(long i, BiomeManager biomemanager, IChunkAccess ichunkaccess, WorldGenStage.Features worldgenstage_features) {
        BiomeManager biomemanager1 = biomemanager.a(this.b);
        SeededRandom seededrandom = new SeededRandom();
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.getPos();
        int j = chunkcoordintpair.x;
        int k = chunkcoordintpair.z;
        BiomeBase nmsBiomeBase = this.b.getBiome(chunkcoordintpair.x << 2, 0, chunkcoordintpair.z << 2);
        BiomeSettingsGeneration biomesettingsgeneration = nmsBiomeBase.e();
        BitSet bitset = ((ProtoChunk)ichunkaccess).b(worldgenstage_features);
        for (int l = j - 8; l <= j + 8; ++l) {
            for (int i1 = k - 8; i1 <= k + 8; ++i1) {
                List list = biomesettingsgeneration.a(worldgenstage_features);
                ListIterator listiterator = list.listIterator();
                while (listiterator.hasNext()) {
                    int j1 = listiterator.nextIndex();
                    WorldGenCarverWrapper worldgencarverwrapper = (WorldGenCarverWrapper)((Supplier)listiterator.next()).get();
                    try {
                        Class<?> carverType;
                        Field field = WorldGenCarverWrapper.class.getDeclaredField("d");
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        if (!((carverType = field.get(worldgencarverwrapper).getClass()) != WorldGenCanyonOcean.class && carverType != WorldGenCavesOcean.class || (this.tw.getBiomeBank(j << 4, k << 4).getType() == BiomeType.OCEANIC || this.tw.getBiomeBank(j << 4, k << 4).getType() == BiomeType.DEEP_OCEANIC) && TConfigOption.CAVES_ALLOW_FLOODED_CAVES.getBoolean())) {
                            continue;
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                        e.printStackTrace();
                    }
                    seededrandom.c(i + (long)j1, l, i1);
                    if (!worldgencarverwrapper.a((Random)seededrandom, l, i1)) continue;
                    worldgencarverwrapper.a(ichunkaccess, arg_0 -> ((BiomeManager)biomemanager1).a(arg_0), (Random)seededrandom, this.getSeaLevel(), l, i1, j, k, bitset);
                }
            }
        }
    }

    private void modifyCaveCarverLists(WorldGenCarverAbstract carverAbstract) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ImmutableSet immutableCarverList = ImmutableSet.of((Object)Blocks.STONE, (Object)Blocks.GRANITE, (Object)Blocks.DIORITE, (Object)Blocks.ANDESITE, (Object)Blocks.DIRT, (Object)Blocks.COARSE_DIRT, (Object[])new Block[]{Blocks.PODZOL, Blocks.GRASS_BLOCK, Blocks.TERRACOTTA, Blocks.WHITE_TERRACOTTA, Blocks.ORANGE_TERRACOTTA, Blocks.MAGENTA_TERRACOTTA, Blocks.LIGHT_BLUE_TERRACOTTA, Blocks.YELLOW_TERRACOTTA, Blocks.LIME_TERRACOTTA, Blocks.PINK_TERRACOTTA, Blocks.GRAY_TERRACOTTA, Blocks.LIGHT_GRAY_TERRACOTTA, Blocks.CYAN_TERRACOTTA, Blocks.PURPLE_TERRACOTTA, Blocks.BLUE_TERRACOTTA, Blocks.BROWN_TERRACOTTA, Blocks.GREEN_TERRACOTTA, Blocks.RED_TERRACOTTA, Blocks.BLACK_TERRACOTTA, Blocks.SANDSTONE, Blocks.RED_SANDSTONE, Blocks.MYCELIUM, Blocks.SNOW, Blocks.PACKED_ICE, Blocks.RED_SAND, Blocks.COBBLESTONE_SLAB, Blocks.COBBLESTONE, Blocks.GRASS_PATH, Blocks.SNOW_BLOCK, Blocks.MOSSY_COBBLESTONE});
        Field field = WorldGenCarverAbstract.class.getDeclaredField("j");
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        field.set(carverAbstract, immutableCarverList);
    }

    public int getSeaLevel() {
        return TerraformGenerator.seaLevel;
    }

    public void createStructures(IRegistryCustom iregistrycustom, StructureManager structuremanager, IChunkAccess ichunkaccess, DefinedStructureManager definedstructuremanager, long i) {
    }

    public int getSpawnHeight() {
        return this.getBaseHeight(0, 0, null);
    }

    public void buildNoise(GeneratorAccess generatoraccess, StructureManager structuremanager, IChunkAccess ichunkaccess) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildBase(RegionLimitedWorldAccess regionlimitedworldaccess, IChunkAccess ichunkaccess) {
        try {
            ChunkGenerator.ChunkData data;
            int x = ichunkaccess.getPos().x;
            int z = ichunkaccess.getPos().z;
            TerraformGenerator generator = new TerraformGenerator();
            Random random = this.tw.getRand(3L);
            random.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
            CustomBiomeGrid biomegrid = new CustomBiomeGrid(new BiomeStorage((Registry)this.world.r().b(IRegistry.ay), ichunkaccess.getPos(), this.getWorldChunkManager()));
            if (generator.isParallelCapable()) {
                data = generator.generateChunkData(this.tw.getWorld(), random, x, z, biomegrid);
            } else {
                NMSChunkGenerator nMSChunkGenerator = this;
                synchronized (nMSChunkGenerator) {
                    data = generator.generateChunkData(this.tw.getWorld(), random, x, z, biomegrid);
                }
            }
            CraftChunkData craftData = (CraftChunkData)data;
            Method getRawChunkData = CraftChunkData.class.getDeclaredMethod("getRawChunkData", new Class[0]);
            getRawChunkData.setAccessible(true);
            ChunkSection[] sections = (ChunkSection[])getRawChunkData.invoke((Object)craftData, new Object[0]);
            ChunkSection[] csect = ichunkaccess.getSections();
            int scnt = Math.min(csect.length, sections.length);
            for (int sec = 0; sec < scnt; ++sec) {
                ChunkSection section;
                if (sections[sec] == null) continue;
                csect[sec] = section = sections[sec];
            }
            ((ProtoChunk)ichunkaccess).a(biomegrid.biome);
            Method getTiles = CraftChunkData.class.getDeclaredMethod("getTiles", new Class[0]);
            getTiles.setAccessible(true);
            Set tiles = (Set)getTiles.invoke((Object)craftData, new Object[0]);
            if (tiles != null) {
                for (BlockPosition pos : tiles) {
                    int tz;
                    int ty;
                    int tx = pos.getX();
                    Block block = craftData.getTypeId(tx, ty = pos.getY(), tz = pos.getZ()).getBlock();
                    if (!block.isTileEntity()) continue;
                    TileEntity tile = ((ITileEntity)block).createTile((IBlockAccess)((CraftWorld)this.tw.getWorld()).getHandle());
                    ichunkaccess.setTileEntity(new BlockPosition((x << 4) + tx, ty, (z << 4) + tz), tile);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public List<BiomeSettingsMobs.c> getMobsFor(BiomeBase biomebase, StructureManager structuremanager, EnumCreatureType enumcreaturetype, BlockPosition blockposition) {
        if (structuremanager.a(blockposition, true, (StructureGenerator)StructureGenerator.SWAMP_HUT).e()) {
            if (enumcreaturetype == EnumCreatureType.MONSTER) {
                return StructureGenerator.SWAMP_HUT.c();
            }
            if (enumcreaturetype == EnumCreatureType.CREATURE) {
                return StructureGenerator.SWAMP_HUT.j();
            }
        }
        if (enumcreaturetype == EnumCreatureType.MONSTER) {
            if (structuremanager.a(blockposition, false, StructureGenerator.PILLAGER_OUTPOST).e()) {
                return StructureGenerator.PILLAGER_OUTPOST.c();
            }
            if (structuremanager.a(blockposition, false, StructureGenerator.MONUMENT).e()) {
                return StructureGenerator.MONUMENT.c();
            }
            if (structuremanager.a(blockposition, true, StructureGenerator.FORTRESS).e()) {
                return StructureGenerator.FORTRESS.c();
            }
        }
        return super.getMobsFor(biomebase, structuremanager, enumcreaturetype, blockposition);
    }

    public int getBaseHeight(int i, int j, HeightMap.Type heightmap_type) {
        return HeightMap.getBlockHeight(this.tw, i, j);
    }

    protected Codec<? extends ChunkGenerator> a() {
        return ChunkGeneratorAbstract.d;
    }

    public IBlockAccess a(int i, int j) {
        return null;
    }

    private class CustomBiomeGrid
    implements ChunkGenerator.BiomeGrid {
        private final BiomeStorage biome;

        public CustomBiomeGrid(BiomeStorage biome) {
            this.biome = biome;
            if (biomeBaseRegistry == null) {
                try {
                    biomeBaseRegistry = BiomeStorage.class.getField("registry");
                }
                catch (NoSuchFieldException e) {
                    try {
                        biomeBaseRegistry = BiomeStorage.class.getField("g");
                    }
                    catch (Throwable e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }

        public Biome getBiome(int x, int z) {
            return this.getBiome(x, 0, z);
        }

        public void setBiome(int x, int z, Biome bio) {
            for (int y = 0; y < NMSChunkGenerator.this.tw.getWorld().getMaxHeight(); ++y) {
                this.setBiome(x, y, z, bio);
            }
        }

        public Biome getBiome(int x, int y, int z) {
            try {
                return CraftBlock.biomeBaseToBiome((IRegistry)((IRegistry)biomeBaseRegistry.get(this.biome)), (BiomeBase)this.biome.getBiome(x >> 2, y >> 2, z >> 2));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                return null;
            }
        }

        public void setBiome(int x, int y, int z, Biome bio) {
            try {
                this.biome.setBiome(x >> 2, y >> 2, z >> 2, CraftBlock.biomeToBiomeBase((IRegistry)((IRegistry)biomeBaseRegistry.get(this.biome)), (Biome)bio));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }
}

