/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils.version;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.terraform.data.SimpleBlock;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.version.Version;

public class OneOneSevenBlockHandler {
    private static final Material DIRT_PATH = Material.getMaterial((String)"DIRT_PATH") == null ? Material.getMaterial((String)"GRASS_PATH") : Material.getMaterial((String)"DIRT_PATH");
    public static final Material CALCITE = Material.getMaterial((String)"CALCITE") == null ? Material.getMaterial((String)"DIORITE") : Material.getMaterial((String)"CALCITE");
    public static final Material AMETHYST_BLOCK = Material.getMaterial((String)"AMETHYST_BLOCK") == null ? Material.getMaterial((String)"STONE") : Material.getMaterial((String)"AMETHYST_BLOCK");
    public static final Material AMETHYST_CLUSTER = Material.getMaterial((String)"AMETHYST_CLUSTER") == null ? Material.getMaterial((String)"CAVE_AIR") : Material.getMaterial((String)"AMETHYST_CLUSTER");
    public static final Material BUDDING_AMETHYST = Material.getMaterial((String)"BUDDING_AMETHYST") == null ? Material.getMaterial((String)"STONE") : Material.getMaterial((String)"BUDDING_AMETHYST");
    public static final Material POWDER_SNOW = Material.getMaterial((String)"POWDER_SNOW") == null ? Material.getMaterial((String)"SNOW_BLOCK") : Material.getMaterial((String)"POWDER_SNOW");
    public static final Material MOSS_BLOCK = Material.getMaterial((String)"MOSS_BLOCK") == null ? Material.getMaterial((String)"GRASS_BLOCK") : Material.getMaterial((String)"MOSS_BLOCK");
    public static final Material MOSS_CARPET = Material.getMaterial((String)"MOSS_CARPET") == null ? Material.getMaterial((String)"CAVE_AIR") : Material.getMaterial((String)"MOSS_CARPET");
    public static final Material AZALEA = Material.getMaterial((String)"AZALEA") == null ? Material.getMaterial((String)"OAK_SAPLING") : Material.getMaterial((String)"AZALEA");
    public static final Material AZALEA_LEAVES = Material.getMaterial((String)"AZALEA_LEAVES") == null ? Material.getMaterial((String)"OAK_LEAVES") : Material.getMaterial((String)"AZALEA_LEAVES");
    public static final Material FLOWERING_AZALEA = Material.getMaterial((String)"FLOWERING_AZALEA") == null ? Material.getMaterial((String)"OAK_SAPLING") : Material.getMaterial((String)"FLOWERING_AZALEA");
    public static final Material FLOWERING_AZALEA_LEAVES = Material.getMaterial((String)"FLOWERING_AZALEA_LEAVES") == null ? Material.getMaterial((String)"OAK_LEAVES") : Material.getMaterial((String)"FLOWERING_AZALEA_LEAVES");
    public static final Material SPORE_BLOSSOM = Material.getMaterial((String)"SPORE_BLOSSOM") == null ? Material.getMaterial((String)"OAK_LEAVES") : Material.getMaterial((String)"SPORE_BLOSSOM");
    public static final Material ROOTED_DIRT = Material.getMaterial((String)"ROOTED_DIRT") == null ? Material.getMaterial((String)"DIRT") : Material.getMaterial((String)"ROOTED_DIRT");
    public static final Material GLOW_LICHEN = Material.getMaterial((String)"GLOW_LICHEN") == null ? Material.getMaterial((String)"VINE") : Material.getMaterial((String)"GLOW_LICHEN");
    public static final Material CAVE_VINES = Material.getMaterial((String)"CAVE_VINES") == null ? Material.getMaterial((String)"VINE") : Material.getMaterial((String)"CAVE_VINES");
    public static final Material CAVE_VINES_PLANT = Material.getMaterial((String)"CAVE_VINES_PLANT") == null ? Material.getMaterial((String)"VINE") : Material.getMaterial((String)"CAVE_VINES_PLANT");
    public static final Material BIG_DRIPLEAF = Material.getMaterial((String)"BIG_DRIPLEAF") == null ? Material.getMaterial((String)"OAK_LEAVES") : Material.getMaterial((String)"BIG_DRIPLEAF");
    public static final Material BIG_DRIPLEAF_STEM = Material.getMaterial((String)"BIG_DRIPLEAF_STEM") == null ? Material.getMaterial((String)"BAMBOO") : Material.getMaterial((String)"BIG_DRIPLEAF_STEM");
    public static final Material SMALL_DRIPLEAF = Material.getMaterial((String)"SMALL_DRIPLEAF") == null ? Material.getMaterial((String)"GRASS") : Material.getMaterial((String)"SMALL_DRIPLEAF");
    public static final Material HANGING_ROOTS = Material.getMaterial((String)"HANGING_ROOTS") == null ? Material.getMaterial((String)"CAVE_AIR") : Material.getMaterial((String)"HANGING_ROOTS");
    public static final Material POINTED_DRIPSTONE = Material.getMaterial((String)"POINTED_DRIPSTONE") == null ? Material.getMaterial((String)"GRANITE_WALL") : Material.getMaterial((String)"POINTED_DRIPSTONE");
    public static final Material TUFF = Material.getMaterial((String)"TUFF") == null ? Material.getMaterial((String)"STONE") : Material.getMaterial((String)"TUFF");
    public static final Material DEEPSLATE = Material.getMaterial((String)"DEEPSLATE") == null ? Material.getMaterial((String)"STONE") : Material.getMaterial((String)"DEEPSLATE");
    public static final Material COBBLED_DEEPSLATE_STAIRS = Material.getMaterial((String)"COBBLED_DEEPSLATE_STAIRS") == null ? Material.getMaterial((String)"COBBLESTONE_STAIRS") : Material.getMaterial((String)"COBBLED_DEEPSLATE_STAIRS");
    public static final Material COBBLED_DEEPSLATE_WALL = Material.getMaterial((String)"COBBLED_DEEPSLATE_WALL") == null ? Material.getMaterial((String)"COBBLESTONE_WALL") : Material.getMaterial((String)"COBBLED_DEEPSLATE_WALL");
    public static final Material COBBLED_DEEPSLATE_SLAB = Material.getMaterial((String)"COBBLED_DEEPSLATE_SLAB") == null ? Material.getMaterial((String)"COBBLESTONE_SLAB") : Material.getMaterial((String)"COBBLED_DEEPSLATE_SLAB");
    public static final Material POLISHED_DEEPSLATE = Material.getMaterial((String)"POLISHED_DEEPSLATE") == null ? Material.getMaterial((String)"POLISHED_ANDESITE") : Material.getMaterial((String)"POLISHED_DEEPSLATE");
    public static final Material POLISHED_DEEPSLATE_STAIRS = Material.getMaterial((String)"POLISHED_DEEPSLATE_STAIRS") == null ? Material.getMaterial((String)"POLISHED_ANDESITE_STAIRS") : Material.getMaterial((String)"POLISHED_DEEPSLATE_STAIRS");
    public static final Material DEEPSLATE_BRICK_STAIRS = Material.getMaterial((String)"DEEPSLATE_BRICK_STAIRS") == null ? Material.getMaterial((String)"POLISHED_ANDESITE_STAIRS") : Material.getMaterial((String)"DEEPSLATE_BRICK_STAIRS");
    public static final Material DEEPSLATE_BRICK_SLAB = Material.getMaterial((String)"DEEPSLATE_BRICK_SLAB") == null ? Material.getMaterial((String)"POLISHED_ANDESITE_SLAB") : Material.getMaterial((String)"DEEPSLATE_BRICK_SLAB");
    public static final Material DEEPSLATE_BRICKS = Material.getMaterial((String)"DEEPSLATE_BRICKS") == null ? Material.getMaterial((String)"STONE_BRICKS") : Material.getMaterial((String)"DEEPSLATE_BRICKS");
    public static final Material CRACKED_DEEPSLATE_BRICKS = Material.getMaterial((String)"CRACKED_DEEPSLATE_BRICKS") == null ? Material.getMaterial((String)"CRACKED_STONE_BRICKS") : Material.getMaterial((String)"CRACKED_DEEPSLATE_BRICKS");
    public static final Material DEEPSLATE_BRICK_WALL = Material.getMaterial((String)"DEEPSLATE_BRICK_WALL") == null ? Material.getMaterial((String)"STONE_BRICK_WALL") : Material.getMaterial((String)"DEEPSLATE_BRICK_WALL");
    public static final Material CHISELED_DEEPSLATE = Material.getMaterial((String)"CHISELED_DEEPSLATE") == null ? Material.getMaterial((String)"CHISELED_STONE_BRICKS") : Material.getMaterial((String)"CHISELED_DEEPSLATE");
    public static final Material DEEPSLATE_TILES = Material.getMaterial((String)"DEEPSLATE_TILES") == null ? Material.getMaterial((String)"STONE_BRICKS") : Material.getMaterial((String)"DEEPSLATE_TILES");
    public static final Material CRACKED_DEEPSLATE_TILES = Material.getMaterial((String)"CRACKED_DEEPSLATE_TILES") == null ? Material.getMaterial((String)"STONE_BRICKS") : Material.getMaterial((String)"CRACKED_DEEPSLATE_TILES");
    public static final Material DEEPSLATE_TILE_STAIRS = Material.getMaterial((String)"DEEPSLATE_TILE_STAIRS") == null ? Material.getMaterial((String)"STONE_BRICK_STAIRS") : Material.getMaterial((String)"DEEPSLATE_TILE_STAIRS");
    public static final Material COPPER_ORE = Material.getMaterial((String)"COPPER_ORE") == null ? Material.getMaterial((String)"STONE") : Material.getMaterial((String)"COPPER_ORE");
    public static final Material DRIPSTONE_BLOCK = Material.getMaterial((String)"DRIPSTONE_BLOCK") == null ? Material.getMaterial((String)"GRANITE") : Material.getMaterial((String)"DRIPSTONE_BLOCK");
    public static final Biome LUSH_CAVES = OneOneSevenBlockHandler.getBiome("LUSH_CAVES", "PLAINS");
    public static final Biome DRIPSTONE_CAVES = OneOneSevenBlockHandler.getBiome("DRIPSTONE_CAVES", "PLAINS");
    public static final Material CANDLE = Material.getMaterial((String)"CANDLE") == null ? Material.getMaterial((String)"TORCH") : Material.getMaterial((String)"CANDLE");
    public static Method setCandlesMethod = null;
    private static final HashMap<String, Material> deepslateMap = new HashMap();

    private static Biome getBiome(String name, String fallback) {
        try {
            return Biome.valueOf((String)name);
        }
        catch (IllegalArgumentException e) {
            return Biome.valueOf((String)fallback);
        }
    }

    public static void placeCandle(SimpleBlock block, int numCandles, boolean lit) {
        if (Version.isAtLeast(17.0)) {
            Lightable candle = (Lightable)Bukkit.createBlockData((Material)CANDLE);
            candle.setLit(lit);
            try {
                if (setCandlesMethod == null) {
                    setCandlesMethod = Class.forName("org.bukkit.block.data.type.Candle").getMethod("setCandles", Integer.TYPE);
                }
                setCandlesMethod.invoke((Object)candle, numCandles);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            block.setBlockData((BlockData)candle);
        } else {
            block.setType(Material.TORCH);
        }
    }

    public static Material DIRT_PATH() {
        return DIRT_PATH;
    }

    public static void downLCaveVines(int height, SimpleBlock base) {
        int realHeight = 0;
        while (!base.getRelative(0, -realHeight, 0).getType().isSolid() && height > 0) {
            ++realHeight;
            --height;
        }
        if (base.getRelative(0, -realHeight, 0).getType().isSolid()) {
            --realHeight;
        }
        if (realHeight <= 0) {
            return;
        }
        for (int i = realHeight; i > 0; --i) {
            Material vine = CAVE_VINES_PLANT;
            if (i == 1) {
                vine = CAVE_VINES;
            }
            if (!BlockUtils.isAir(base.getRelative(0, -(realHeight - i), 0).getType())) continue;
            base.getRelative(0, -(realHeight - i), 0).setBlockData(OneOneSevenBlockHandler.getCaveVine(vine, new Random().nextInt(3) == 0));
        }
    }

    public static void downLPointedDripstone(int height, SimpleBlock base) {
        int realHeight = 0;
        while (!base.getRelative(0, -realHeight, 0).getType().isSolid() && height > 0) {
            ++realHeight;
            --height;
        }
        if (base.getRelative(0, -realHeight, 0).getType().isSolid()) {
            --realHeight;
        }
        if (realHeight <= 0) {
            return;
        }
        for (int i = realHeight; i > 0; --i) {
            PointedDripstoneThickness thickness = PointedDripstoneThickness.middle;
            if (i == 1) {
                thickness = PointedDripstoneThickness.tip;
            }
            if (i == 2) {
                thickness = PointedDripstoneThickness.frustum;
            }
            if (i == realHeight && realHeight > 2) {
                thickness = PointedDripstoneThickness.base;
            }
            base.getRelative(0, -(realHeight - i), 0).setBlockData(OneOneSevenBlockHandler.getPointedDripstone(thickness, false, BlockFace.DOWN));
        }
    }

    public static void upLPointedDripstone(int height, SimpleBlock base) {
        int realHeight = 0;
        while (!base.getRelative(0, realHeight, 0).getType().isSolid() && height > 0) {
            ++realHeight;
            --height;
        }
        if (base.getRelative(0, realHeight, 0).getType().isSolid()) {
            --realHeight;
        }
        if (realHeight <= 0) {
            return;
        }
        for (int i = 0; i < realHeight; ++i) {
            PointedDripstoneThickness thickness = PointedDripstoneThickness.middle;
            if (realHeight >= 4) {
                if (i == realHeight - 1) {
                    thickness = PointedDripstoneThickness.tip;
                }
                if (i == realHeight - 2) {
                    thickness = PointedDripstoneThickness.frustum;
                }
                if (i == 0) {
                    thickness = PointedDripstoneThickness.base;
                }
            } else if (realHeight >= 3) {
                if (i == realHeight - 1) {
                    thickness = PointedDripstoneThickness.tip;
                }
                if (i == realHeight - 2) {
                    thickness = PointedDripstoneThickness.frustum;
                }
                if (i == 0) {
                    thickness = PointedDripstoneThickness.base;
                }
            } else if (realHeight >= 2) {
                thickness = PointedDripstoneThickness.tip;
                if (i == 0) {
                    thickness = PointedDripstoneThickness.frustum;
                }
            } else if (realHeight == 1) {
                thickness = PointedDripstoneThickness.tip;
            }
            base.getRelative(0, i, 0).setBlockData(OneOneSevenBlockHandler.getPointedDripstone(thickness, false, BlockFace.UP));
        }
    }

    public static BlockData getPointedDripstone(PointedDripstoneThickness thickness, boolean waterlogged, BlockFace direction) {
        BlockData data = Bukkit.createBlockData((Material)POINTED_DRIPSTONE);
        String stringData = data.getAsString();
        stringData = StringUtils.replace((String)stringData, (String)"thickness=tip", (String)("thickness=" + thickness.toString()));
        stringData = StringUtils.replace((String)stringData, (String)"vertical_direction=up", (String)("vertical_direction=" + direction.toString().toLowerCase()));
        stringData = StringUtils.replace((String)stringData, (String)"waterlogged=false", (String)("waterlogged=" + waterlogged));
        data = Bukkit.createBlockData((String)stringData);
        return data;
    }

    public static BlockData getCaveVine(Material caveVine, boolean glowBerries) {
        BlockData data = Bukkit.createBlockData((Material)caveVine);
        String stringData = data.getAsString();
        stringData = StringUtils.replace((String)stringData, (String)"berries=false", (String)("berries=" + glowBerries));
        data = Bukkit.createBlockData((String)stringData);
        return data;
    }

    public static Material deepSlateVersion(Material target) {
        if (!Version.isAtLeast(17.0)) {
            return target;
        }
        Material mat = deepslateMap.get("DEEPSLATE_" + target.toString());
        if (mat == null) {
            mat = Material.getMaterial((String)("DEEPSLATE_" + target.toString()));
        }
        if (mat == null) {
            return target;
        }
        deepslateMap.put("DEEPSLATE_" + target.toString(), mat);
        return mat;
    }

    public static enum PointedDripstoneThickness {
        tip,
        frustum,
        middle,
        base;

    }
}

