/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils.noise;

import org.terraform.utils.Vector2f;

public class BezierCurve {
    Vector2f point1 = new Vector2f(0.0f, 0.0f);
    Vector2f control1;
    Vector2f control2;
    Vector2f point2 = new Vector2f(1.0f, 1.0f);

    public BezierCurve(Vector2f control1, Vector2f control2) {
        this.control1 = control1;
        this.control2 = control2;
    }

    public BezierCurve(Vector2f start, Vector2f control1, Vector2f control2, Vector2f end) {
        this.point1 = start;
        this.point2 = end;
        this.control1 = control1;
        this.control2 = control2;
    }

    public BezierCurve(float controlP1x, float controlP1y, float controlP2x, float controlP2y) {
        this.control1 = new Vector2f(controlP1x, controlP1y);
        this.control2 = new Vector2f(controlP2x, controlP2y);
    }

    public static Vector2f quadratic(float progress, Vector2f point1, Vector2f control1, Vector2f point2) {
        float progressBw = 1.0f - progress;
        double x = Math.pow(progressBw, 2.0) * (double)point1.x + (double)(progressBw * 2.0f * progress * control1.x) + (double)(progress * progress * point2.x);
        double y = Math.pow(progressBw, 2.0) * (double)point1.y + (double)(progressBw * 2.0f * progress * control1.y) + (double)(progress * progress * point2.y);
        return new Vector2f((float)x, (float)y);
    }

    public static Vector2f cubic(float progress, Vector2f point1, Vector2f control1, Vector2f control2, Vector2f point2) {
        float progressBw = 1.0f - progress;
        double x = Math.pow(progressBw, 3.0) * (double)point1.x + Math.pow(progressBw, 2.0) * 3.0 * (double)progress * (double)control1.x + (double)(progressBw * 3.0f * progress * progress * control2.x) + (double)(progress * progress * progress * point2.x);
        double y = Math.pow(progressBw, 3.0) * (double)point1.y + Math.pow(progressBw, 2.0) * 3.0 * (double)progress * (double)control1.y + (double)(progressBw * 3.0f * progress * progress * control2.y) + (double)(progress * progress * progress * point2.y);
        return new Vector2f((float)x, (float)y);
    }

    public Vector2f calculate(float progress) {
        return BezierCurve.cubic(progress, this.point1, this.control1, this.control2, this.point2);
    }
}

