/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils.noise;

import java.util.HashMap;
import org.terraform.biome.BiomeBank;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;

public class BasicSmoother {
    private static final int blurRadius = 5;
    private static final int candidateCount = (int)Math.pow(11.0, 2.0);

    private static double getBlurredPixel(TempBlurSource source, int x, int z) {
        double totalHeight = 0.0;
        for (int nx = x - 5; nx <= x + 5; ++nx) {
            for (int nz = z - 5; nz <= z + 5; ++nz) {
                totalHeight += source.getValue(nx, nz);
            }
        }
        return totalHeight / (double)candidateCount;
    }

    public static void applyBlur(TempBlurSource source, int centX, int centZ) {
        int passes = 3;
        TempBlurSource tempSrc = source;
        for (int i = 0; i < passes; ++i) {
            TempBlurSource temp = new HashMapBlurSource();
            if (i == passes - 1) {
                temp = source;
            }
            for (int x = centX - 5; x <= centX + 5; ++x) {
                for (int z = centZ - 5; z <= centZ + 5; ++z) {
                    temp.setValue(x, z, BasicSmoother.getBlurredPixel(tempSrc, x, z));
                }
            }
            tempSrc = temp;
        }
    }

    public static abstract class TempBlurSource {
        public abstract double getValue(int var1, int var2);

        public abstract void setValue(int var1, int var2, double var3);
    }

    public static class HashMapBlurSource
    extends TempBlurSource {
        HashMap<SimpleLocation, Double> map = new HashMap();

        @Override
        public double getValue(int x, int z) {
            return this.map.getOrDefault(new SimpleLocation(x, 0, z), 0.0);
        }

        @Override
        public void setValue(int x, int z, double val) {
            this.map.put(new SimpleLocation(x, 0, z), val);
        }
    }

    public static class HeightMapBlurSource
    extends TempBlurSource {
        TerraformWorld tw;
        int x;
        int z;
        double result = 0.0;

        public HeightMapBlurSource(TerraformWorld tw, int x, int z) {
            this.tw = tw;
            this.x = x;
            this.z = z;
        }

        @Override
        public double getValue(int x, int z) {
            return BiomeBank.getBiomeSectionFromBlockCoords(this.tw, x, z).getBiomeBank().getHandler().calculateHeight(this.tw, x, z);
        }

        @Override
        public void setValue(int x, int z, double val) {
            if (x == this.x && z == this.z) {
                this.result = val;
            }
        }

        public double getResult() {
            return this.result;
        }
    }
}

