/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils.blockdata.fixers;

import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Wall;
import org.bukkit.util.Vector;
import org.terraform.coregen.BlockDataFixerAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.utils.BlockUtils;

public class v1_16_R1_BlockDataFixer
extends BlockDataFixerAbstract {
    public static void correctWallData(SimpleBlock target) {
        BlockFace[] blockFaceArray = target.getBlockData();
        if (!(blockFaceArray instanceof Wall)) {
            return;
        }
        Wall data = (Wall)blockFaceArray;
        for (BlockFace face : BlockUtils.directBlockFaces) {
            Material relType = target.getRelative(face).getType();
            if (!(!relType.isSolid() || Tag.BANNERS.isTagged((Keyed)relType) || Tag.PRESSURE_PLATES.isTagged((Keyed)relType) || Tag.TRAPDOORS.isTagged((Keyed)relType) || Tag.SLABS.isTagged((Keyed)relType))) {
                data.setHeight(face, Wall.Height.LOW);
                if (target.getRelative(BlockFace.UP).getType().isSolid()) {
                    data.setHeight(face, Wall.Height.TALL);
                }
                if (BlockUtils.glassPanes.contains(target.getType()) && (Tag.FENCE_GATES.isTagged((Keyed)relType) || Tag.FENCES.isTagged((Keyed)relType))) {
                    data.setHeight(face, Wall.Height.NONE);
                    continue;
                }
                if (!Tag.FENCES.isTagged((Keyed)target.getType()) && !Tag.FENCE_GATES.isTagged((Keyed)target.getType()) || !BlockUtils.glassPanes.contains(relType)) continue;
                data.setHeight(face, Wall.Height.NONE);
                continue;
            }
            data.setHeight(face, Wall.Height.NONE);
        }
        target.setBlockData((BlockData)data);
    }

    public static void correctSurroundingWallData(SimpleBlock target) {
        if (!(target.getBlockData() instanceof Wall)) {
            return;
        }
        v1_16_R1_BlockDataFixer.correctWallData(target);
        for (BlockFace face : BlockUtils.directBlockFaces) {
            if (!Tag.WALLS.isTagged((Keyed)target.getRelative(face).getType())) continue;
            v1_16_R1_BlockDataFixer.correctWallData(target.getRelative(face));
        }
    }

    @Override
    public String updateSchematic(double schematicVersion, String schematic) {
        return schematic;
    }

    @Override
    public void correctFacing(Vector v, SimpleBlock b, BlockData data, BlockFace face) {
        if (data == null && b != null) {
            data = b.getBlockData();
        }
        if (!this.hasFlushed && data instanceof Wall) {
            this.pushChanges(v);
            return;
        }
        if (data instanceof Wall && b != null) {
            v1_16_R1_BlockDataFixer.correctSurroundingWallData(b);
        }
    }
}

