/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils.blockdata;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.utils.GenUtils;

public class ChestBuilder {
    private final Chest blockData;
    private TerraLootTable lootTable;

    public ChestBuilder(Material mat) {
        this.blockData = (Chest)Bukkit.createBlockData((Material)mat);
    }

    public ChestBuilder(Material ... mat) {
        this.blockData = (Chest)Bukkit.createBlockData((Material)GenUtils.randMaterial(mat));
    }

    public ChestBuilder setLootTable(TerraLootTable ... loottable) {
        this.lootTable = loottable[new Random().nextInt(loottable.length)];
        return this;
    }

    public ChestBuilder setFacing(BlockFace face) {
        this.blockData.setFacing(face);
        return this;
    }

    public ChestBuilder apply(SimpleBlock block) {
        block.setBlockData((BlockData)this.blockData);
        if (this.lootTable != null) {
            block.getPopData().lootTableChest(block.getX(), block.getY(), block.getZ(), this.lootTable);
        }
        return this;
    }

    public void extend(SimpleBlock original, SimpleBlock extended, boolean lootTableExtendedChest) {
        extended.setBlockData((BlockData)this.blockData);
        Wall originalWall = new Wall(original, this.blockData.getFacing());
        Chest originalChest = (Chest)original.getBlockData();
        Chest extendedChest = (Chest)extended.getBlockData();
        if (originalWall.getLeft().equals(extended)) {
            originalChest.setType(Chest.Type.LEFT);
            extendedChest.setType(Chest.Type.RIGHT);
        } else if (originalWall.getRight().equals(extended)) {
            originalChest.setType(Chest.Type.RIGHT);
            extendedChest.setType(Chest.Type.LEFT);
        } else {
            throw new IllegalArgumentException("A request to extend a doublechest was made, but an invalid location was specified.");
        }
        original.setBlockData((BlockData)originalChest);
        extended.setBlockData((BlockData)extendedChest);
        if (this.lootTable != null) {
            original.getPopData().lootTableChest(original.getX(), original.getY(), original.getZ(), this.lootTable);
        }
        if (lootTableExtendedChest && this.lootTable != null) {
            extended.getPopData().lootTableChest(extended.getX(), extended.getY(), extended.getZ(), this.lootTable);
        }
    }

    public ChestBuilder apply(PopulatorDataAbstract data, int x, int y, int z) {
        data.setBlockData(x, y, z, (BlockData)this.blockData);
        if (this.lootTable != null) {
            data.lootTableChest(x, y, z, this.lootTable);
        }
        return this;
    }

    public Chest get() {
        return this.blockData;
    }
}

