/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils.blockdata;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.utils.GenUtils;

public class BisectedBuilder {
    private final Bisected blockData;

    public BisectedBuilder(Material mat) {
        this.blockData = (Bisected)Bukkit.createBlockData((Material)mat);
    }

    public BisectedBuilder(Material ... mat) {
        this.blockData = (Bisected)Bukkit.createBlockData((Material)GenUtils.randMaterial(mat));
    }

    public BisectedBuilder setHalf(Bisected.Half half) {
        this.blockData.setHalf(half);
        return this;
    }

    public BisectedBuilder apply(SimpleBlock block) {
        block.setBlockData((BlockData)this.blockData);
        return this;
    }

    public BisectedBuilder apply(Wall block) {
        block.setBlockData((BlockData)this.blockData);
        return this;
    }

    public BisectedBuilder apply(PopulatorDataAbstract data, int x, int y, int z) {
        data.setBlockData(x, y, z, (BlockData)this.blockData);
        return this;
    }

    public BisectedBuilder placeBoth(PopulatorDataAbstract data, int x, int y, int z) {
        Bisected upper = (Bisected)this.blockData.clone();
        upper.setHalf(Bisected.Half.TOP);
        Bisected lower = (Bisected)this.blockData.clone();
        lower.setHalf(Bisected.Half.BOTTOM);
        data.setBlockData(x, y, z, (BlockData)lower);
        data.setBlockData(x, y + 1, z, (BlockData)upper);
        return this;
    }

    public BisectedBuilder placeBoth(SimpleBlock block) {
        Bisected upper = (Bisected)this.blockData.clone();
        upper.setHalf(Bisected.Half.TOP);
        Bisected lower = (Bisected)this.blockData.clone();
        lower.setHalf(Bisected.Half.BOTTOM);
        block.setBlockData((BlockData)lower);
        block.getRelative(0, 1, 0).setBlockData((BlockData)upper);
        return this;
    }

    public Bisected get() {
        return this.blockData;
    }
}

