/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils.blockdata;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;

public class BarrelBuilder {
    private final BlockData blockData = Bukkit.createBlockData((Material)Material.BARREL);
    private TerraLootTable lootTable;

    public BarrelBuilder setLootTable(TerraLootTable ... loottable) {
        this.lootTable = loottable[new Random().nextInt(loottable.length)];
        return this;
    }

    public BarrelBuilder setFacing(BlockFace face) {
        ((Directional)this.blockData).setFacing(face);
        return this;
    }

    public BarrelBuilder apply(SimpleBlock block) {
        block.setBlockData(this.blockData);
        if (this.lootTable != null) {
            block.getPopData().lootTableChest(block.getX(), block.getY(), block.getZ(), this.lootTable);
        }
        return this;
    }

    public BarrelBuilder apply(PopulatorDataAbstract data, int x, int y, int z) {
        data.setBlockData(x, y, z, this.blockData);
        if (this.lootTable != null) {
            data.lootTableChest(x, y, z, this.lootTable);
        }
        return this;
    }

    public BlockData get() {
        return this.blockData;
    }
}

