/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.util.Vector;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class StalactiteBuilder {
    private Material[] solidBlockType;
    private Material[] wallType;
    private boolean isFacingUp;
    private int verticalSpace;
    private int minRadius = 0;

    public StalactiteBuilder(Material ... wallType) {
        this.wallType = wallType;
    }

    public StalactiteBuilder build(Random rand, Wall w) {
        if (this.verticalSpace < 6) {
            return this;
        }
        int stalactiteHeight = this.verticalSpace > 60 ? GenUtils.randInt(rand, 6, 25) : (this.verticalSpace > 30 ? GenUtils.randInt(rand, 5, 17) : (this.verticalSpace > 15 ? GenUtils.randInt(rand, 3, 10) : GenUtils.randInt(rand, 1, 2)));
        if (stalactiteHeight < 4) {
            if (this.isFacingUp) {
                w.LPillar(stalactiteHeight, rand, this.wallType);
            } else {
                w.downLPillar(rand, stalactiteHeight, this.wallType);
            }
        } else if (stalactiteHeight < 7) {
            if (this.isFacingUp) {
                w.LPillar(stalactiteHeight, rand, this.wallType);
                w.Pillar(GenUtils.randInt(rand, 2, 3), rand, this.solidBlockType);
            } else {
                w.downLPillar(rand, stalactiteHeight, this.wallType);
                w.downPillar(GenUtils.randInt(rand, 2, 3), this.solidBlockType);
            }
        } else if (this.isFacingUp) {
            this.stalagmite(rand, w, GenUtils.randDouble(rand, (double)stalactiteHeight / 6.0, (double)stalactiteHeight / 4.0), stalactiteHeight);
        } else {
            this.stalactite(rand, w, GenUtils.randDouble(rand, (double)stalactiteHeight / 6.0, (double)stalactiteHeight / 4.0), stalactiteHeight);
        }
        return this;
    }

    public StalactiteBuilder setSolidBlockType(Material ... solidBlockType) {
        this.solidBlockType = solidBlockType;
        return this;
    }

    public StalactiteBuilder setWallType(Material ... wallType) {
        this.wallType = wallType;
        return this;
    }

    public StalactiteBuilder setFacingUp(boolean isFacingUp) {
        this.isFacingUp = isFacingUp;
        return this;
    }

    public StalactiteBuilder setMinRadius(int minRadius) {
        this.minRadius = minRadius;
        return this;
    }

    public StalactiteBuilder setVerticalSpace(int verticalSpace) {
        this.verticalSpace = verticalSpace;
        return this;
    }

    public void stalagmite(Random random, Wall w, double baseRadius, int height) {
        baseRadius = Math.max(baseRadius, (double)this.minRadius);
        Vector base = new Vector(w.getX(), w.getY(), w.getZ());
        Vector base2 = new Vector(w.getX(), w.getY() + height, w.getZ());
        Vector v = base2.subtract(base);
        v.clone().multiply(1.0 / v.length());
        SimpleBlock one = w.get();
        double radius = baseRadius;
        for (int i = 0; i <= height; ++i) {
            Vector seg = v.clone().multiply((float)i / (float)height);
            SimpleBlock segment = one.getRelative(seg);
            BlockUtils.replaceSphere(random.nextInt(9999), (float)radius, 2.0f, (float)radius, segment, false, false, this.solidBlockType);
            radius = baseRadius * (1.0 - (double)i / (double)height);
        }
    }

    public void stalactite(Random random, Wall w, double baseRadius, int height) {
        baseRadius = Math.max(baseRadius, (double)this.minRadius);
        Vector base = new Vector(w.getX(), w.getY(), w.getZ());
        Vector base2 = new Vector(w.getX(), w.getY() - height, w.getZ());
        Vector v = base2.subtract(base);
        v.clone().multiply(1.0 / v.length());
        SimpleBlock one = w.get();
        double radius = baseRadius;
        for (int i = 0; i <= height; ++i) {
            Vector seg = v.clone().multiply((float)i / (float)height);
            SimpleBlock segment = one.getRelative(seg);
            BlockUtils.replaceSphere(random.nextInt(9999), (float)radius, 2.0f, (float)radius, segment, false, false, this.solidBlockType);
            radius = baseRadius * (1.0 - (double)i / (double)height);
        }
    }
}

