/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.terraform.data.SimpleBlock;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;

public class SphereBuilder {
    private boolean isSmooth = false;
    private Random random;
    private int seed;
    private float rX = 1.0f;
    private float rY = 1.0f;
    private float rZ = 1.0f;
    private float padding = 0.0f;
    private double minRadius = 0.0;
    private double maxRadius = 100.0;
    private SimpleBlock core;
    private boolean hardReplace = false;
    private Collection<Material> replaceWhitelist = new ArrayList<Material>();
    private Material[] types;
    private Material[] containmentMaterial = new Material[]{Material.STONE};
    private Material[] upperType;
    private Material[] lowerType;
    private int staticWaterLevel = -9999;
    private float sphereFrequency = 0.09f;
    private boolean doLiquidContainment = false;
    private SphereType sphereType = SphereType.FULL_SPHERE;

    public SphereBuilder(Random random, SimpleBlock core, Material ... types) {
        this.random = random;
        this.seed = random.nextInt(99999999);
        this.types = types;
        this.core = core;
    }

    public SphereBuilder setSphereType(SphereType sphereType) {
        this.sphereType = sphereType;
        return this;
    }

    public SphereBuilder setUpperType(Material ... upperType) {
        this.upperType = upperType;
        return this;
    }

    public SphereBuilder setLowerType(Material ... lowerType) {
        this.lowerType = lowerType;
        return this;
    }

    public SphereBuilder setStaticWaterLevel(int staticWaterLevel) {
        this.staticWaterLevel = staticWaterLevel;
        return this;
    }

    public SphereBuilder addToWhitelist(Material ... mats) {
        for (Material mat : mats) {
            this.replaceWhitelist.add(mat);
        }
        return this;
    }

    public SphereBuilder setRadius(float radius) {
        this.rX = radius;
        this.rY = radius;
        this.rZ = radius;
        return this;
    }

    public SphereBuilder setSphereFrequency(float sphereFrequency) {
        this.sphereFrequency = sphereFrequency;
        return this;
    }

    public SphereBuilder setRX(float rX) {
        this.rX = rX;
        return this;
    }

    public SphereBuilder setRZ(float rZ) {
        this.rZ = rZ;
        return this;
    }

    public SphereBuilder setRY(float rY) {
        this.rY = rY;
        return this;
    }

    public SphereBuilder setSnowy() {
        this.upperType = new Material[]{Material.SNOW};
        return this;
    }

    public SphereBuilder setHardReplace(boolean hardReplace) {
        this.hardReplace = hardReplace;
        return this;
    }

    public SphereBuilder setDoLiquidContainment(boolean doLiquidContainment) {
        this.doLiquidContainment = doLiquidContainment;
        return this;
    }

    public SphereBuilder setCointainmentMaterials(Material ... containmentMaterial) {
        this.containmentMaterial = containmentMaterial;
        return this;
    }

    public SphereBuilder setMinRadius(double minRadius) {
        this.minRadius = minRadius;
        return this;
    }

    public SphereBuilder setMaxRadius(double maxRadius) {
        this.maxRadius = maxRadius;
        return this;
    }

    public SphereBuilder setSmooth(boolean isSmooth) {
        this.isSmooth = isSmooth;
        return this;
    }

    public SphereBuilder setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    public void build() {
        if (this.rX <= 0.0f && this.rY <= 0.0f && this.rZ <= 0.0f) {
            return;
        }
        if ((double)this.rX <= 0.5 && (double)this.rY <= 0.5 && (double)this.rZ <= 0.5) {
            this.unitReplace(this.core, this.core.getY());
            return;
        }
        FastNoise noise = new FastNoise(this.seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(this.sphereFrequency);
        float effectiveRYLower = -this.rY;
        if (this.sphereType == SphereType.UPPER_SEMISPHERE) {
            effectiveRYLower = 0.0f;
        }
        float effectiveRYUpper = this.rY;
        if (this.sphereType == SphereType.LOWER_SEMISPHERE) {
            effectiveRYUpper = 0.0f;
        }
        for (float x = -this.rX - this.padding; x <= this.rX + this.padding; x += 1.0f) {
            for (float y = effectiveRYLower; y <= effectiveRYUpper; y += 1.0f) {
                for (float z = -this.rZ - this.padding; z <= this.rZ + this.padding; z += 1.0f) {
                    SimpleBlock rel = this.core.getRelative(Math.round(x), Math.round(y), Math.round(z));
                    double equationResult = Math.pow(x, 2.0) / Math.pow(this.rX, 2.0) + Math.pow(y, 2.0) / Math.pow(this.rY, 2.0) + Math.pow(z, 2.0) / Math.pow(this.rZ, 2.0);
                    double noiseVal = !this.isSmooth ? 1.0 + 0.7 * (double)noise.GetNoise(rel.getX(), rel.getY(), rel.getZ()) : 1.0;
                    if (noiseVal < this.minRadius) {
                        noiseVal = this.minRadius;
                    }
                    if (noiseVal > this.maxRadius) {
                        noiseVal = this.maxRadius;
                    }
                    if (!(equationResult <= noiseVal)) continue;
                    Material[] original = this.types;
                    if (rel.getY() <= this.staticWaterLevel) {
                        this.types = new Material[]{Material.WATER};
                        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.DOWN}) {
                            if (!BlockUtils.isAir(rel.getRelative(face).getType())) continue;
                            this.types = new Material[]{Material.STONE};
                        }
                    }
                    this.unitReplace(rel, (int)((float)this.core.getY() + effectiveRYUpper));
                    this.types = original;
                }
            }
        }
    }

    private boolean unitReplace(SimpleBlock rel, int effectiveRYUpper) {
        if (this.replaceWhitelist.size() == 0) {
            if (this.hardReplace || !rel.getType().isSolid()) {
                rel.setType(GenUtils.randMaterial(this.random, this.types));
                if (this.doLiquidContainment) {
                    rel.replaceAdjacentNonLiquids(BlockUtils.sixBlockFaces, this.types[0], this.containmentMaterial);
                }
            }
        } else if (this.replaceWhitelist.contains(rel.getType())) {
            rel.setType(GenUtils.randMaterial(this.random, this.types));
            if (this.doLiquidContainment) {
                rel.replaceAdjacentNonLiquids(BlockUtils.sixBlockFaces, this.types[0], this.containmentMaterial);
            }
        }
        if (rel.getType().isSolid()) {
            if (this.upperType != null && rel.getY() == effectiveRYUpper) {
                rel.getRelative(0, 1, 0).lsetType(this.upperType);
            }
            if (this.lowerType != null) {
                rel.getRelative(0, -1, 0).setType(this.lowerType);
            }
        }
        return true;
    }

    public static enum SphereType {
        UPPER_SEMISPHERE,
        LOWER_SEMISPHERE,
        FULL_SPHERE;

    }
}

