/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.Wall;
import org.terraform.structure.room.PathPopulatorAbstract;
import org.terraform.structure.room.PathPopulatorData;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class MazeSpawner {
    private final Map<SimpleLocation, MazeCell> cellGrid = new HashMap<SimpleLocation, MazeCell>();
    public List<PathPopulatorData> pathPopDatas = new ArrayList<PathPopulatorData>();
    private SimpleBlock core;
    private int widthX = -1;
    private int widthZ = -1;
    private Random rand;
    private int mazeHeight = 3;
    private MazeCell center;
    private int mazePathWidth = 1;
    private int mazePeriod = 1;
    private PathPopulatorAbstract pathPop;
    private boolean covered = false;

    public MazeSpawner() {
    }

    public MazeSpawner(Random rand, SimpleBlock core, int widthX, int widthZ) {
        this.rand = rand;
        this.core = core;
        this.widthX = widthX;
        this.widthZ = widthZ;
    }

    private Map<BlockFace, MazeCell> getValidNeighbours(MazeCell target) {
        EnumMap<BlockFace, MazeCell> neighbours = new EnumMap<BlockFace, MazeCell>(BlockFace.class);
        for (BlockFace face : BlockUtils.directBlockFaces) {
            MazeCell neighbour = this.getAdjacentCell(target, face);
            if (neighbour == null || !neighbour.hasAllWalls()) continue;
            neighbours.put(face, neighbour);
        }
        return neighbours;
    }

    public void prepareMaze() {
        int mazeCellsWidthX = this.widthX / (this.mazePathWidth + this.mazePeriod);
        int mazeCellsWidthZ = this.widthZ / (this.mazePathWidth + this.mazePeriod);
        for (int x = -mazeCellsWidthX / 2; x <= mazeCellsWidthX / 2; ++x) {
            for (int z = -mazeCellsWidthZ / 2; z <= mazeCellsWidthZ / 2; ++z) {
                MazeCell cell = new MazeCell(x, z);
                this.cellGrid.put(new SimpleLocation(x, this.core.getY(), z), cell);
                if (x != 0 || z != 0) continue;
                this.center = cell;
            }
        }
        int n = mazeCellsWidthX * mazeCellsWidthZ;
        Stack<MazeCell> cellStack = new Stack<MazeCell>();
        MazeCell currentCell = this.center;
        int nv = 1;
        while (nv < n) {
            Map<BlockFace, MazeCell> neighbours = this.getValidNeighbours(currentCell);
            if (neighbours.isEmpty()) {
                if (cellStack.isEmpty()) break;
                currentCell = (MazeCell)cellStack.pop();
                continue;
            }
            Map.Entry entry = (Map.Entry)neighbours.entrySet().toArray()[this.rand.nextInt(neighbours.size())];
            currentCell.knockDownWall((MazeCell)entry.getValue(), (BlockFace)entry.getKey());
            cellStack.push(currentCell);
            currentCell = (MazeCell)entry.getValue();
            ++nv;
        }
    }

    public void carveMaze(boolean carveInSolid, Material ... materials) {
        int cellRadius = (this.mazePathWidth - 1) / 2;
        for (MazeCell cell : this.cellGrid.values()) {
            int realWorldX = cell.x * (this.mazePathWidth + this.mazePeriod);
            int realWorldZ = cell.z * (this.mazePathWidth + this.mazePeriod);
            Wall cellCore = new Wall(this.core.getRelative(realWorldX, 0, realWorldZ));
            this.pathPopDatas.add(new PathPopulatorData(cellCore.getRelative(0, -1, 0).get(), BlockFace.UP, this.mazePathWidth, false));
            for (int nx = -cellRadius; nx <= cellRadius; ++nx) {
                for (int nz = -cellRadius; nz <= cellRadius; ++nz) {
                    cellCore.getRelative(nx, 0, nz).Pillar(this.mazeHeight, this.rand, Material.CAVE_AIR);
                    if (!this.covered) continue;
                    cellCore.getRelative(nx, this.mazeHeight, nz).setType(GenUtils.randMaterial(materials));
                    cellCore.getRelative(nx, -1, nz).setType(GenUtils.randMaterial(materials));
                }
            }
            Set<BlockFace> wallllllllless = cell.getWalllessFaces();
            for (BlockFace dir : BlockUtils.directBlockFaces) {
                Wall startPoint = new Wall(this.core.getRelative(realWorldX, 0, realWorldZ), dir).getRelative(dir, cellRadius + 1);
                if (wallllllllless.contains(dir)) {
                    int i = 0;
                    while ((double)i < Math.ceil((float)this.mazePeriod / 2.0f)) {
                        this.pathPopDatas.add(new PathPopulatorData(startPoint.getRelative(0, -1, 0).get(), dir, this.mazePathWidth, false));
                        startPoint.Pillar(this.mazeHeight, this.rand, Material.CAVE_AIR);
                        if (this.covered) {
                            startPoint.getRelative(0, this.mazeHeight, 0).setType(GenUtils.randMaterial(materials));
                            startPoint.getRelative(0, -1, 0).setType(GenUtils.randMaterial(materials));
                        }
                        for (int w = 1; w <= cellRadius; ++w) {
                            startPoint.getLeft(w).Pillar(this.mazeHeight, this.rand, Material.CAVE_AIR);
                            startPoint.getRight(w).Pillar(this.mazeHeight, this.rand, Material.CAVE_AIR);
                            if (!this.covered) continue;
                            startPoint.getLeft(w).getRelative(0, -1, 0).setType(GenUtils.randMaterial(materials));
                            startPoint.getRight(w).getRelative(0, -1, 0).setType(GenUtils.randMaterial(materials));
                            startPoint.getLeft(w).getRelative(0, this.mazeHeight, 0).setType(GenUtils.randMaterial(materials));
                            startPoint.getRight(w).getRelative(0, this.mazeHeight, 0).setType(GenUtils.randMaterial(materials));
                        }
                        startPoint.getLeft(cellRadius + 1).Pillar(this.mazeHeight, this.rand, materials);
                        startPoint.getRight(cellRadius + 1).Pillar(this.mazeHeight, this.rand, materials);
                        startPoint = startPoint.getRelative(dir);
                        ++i;
                    }
                    continue;
                }
                startPoint.Pillar(this.mazeHeight, this.rand, materials);
                for (int w = 1; w <= cellRadius; ++w) {
                    startPoint.getLeft(w).Pillar(this.mazeHeight, this.rand, materials);
                    startPoint.getRight(w).Pillar(this.mazeHeight, this.rand, materials);
                }
            }
        }
    }

    private MazeCell getAdjacentCell(MazeCell target, BlockFace face) {
        int neighbourX = target.x + face.getModX();
        int neighbourZ = target.z + face.getModZ();
        return this.cellGrid.get(new SimpleLocation(neighbourX, this.core.getY(), neighbourZ));
    }

    public int getMazeHeight() {
        return this.mazeHeight;
    }

    public void setMazeHeight(int mazeHeight) {
        this.mazeHeight = mazeHeight;
    }

    public int getWidthX() {
        return this.widthX;
    }

    public void setWidthX(int widthX) {
        this.widthX = widthX;
    }

    public int getWidthZ() {
        return this.widthZ;
    }

    public void setWidthZ(int widthZ) {
        this.widthZ = widthZ;
    }

    public void setWidth(int width) {
        this.widthX = width;
        this.widthZ = width;
    }

    public Random getRand() {
        return this.rand;
    }

    public void setRand(Random rand) {
        this.rand = rand;
    }

    public SimpleBlock getCore() {
        return this.core;
    }

    public void setCore(SimpleBlock core) {
        this.core = core;
    }

    public int getMazePathWidth() {
        return this.mazePathWidth;
    }

    public void setMazePathWidth(int mazePathWidth) {
        if (mazePathWidth % 2 == 0) {
            throw new IllegalArgumentException("Maze Path Width must be odd!");
        }
        this.mazePathWidth = mazePathWidth;
    }

    public int getMazePeriod() {
        return this.mazePeriod;
    }

    public void setMazePeriod(int mazePeriod) {
        this.mazePeriod = mazePeriod;
    }

    public PathPopulatorAbstract getPathPop() {
        return this.pathPop;
    }

    public void setPathPop(PathPopulatorAbstract pathPop) {
        this.pathPop = pathPop;
    }

    public boolean isCovered() {
        return this.covered;
    }

    public void setCovered(boolean covered) {
        this.covered = covered;
    }

    private static class MazeCell {
        protected int x;
        protected int z;
        protected Map<BlockFace, Boolean> walls = new EnumMap<BlockFace, Boolean>(BlockFace.class);

        public MazeCell(int x, int z) {
            this.x = x;
            this.z = z;
            this.walls.put(BlockFace.NORTH, true);
            this.walls.put(BlockFace.SOUTH, true);
            this.walls.put(BlockFace.EAST, true);
            this.walls.put(BlockFace.WEST, true);
        }

        public Set<BlockFace> getWalllessFaces() {
            EnumSet<BlockFace> faces = EnumSet.noneOf(BlockFace.class);
            for (Map.Entry<BlockFace, Boolean> entry : this.walls.entrySet()) {
                if (entry.getValue().booleanValue()) continue;
                faces.add(entry.getKey());
            }
            return faces;
        }

        public boolean hasAllWalls() {
            for (Boolean bool : this.walls.values()) {
                if (bool.booleanValue()) continue;
                return false;
            }
            return true;
        }

        public void knockDownWall(MazeCell other, BlockFace side) {
            this.walls.put(side, false);
            other.walls.put(side.getOppositeFace(), false);
        }
    }
}

