/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils;

import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeSection;
import org.terraform.coregen.ChunkCache;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.Vector2f;
import org.terraform.utils.noise.FastNoise;

public class GenUtils {
    public static final Random RANDOMIZER = new Random();
    private static final EnumSet<Material> BLACKLIST_HIGHEST_GROUND = EnumSet.noneOf(Material.class);
    public static LoadingCache<ChunkCache, EnumSet<BiomeBank>> biomeQueryCache;

    public static void initGenUtils() {
        for (Material mat : Material.values()) {
            if (!mat.toString().contains("LEAVES") && !mat.toString().contains("LOG") && !mat.toString().contains("WOOD") && !mat.toString().contains("MUSHROOM") && !mat.toString().contains("FENCE") && !mat.toString().contains("WALL") && !mat.toString().contains("POTTED") && !mat.toString().contains("BRICK") && !mat.toString().contains("CHAIN") && !mat.toString().contains("CORAL") && !mat.toString().contains("POINTED_DRIPSTONE") && !mat.toString().contains("NETHERRACK") && !mat.toString().contains("MANGROVE") && mat != Material.HAY_BLOCK && mat != Material.ICE && mat != Material.CACTUS && mat != Material.BAMBOO && mat != Material.BAMBOO_SAPLING && mat != Material.IRON_BARS && mat != Material.LANTERN) continue;
            BLACKLIST_HIGHEST_GROUND.add(mat);
        }
    }

    public static int getSign(Random rand) {
        return rand.nextBoolean() ? 1 : -1;
    }

    public static Collection<int[]> getCaveCeilFloors(PopulatorDataAbstract data, int x, int z) {
        int y = GenUtils.getHighestGround(data, x, z);
        int[] pair = new int[]{TerraformGeneratorPlugin.injector.getMinY() - 1, TerraformGeneratorPlugin.injector.getMinY() - 1};
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int ny = y; ny > TerraformGeneratorPlugin.injector.getMinY(); --ny) {
            Material type = data.getType(x, ny, z);
            if (BlockUtils.isStoneLike(type)) {
                pair[1] = ny;
                list.add(pair);
                pair = new int[]{TerraformGeneratorPlugin.injector.getMinY() - 1, TerraformGeneratorPlugin.injector.getMinY() - 1};
                continue;
            }
            if (pair[0] != TerraformGeneratorPlugin.injector.getMinY() - 1) continue;
            pair[0] = ny;
        }
        return list;
    }

    public static int[] randomCoords(Random rand, int[] lowBound, int[] highBound) {
        return new int[]{GenUtils.randInt(rand, lowBound[0], highBound[0]), GenUtils.randInt(rand, lowBound[1], highBound[1]), GenUtils.randInt(rand, lowBound[2], highBound[2])};
    }

    public static boolean chance(Random rand, int chance, int outOf) {
        return GenUtils.randInt(rand, 1, outOf) <= chance;
    }

    public static boolean chance(int chance, int outOf) {
        return GenUtils.randInt(new Random(), 1, outOf) <= chance;
    }

    public static EnumSet<BiomeBank> getBiomesInChunk(TerraformWorld tw, int chunkX, int chunkZ) {
        ChunkCache key = new ChunkCache(tw, chunkX, chunkZ);
        return (EnumSet)biomeQueryCache.getUnchecked((Object)key);
    }

    public static Vector2f locateHeightDependentBiome(TerraformWorld tw, BiomeBank biome, Vector2f center, int radius, int blockSkip) {
        if (!BiomeBank.isBiomeEnabled(biome)) {
            return null;
        }
        if (tw.getBiomeBank(Math.round(center.x), Math.round(center.y)) == biome) {
            return new Vector2f(center.x, center.y);
        }
        int iter = 2;
        int x = (int)center.x;
        int z = (int)center.y;
        while (Math.abs(center.x - (float)x) < (float)radius || Math.abs(center.y - (float)z) < (float)radius) {
            block7: for (int i = 0; i < iter / 2; ++i) {
                switch (iter % 4) {
                    case 0: {
                        x += blockSkip;
                        continue block7;
                    }
                    case 1: {
                        z -= blockSkip;
                        continue block7;
                    }
                    case 2: {
                        x -= blockSkip;
                        continue block7;
                    }
                    case 3: {
                        z += blockSkip;
                    }
                }
            }
            if (tw.getBiomeBank(x, z) == biome) {
                return new Vector2f(x, z);
            }
            ++iter;
        }
        return null;
    }

    public static Vector2f locateHeightIndependentBiome(TerraformWorld tw, BiomeBank biome, Vector2f centerBlockLocation) {
        if (!BiomeBank.isBiomeEnabled(biome)) {
            return null;
        }
        BiomeSection center = BiomeBank.getBiomeSectionFromBlockCoords(tw, (int)centerBlockLocation.x, (int)centerBlockLocation.y);
        int radius = 0;
        block0: while (true) {
            Iterator<BiomeSection> iterator = center.getRelativeSurroundingSections(radius).iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                BiomeSection sect = iterator.next();
                if (sect.getBiomeBank() == biome) {
                    SimpleLocation sectionCenter = sect.getCenter();
                    return new Vector2f(sectionCenter.getX(), sectionCenter.getZ());
                }
                ++radius;
            }
            break;
        }
    }

    public static Material weightedRandomMaterial(Random rand, Object ... candidates) {
        if (candidates.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<Material> types = new ArrayList<Material>(50);
        for (int i = 0; i < candidates.length; ++i) {
            Material type = (Material)candidates[i++];
            int freq = (Integer)candidates[i];
            for (int z = 0; z < freq; ++z) {
                types.add(type);
            }
        }
        return (Material)types.get(GenUtils.randInt(rand, 0, types.size() - 1));
    }

    public static Material randMaterial(Random rand, Material ... candidates) {
        if (candidates.length == 1) {
            return candidates[0];
        }
        return candidates[GenUtils.randInt(rand, 0, candidates.length - 1)];
    }

    public static Material randMaterial(Material ... candidates) {
        return GenUtils.randMaterial(RANDOMIZER, candidates);
    }

    public static Material randMaterial(EnumSet<Material> candidates) {
        Material[] temp = new Material[candidates.size()];
        int pointer = 0;
        Iterator iterator = candidates.iterator();
        while (iterator.hasNext()) {
            Material candidate;
            temp[pointer] = candidate = (Material)iterator.next();
            ++pointer;
        }
        return GenUtils.randMaterial(RANDOMIZER, temp);
    }

    public static int[] randomSurfaceCoordinates(Random rand, PopulatorDataAbstract data) {
        int chunkX = data.getChunkX();
        int chunkZ = data.getChunkZ();
        int x = GenUtils.randInt(rand, chunkX * 16, chunkX * 16 + 15);
        int z = GenUtils.randInt(rand, chunkZ * 16, chunkZ * 16 + 15);
        int y = GenUtils.getTrueHighestBlock(data, x, z);
        return new int[]{x, y, z};
    }

    public static int randInt(int min, int max) {
        if (min == max) {
            return min;
        }
        return GenUtils.randInt(RANDOMIZER, min, max);
    }

    public static int randInt(Random rand, int d, int max) {
        if (d == max) {
            return d;
        }
        boolean negative = false;
        if (d < 0 && max < 0) {
            negative = true;
            d = -d;
            max = -max;
        }
        if (max < d) {
            int temp = d;
            d = max;
            max = temp;
        }
        int randomNum = rand.nextInt(max - d + 1) + d;
        return negative ? -randomNum : randomNum;
    }

    public static int randOddInt(Random rand, int min, int max) {
        int randomNum = rand.nextInt(max - min + 1) + min;
        if (randomNum % 2 == 0 && randomNum++ > max) {
            randomNum -= 2;
        }
        return randomNum;
    }

    public static double randDouble(Random rand, double min, double max) {
        return rand.nextDouble() * (max - min) + min;
    }

    public static int getHighestX(PopulatorDataAbstract data, int x, int z, Material X) {
        int y;
        for (y = TerraformGeneratorPlugin.injector.getMaxY() - 1; y > TerraformGeneratorPlugin.injector.getMinY() && data.getType(x, y, z) != X; --y) {
        }
        return y;
    }

    public static Location getHighestBlock(World w, int x, int z) {
        int y;
        for (y = w.getMaxHeight() - 1; y > TerraformGeneratorPlugin.injector.getMinY() && !w.getBlockAt(x, y, z).getType().isSolid(); --y) {
        }
        if (y == TerraformGeneratorPlugin.injector.getMinY()) {
            TerraformGeneratorPlugin.logger.error("getHighestBlock(w,x,z) returned minimum height!");
            try {
                throw new Exception("getHighestBlock(w,x,z) returned minimum height!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new Location(w, (double)x, (double)y, (double)z);
    }

    public static int getHighestBlock(Chunk c2, int x, int z, Collection<Material> airs) {
        int y = c2.getWorld().getMaxHeight() - 1;
        while (airs.contains(c2.getBlock(x, y, z).getType())) {
            --y;
        }
        return y;
    }

    public static int getTrueHighestBlock(PopulatorDataAbstract data, int x, int z) {
        int y;
        for (y = TerraformGeneratorPlugin.injector.getMaxY() - 1; y > TerraformGeneratorPlugin.injector.getMinY() && !data.getType(x, y, z).isSolid(); --y) {
        }
        return y;
    }

    public static int getHighestGroundOrSeaLevel(PopulatorDataAbstract data, int x, int z) {
        int y = GenUtils.getHighestGround(data, x, z);
        if (y < TerraformGenerator.seaLevel) {
            return TerraformGenerator.seaLevel;
        }
        return y;
    }

    public static int getTrueHighestBlockBelow(PopulatorDataAbstract data, int x, int y, int z) {
        while (y > TerraformGeneratorPlugin.injector.getMinY() && !data.getType(x, y, z).isSolid()) {
            --y;
        }
        return y;
    }

    public static SimpleBlock getTrueHighestBlockBelow(SimpleBlock block) {
        int y;
        for (y = block.getY(); y > TerraformGeneratorPlugin.injector.getMinY() && !block.getPopData().getType(block.getX(), y, block.getZ()).isSolid(); --y) {
        }
        return new SimpleBlock(block.getPopData(), block.getX(), y, block.getZ());
    }

    public static boolean isGroundLike(Material mat) {
        if (BlockUtils.isStoneLike(mat) && mat != Material.PACKED_ICE && mat != Material.BLUE_ICE) {
            return true;
        }
        if (mat == Material.SAND || mat == Material.RED_SAND || mat == Material.GRAVEL) {
            return true;
        }
        if (mat.isSolid()) {
            if (mat.isInteractable()) {
                return false;
            }
            if (Tag.SLABS.isTagged((Keyed)mat)) {
                return false;
            }
            return !BLACKLIST_HIGHEST_GROUND.contains(mat);
        }
        return false;
    }

    public static int getHighestGround(PopulatorDataAbstract data, int x, int z) {
        Material block;
        int y;
        ChunkCache cache = TerraformGenerator.getCache(data.getTerraformWorld(), x, z);
        short cachedY = cache.getHighestGround(x, z);
        if (cachedY != Short.MIN_VALUE && GenUtils.isGroundLike(data.getType(x, cachedY, z)) && !GenUtils.isGroundLike(data.getType(x, cachedY + 1, z))) {
            return cache.getHighestGround(x, z);
        }
        for (y = TerraformGeneratorPlugin.injector.getMaxY() - 1; y > TerraformGeneratorPlugin.injector.getMinY() && !GenUtils.isGroundLike(block = data.getType(x, y, z)); --y) {
        }
        if (y <= TerraformGeneratorPlugin.injector.getMinY()) {
            TerraformGeneratorPlugin.logger.error("GetHighestGround returned less than " + TerraformGeneratorPlugin.injector.getMinY() + "! (" + y + ")");
            try {
                throw new Exception("GetHighestGround returned less than " + TerraformGeneratorPlugin.injector.getMinY() + "! (" + y + ")");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        cache.cacheHighestGround(x, z, Integer.valueOf(y).shortValue());
        return y;
    }

    public static Material[] mergeArr(Material[] ... arrs) {
        int totalLength = 0;
        int index = 0;
        for (Material[] arr : arrs) {
            totalLength += arr.length;
        }
        Material[] res = new Material[totalLength];
        Material[][] materialArray = arrs;
        int n = materialArray.length;
        for (int i = 0; i < n; ++i) {
            Material[] arr;
            for (Material mat : arr = materialArray[i]) {
                res[index++] = mat;
            }
        }
        return res;
    }

    public static Vector2f[] vectorRandomObjectPositions(int seed, int chunkX, int chunkZ, int distanceBetween, float maxPerturbation) {
        FastNoise noise = new FastNoise(seed);
        noise.SetFrequency(1.0f);
        noise.SetGradientPerturbAmp(maxPerturbation);
        ArrayList<Vector2f> positions = new ArrayList<Vector2f>();
        int startX = (chunkX << 4) - 5;
        int i = distanceBetween - startX % distanceBetween;
        int n = i != distanceBetween ? i : 0;
        int startZ = (chunkZ << 4) - 5;
        i = distanceBetween - startZ % distanceBetween;
        startZ += i != distanceBetween ? i : 0;
        for (int x = (startX += (v157427)) - distanceBetween; x < startX + 16 + distanceBetween; x += distanceBetween) {
            for (int z = startZ - distanceBetween; z < startZ + 16 + distanceBetween; z += distanceBetween) {
                Vector2f v = new Vector2f(x, z);
                noise.GradientPerturb(v);
                v.x = Math.round(v.x);
                v.y = Math.round(v.y);
                if (!(v.x >= (float)(chunkX << 4)) || !(v.x < (float)((chunkX << 4) + 16)) || !(v.y >= (float)(chunkZ << 4)) || !(v.y < (float)((chunkZ << 4) + 16))) continue;
                positions.add(v);
            }
        }
        return positions.toArray(new Vector2f[0]);
    }

    public static SimpleLocation[] randomObjectPositions(TerraformWorld world, int chunkX, int chunkZ, int distanceBetween) {
        Vector2f[] vecs = GenUtils.vectorRandomObjectPositions((int)world.getSeed(), chunkX, chunkZ, distanceBetween, 0.35f * (float)distanceBetween);
        SimpleLocation[] locs = new SimpleLocation[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            locs[i] = new SimpleLocation((int)vecs[i].x, 0, (int)vecs[i].y);
        }
        return locs;
    }

    public static SimpleLocation[] randomObjectPositions(TerraformWorld world, int chunkX, int chunkZ, int distanceBetween, float pertubMultiplier) {
        Vector2f[] vecs = GenUtils.vectorRandomObjectPositions((int)world.getSeed(), chunkX, chunkZ, distanceBetween, pertubMultiplier * (float)distanceBetween);
        SimpleLocation[] locs = new SimpleLocation[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            locs[i] = new SimpleLocation((int)vecs[i].x, 0, (int)vecs[i].y);
        }
        return locs;
    }

    public static SimpleLocation[] randomObjectPositions(int seed, int chunkX, int chunkZ, int distanceBetween, float pertubMultiplier) {
        Vector2f[] vecs = GenUtils.vectorRandomObjectPositions(seed, chunkX, chunkZ, distanceBetween, pertubMultiplier * (float)distanceBetween);
        SimpleLocation[] locs = new SimpleLocation[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            locs[i] = new SimpleLocation((int)vecs[i].x, 0, (int)vecs[i].y);
        }
        return locs;
    }

    public static double randAngle(double base, double lowerBound, double upperBound) {
        return GenUtils.randDouble(new Random(), lowerBound * base, upperBound * base);
    }

    public static <T> T choice(Random rand, T[] array) {
        if (array.length == 0) {
            return null;
        }
        if (array.length == 1) {
            return array[0];
        }
        return array[rand.nextInt(array.length)];
    }
}

