/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Material;
import org.terraform.data.SimpleBlock;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;

public class CylinderBuilder {
    private Random random;
    private int seed;
    private float rX = 1.0f;
    private float rY = 1.0f;
    private float rZ = 1.0f;
    private float minRadius = 0.0f;
    private SimpleBlock core;
    private boolean singleBlockY = false;
    private boolean hardReplace = false;
    private Collection<Material> replaceWhitelist = new ArrayList<Material>();
    private Material[] types;
    private Material[] upperType;
    private Material[] lowerType;
    private float noiseMagnitude = 0.7f;

    public CylinderBuilder(Random random, SimpleBlock core, Material ... types) {
        this.random = random;
        this.seed = random.nextInt(99999999);
        this.types = types;
        this.core = core;
    }

    public CylinderBuilder setNoiseMagnitude(float mag) {
        this.noiseMagnitude = mag;
        return this;
    }

    public CylinderBuilder setUpperType(Material ... upperType) {
        this.upperType = upperType;
        return this;
    }

    public CylinderBuilder setLowerType(Material ... lowerType) {
        this.lowerType = lowerType;
        return this;
    }

    public CylinderBuilder setRadius(float radius) {
        this.rX = radius;
        this.rY = radius;
        this.rZ = radius;
        return this;
    }

    public CylinderBuilder setMinRadius(float minRadius) {
        this.minRadius = minRadius;
        return this;
    }

    public CylinderBuilder setRX(float rX) {
        this.rX = rX;
        return this;
    }

    public CylinderBuilder setRZ(float rZ) {
        this.rZ = rZ;
        return this;
    }

    public CylinderBuilder setRY(float rY) {
        this.rY = rY;
        return this;
    }

    public CylinderBuilder setSnowy() {
        this.upperType = new Material[]{Material.SNOW};
        return this;
    }

    public CylinderBuilder setHardReplace(boolean hardReplace) {
        this.hardReplace = hardReplace;
        return this;
    }

    public CylinderBuilder setSingleBlockY(boolean singleBlockY) {
        this.singleBlockY = singleBlockY;
        return this;
    }

    public void build() {
        if (this.rX <= 0.0f && this.rY <= 0.0f && this.rZ <= 0.0f) {
            return;
        }
        if ((double)this.rX <= 0.5 && (double)this.rY <= 0.5 && (double)this.rZ <= 0.5) {
            this.unitReplace(this.core);
            return;
        }
        FastNoise noise = new FastNoise(this.seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.09f);
        float effectiveRY = this.rY;
        if (this.singleBlockY) {
            effectiveRY = 0.0f;
        }
        for (float x = -this.rX; x <= this.rX; x += 1.0f) {
            for (float y = -effectiveRY; y <= effectiveRY; y += 1.0f) {
                for (float z = -this.rZ; z <= this.rZ; z += 1.0f) {
                    SimpleBlock rel = this.core.getRelative(Math.round(x), Math.round(y), Math.round(z));
                    float effectiveY = y;
                    if ((double)(Math.abs(y) / this.rY) <= 0.7) {
                        effectiveY = 0.0f;
                    }
                    double equationResult = Math.pow(x, 2.0) / Math.pow(this.rX, 2.0) + Math.pow(effectiveY, 2.0) / Math.pow(this.rY, 2.0) + Math.pow(z, 2.0) / Math.pow(this.rZ, 2.0);
                    double noiseFuzz = this.noiseMagnitude > 0.0f ? (double)(1.0f + this.noiseMagnitude * noise.GetNoise(rel.getX(), rel.getY(), rel.getZ())) : 1.0;
                    if (noiseFuzz < (double)this.minRadius) {
                        noiseFuzz = this.minRadius;
                    }
                    if (!(equationResult <= noiseFuzz)) continue;
                    this.unitReplace(rel);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean unitReplace(SimpleBlock rel) {
        if (this.replaceWhitelist.size() == 0) {
            if (!this.hardReplace && rel.getType().isSolid()) return false;
            rel.setType(GenUtils.randMaterial(this.random, this.types));
        } else {
            if (!this.replaceWhitelist.contains(rel.getType())) return false;
            rel.setType(GenUtils.randMaterial(this.random, this.types));
        }
        if (this.upperType != null) {
            rel.getRelative(0, 1, 0).lsetType(this.upperType);
        }
        if (this.lowerType == null || !rel.getRelative(0, -1, 0).getType().isSolid()) return true;
        rel.getRelative(0, -1, 0).setType(this.lowerType);
        return true;
    }
}

