/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils;

import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.CoralWallFan;
import org.bukkit.block.data.type.SeaPickle;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class CoralGenerator {
    public static final Material[] CORAL_BLOCKS = new Material[]{Material.BRAIN_CORAL_BLOCK, Material.BUBBLE_CORAL_BLOCK, Material.FIRE_CORAL_BLOCK, Material.HORN_CORAL_BLOCK, Material.TUBE_CORAL_BLOCK};
    public static final Material[] CORAL_FANS = new Material[]{Material.BRAIN_CORAL_FAN, Material.BUBBLE_CORAL_FAN, Material.FIRE_CORAL_FAN, Material.HORN_CORAL_FAN, Material.TUBE_CORAL_FAN};
    public static final Material[] CORAL_WALL_FANS = new Material[]{Material.BRAIN_CORAL_WALL_FAN, Material.BUBBLE_CORAL_WALL_FAN, Material.FIRE_CORAL_WALL_FAN, Material.HORN_CORAL_WALL_FAN, Material.TUBE_CORAL_WALL_FAN};
    public static final BlockFace[] FACES = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.UP, BlockFace.DOWN};

    public static void generateSingleCoral(PopulatorDataAbstract data, int x, int y, int z) {
        BlockFace face = CoralGenerator.getRandomBlockFace();
        if (face == BlockFace.DOWN) {
            face = BlockFace.UP;
        }
        Material coral = CORAL_FANS[GenUtils.randInt(0, CORAL_FANS.length - 1)];
        if (face != BlockFace.UP) {
            coral = CORAL_WALL_FANS[GenUtils.randInt(0, CORAL_WALL_FANS.length - 1)];
        }
        CoralGenerator.attemptReplace(data, x + face.getModX(), y + face.getModY(), z + face.getModZ(), coral);
        if (face != BlockFace.UP && data.getBlockData(x + face.getModX(), y + face.getModY(), z + face.getModZ()) instanceof CoralWallFan) {
            CoralWallFan bdata = (CoralWallFan)data.getBlockData(x + face.getModX(), y + face.getModY(), z + face.getModZ());
            bdata.setFacing(face);
            data.setBlockData(x + face.getModX(), y + face.getModY(), z + face.getModZ(), (BlockData)bdata);
        }
    }

    public static boolean isSaturatedCoral(SimpleBlock block) {
        for (BlockFace face : BlockUtils.directBlockFaces) {
            if (block.getRelative(face).getType() != Material.WATER) continue;
            return true;
        }
        return false;
    }

    public static void generateSingleCoral(PopulatorDataAbstract data, int x, int y, int z, String coralType) {
        BlockFace face = CoralGenerator.getRandomBlockFace();
        coralType = StringUtils.remove((String)coralType, (String)"_BLOCK");
        if (face == BlockFace.DOWN) {
            face = BlockFace.UP;
        }
        Material coral = Material.getMaterial((String)(coralType + "_FAN"));
        if (new Random().nextBoolean()) {
            coral = Material.getMaterial((String)coralType);
        }
        if (face != BlockFace.UP) {
            coral = Material.getMaterial((String)(coralType + "_WALL_FAN"));
        } else if (GenUtils.chance(1, 5)) {
            CoralGenerator.generateSeaPickles(data, x, y + 1, z);
            return;
        }
        CoralGenerator.attemptReplace(data, x + face.getModX(), y + face.getModY(), z + face.getModZ(), coral);
        if (face != BlockFace.UP && data.getBlockData(x + face.getModX(), y + face.getModY(), z + face.getModZ()) instanceof CoralWallFan) {
            CoralWallFan bdata = (CoralWallFan)data.getBlockData(x + face.getModX(), y + face.getModY(), z + face.getModZ());
            bdata.setFacing(face);
            data.setBlockData(x + face.getModX(), y + face.getModY(), z + face.getModZ(), (BlockData)bdata);
        }
    }

    public static void generateSeaPickles(PopulatorDataAbstract data, int x, int y, int z) {
        int fullSize = GenUtils.randInt(1, 4);
        if (CoralGenerator.attemptReplace(data, x, y, z, Material.SEA_PICKLE) && data.getBlockData(x, y, z) instanceof SeaPickle) {
            SeaPickle state = (SeaPickle)data.getBlockData(x, y, z);
            state.setPickles(fullSize);
            data.setBlockData(x, y, z, (BlockData)state);
        }
    }

    public static void generateKelpGrowth(PopulatorDataAbstract data, int x, int y, int z) {
        int fullSize = GenUtils.randInt(1, 2);
        if (new Random().nextBoolean()) {
            fullSize += GenUtils.randInt(1, 20);
        }
        if (fullSize == 1) {
            CoralGenerator.attemptReplace(data, x, y, z, Material.SEAGRASS);
        } else if (fullSize == 2 && y < TerraformGenerator.seaLevel - 3) {
            BlockUtils.setDoublePlant(data, x, y, z, Material.TALL_SEAGRASS);
        } else {
            for (int size = 0; size < fullSize && CoralGenerator.attemptReplace(data, x, y, z, Material.KELP_PLANT); ++size) {
                ++y;
            }
        }
    }

    public static boolean attemptReplace(PopulatorDataAbstract data, int x, int y, int z, Material newType) {
        if (y >= TerraformGenerator.seaLevel) {
            return false;
        }
        Material type = data.getType(x, y, z);
        if (type != Material.WATER && type != Material.SEAGRASS && type != Material.TALL_SEAGRASS && type != Material.KELP_PLANT) {
            return false;
        }
        data.setType(x, y, z, newType);
        return true;
    }

    public static void generateCoral(PopulatorDataAbstract data, int x, int y, int z) {
        Material coral = CORAL_BLOCKS[GenUtils.randInt(0, CORAL_BLOCKS.length - 1)];
        int fullSize = GenUtils.randInt(15, 35);
        int[] middle = new int[]{x, y, z};
        for (int size = 0; size < fullSize; ++size) {
            if (CoralGenerator.attemptReplace(data, middle[0], middle[1], middle[2], coral)) {
                if (GenUtils.randInt(0, 100) < 20) {
                    CoralGenerator.generateSeaPickles(data, middle[0], middle[1] + 1, middle[2]);
                }
                if (GenUtils.randInt(0, 100) < 40) {
                    CoralGenerator.generateSingleCoral(data, middle[0], middle[1], middle[2]);
                }
            }
            CoralGenerator.getRandomRelative(middle);
        }
    }

    public static void generateSponge(PopulatorDataAbstract data, int x, int y, int z) {
        int fullSize = GenUtils.randInt(15, 35);
        int[] middle = new int[]{x, y, z};
        for (int size = 0; size < fullSize; ++size) {
            if (CoralGenerator.attemptReplace(data, middle[0], middle[1], middle[2], Material.WET_SPONGE) && GenUtils.randInt(0, 100) < 20) {
                CoralGenerator.generateSeaPickles(data, middle[0], middle[1] + 1, middle[2]);
            }
            CoralGenerator.getRandomRelative(middle);
        }
    }

    public static int[] getRandomRelative(int[] middle) {
        BlockFace face = CoralGenerator.getRandomBlockFace();
        middle[0] = middle[0] + face.getModX();
        middle[1] = middle[1] + face.getModY();
        middle[2] = middle[2] + face.getModZ();
        return middle;
    }

    public static BlockFace getRandomBlockFace() {
        return FACES[GenUtils.randInt(0, 13)];
    }
}

