/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.terraform.data.SimpleBlock;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;

public class BoxBuilder {
    private Random random;
    private int seed;
    private float rX = 1.0f;
    private float rY = 1.0f;
    private float rZ = 1.0f;
    private SimpleBlock core;
    private boolean hardReplace = false;
    private Collection<Material> replaceWhitelist = new ArrayList<Material>();
    private Material[] types;
    private Material[] upperType;
    private Material[] lowerType;
    private int staticWaterLevel = -9999;
    private float fuzzMultiplier = 0.2f;
    private BoxType boxType = BoxType.FULL_BOX;

    public BoxBuilder(Random random, SimpleBlock core, Material ... types) {
        this.random = random;
        this.seed = random.nextInt(99999999);
        this.types = types;
        this.core = core;
    }

    public BoxBuilder setBoxType(BoxType sphereType) {
        this.boxType = sphereType;
        return this;
    }

    public BoxBuilder setUpperType(Material ... upperType) {
        this.upperType = upperType;
        return this;
    }

    public BoxBuilder setLowerType(Material ... lowerType) {
        this.lowerType = lowerType;
        return this;
    }

    public BoxBuilder setStaticWaterLevel(int staticWaterLevel) {
        this.staticWaterLevel = staticWaterLevel;
        return this;
    }

    public BoxBuilder addToWhitelist(Material ... mats) {
        for (Material mat : mats) {
            this.replaceWhitelist.add(mat);
        }
        return this;
    }

    public BoxBuilder setRadius(float radius) {
        this.rX = radius;
        this.rY = radius;
        this.rZ = radius;
        return this;
    }

    public BoxBuilder setRX(float rX) {
        this.rX = rX;
        return this;
    }

    public BoxBuilder setRZ(float rZ) {
        this.rZ = rZ;
        return this;
    }

    public BoxBuilder setRY(float rY) {
        this.rY = rY;
        return this;
    }

    public BoxBuilder setSnowy() {
        this.upperType = new Material[]{Material.SNOW};
        return this;
    }

    public BoxBuilder setHardReplace(boolean hardReplace) {
        this.hardReplace = hardReplace;
        return this;
    }

    public void build() {
        if (this.rX <= 0.0f && this.rY <= 0.0f && this.rZ <= 0.0f) {
            return;
        }
        if ((double)this.rX <= 0.5 && (double)this.rY <= 0.5 && (double)this.rZ <= 0.5) {
            this.unitReplace(this.core);
            return;
        }
        FastNoise noise = new FastNoise(this.seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.12f);
        float effectiveRYLower = -this.rY;
        if (this.boxType == BoxType.UPPER_SEMIBOX) {
            effectiveRYLower = 0.0f;
        }
        float effectiveRYUpper = this.rY;
        if (this.boxType == BoxType.LOWER_SEMIBOX) {
            effectiveRYUpper = 0.0f;
        }
        for (float y = effectiveRYLower * (1.0f + this.fuzzMultiplier); y <= effectiveRYUpper * (1.0f + this.fuzzMultiplier); y += 1.0f) {
            float yMultiplier = 1.0f - Math.abs(y) / this.rY;
            for (float x = -this.rX * (1.0f + this.fuzzMultiplier) * yMultiplier; x <= this.rX * (1.0f + this.fuzzMultiplier) * yMultiplier; x += 1.0f) {
                for (float z = -this.rZ * (1.0f + this.fuzzMultiplier) * yMultiplier; z <= this.rZ * (1.0f + this.fuzzMultiplier) * yMultiplier; z += 1.0f) {
                    SimpleBlock rel = this.core.getRelative(Math.round(x), Math.round(y), Math.round(z));
                    double noiseVal = Math.abs(noise.GetNoise(rel.getX(), rel.getY(), rel.getZ()));
                    if (!((double)Math.abs(x) <= (double)this.rX * (1.0 + noiseVal * (double)this.fuzzMultiplier)) || !((double)Math.abs(y) <= (double)this.rY * (1.0 + noiseVal * (double)this.fuzzMultiplier)) || !((double)Math.abs(z) <= (double)this.rZ * (1.0 + noiseVal * (double)this.fuzzMultiplier))) continue;
                    Material[] original = this.types;
                    if (rel.getY() <= this.staticWaterLevel) {
                        this.types = new Material[]{Material.WATER};
                        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.DOWN}) {
                            if (!BlockUtils.isAir(rel.getRelative(face).getType())) continue;
                            this.types = new Material[]{Material.STONE};
                        }
                    }
                    this.unitReplace(rel);
                    this.types = original;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean unitReplace(SimpleBlock rel) {
        if (this.replaceWhitelist.size() == 0) {
            if (!this.hardReplace && rel.getType().isSolid()) return false;
            rel.setType(GenUtils.randMaterial(this.random, this.types));
        } else {
            if (!this.replaceWhitelist.contains(rel.getType())) return false;
            rel.setType(GenUtils.randMaterial(this.random, this.types));
        }
        if (!rel.getRelative(0, -1, 0).getType().isSolid()) return true;
        if (this.upperType != null) {
            rel.getRelative(0, 1, 0).lsetType(this.upperType);
        }
        if (this.lowerType == null) return true;
        rel.getRelative(0, -1, 0).setType(this.lowerType);
        return true;
    }

    public static enum BoxType {
        UPPER_SEMIBOX,
        LOWER_SEMIBOX,
        FULL_BOX;

    }
}

