/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Rail;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.block.data.type.Stairs;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleChunkLocation;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfigOption;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.StairBuilder;
import org.terraform.utils.blockdata.fixers.v1_16_R1_BlockDataFixer;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.version.OneOneNineBlockHandler;
import org.terraform.utils.version.OneOneSevenBlockHandler;
import org.terraform.utils.version.OneOneSixBlockHandler;
import org.terraform.utils.version.Version;

public class BlockUtils {
    public static final BlockFace[] xzPlaneBlockFaces = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    public static final EnumSet<Material> wetMaterials = EnumSet.of(Material.WATER, Material.KELP_PLANT, Material.SEAGRASS, Material.TALL_SEAGRASS);
    public static final BlockFace[] flatBlockFaces3x3 = new BlockFace[]{BlockFace.SELF, BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    public static final BlockFace[] BLOCK_FACES = BlockFace.values();
    public static final BlockFace[] xzDiagonalPlaneBlockFaces = new BlockFace[]{BlockFace.NORTH_EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH_WEST, BlockFace.NORTH_WEST};
    public static final Material[] stoneBricks = new Material[]{Material.STONE_BRICKS, Material.MOSSY_STONE_BRICKS, Material.CRACKED_STONE_BRICKS};
    public static final Material[] stoneBrickSlabs = new Material[]{Material.STONE_BRICK_SLAB, Material.MOSSY_STONE_BRICK_SLAB};
    public static final BlockFace[] directBlockFaces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
    public static final BlockFace[][] cornerBlockFaces = new BlockFace[][]{{BlockFace.NORTH, BlockFace.EAST}, {BlockFace.NORTH, BlockFace.WEST}, {BlockFace.SOUTH, BlockFace.EAST}, {BlockFace.SOUTH, BlockFace.WEST}};
    public static final BlockFace[] sixBlockFaces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};
    public static final EnumSet<Material> stoneLike = EnumSet.of(Material.STONE, new Material[]{Material.COBBLESTONE, Material.MOSSY_COBBLESTONE, Material.GRANITE, Material.ANDESITE, Material.DIORITE, Material.GRAVEL, Material.CLAY, OneOneSevenBlockHandler.DEEPSLATE, OneOneSevenBlockHandler.TUFF, OneOneSevenBlockHandler.CALCITE, OneOneSevenBlockHandler.BUDDING_AMETHYST, OneOneSevenBlockHandler.AMETHYST_BLOCK, OneOneSevenBlockHandler.DRIPSTONE_BLOCK, OneOneSixBlockHandler.SMOOTH_BASALT, Material.PACKED_ICE, Material.BLUE_ICE, Material.DIRT, Material.PODZOL, Material.GRASS_BLOCK, Material.MYCELIUM, OneOneSevenBlockHandler.ROOTED_DIRT, OneOneSevenBlockHandler.DIRT_PATH(), OneOneNineBlockHandler.SCULK});
    public static final EnumSet<Material> caveDecoratorMaterials = EnumSet.of(Material.ANDESITE_WALL, new Material[]{Material.DIORITE_WALL, Material.GRANITE_WALL, Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL, OneOneSevenBlockHandler.COBBLED_DEEPSLATE_WALL, Material.COBBLESTONE_SLAB, Material.STONE_SLAB, OneOneSevenBlockHandler.COBBLED_DEEPSLATE_SLAB, OneOneSevenBlockHandler.MOSS_BLOCK, OneOneSevenBlockHandler.MOSS_CARPET, OneOneSevenBlockHandler.CAVE_VINES, OneOneSevenBlockHandler.HANGING_ROOTS, OneOneSevenBlockHandler.SPORE_BLOSSOM, OneOneSevenBlockHandler.SMALL_DRIPLEAF, OneOneSevenBlockHandler.AZALEA, OneOneSevenBlockHandler.FLOWERING_AZALEA, OneOneSevenBlockHandler.BIG_DRIPLEAF, OneOneSevenBlockHandler.BIG_DRIPLEAF_STEM, Material.GRASS, Material.TALL_GRASS, Material.ICE, Material.PACKED_ICE, OneOneSevenBlockHandler.DRIPSTONE_BLOCK, OneOneSevenBlockHandler.POINTED_DRIPSTONE, OneOneSevenBlockHandler.AMETHYST_CLUSTER, OneOneSevenBlockHandler.BUDDING_AMETHYST, OneOneSevenBlockHandler.GLOW_LICHEN, Material.NOTE_BLOCK, Material.SPAWNER, Material.BROWN_MUSHROOM_BLOCK, Material.RED_MUSHROOM_BLOCK});
    public static final EnumSet<Material> badlandsStoneLike = EnumSet.of(Material.TERRACOTTA, new Material[]{Material.ORANGE_TERRACOTTA, Material.RED_TERRACOTTA, Material.BROWN_TERRACOTTA, Material.YELLOW_TERRACOTTA, Material.RED_SAND});
    public static final EnumSet<Material> ores = EnumSet.noneOf(Material.class);
    public static final EnumSet<Material> airs = EnumSet.of(Material.AIR, Material.CAVE_AIR);
    public static final EnumSet<Material> glassPanes = EnumSet.noneOf(Material.class);
    private static final Material[] TALL_FLOWER = new Material[]{Material.LILAC, Material.ROSE_BUSH, Material.PEONY, Material.LARGE_FERN, Material.SUNFLOWER};
    private static final Material[] FLOWER = new Material[]{Material.DANDELION, Material.POPPY, Material.WHITE_TULIP, Material.ORANGE_TULIP, Material.RED_TULIP, Material.PINK_TULIP, Material.BLUE_ORCHID, Material.ALLIUM, Material.AZURE_BLUET, Material.OXEYE_DAISY, Material.CORNFLOWER, Material.LILY_OF_THE_VALLEY, Material.PINK_TULIP};
    private static final Material[] POTTED = new Material[]{Material.POTTED_DANDELION, Material.POTTED_POPPY, Material.POTTED_WHITE_TULIP, Material.POTTED_ORANGE_TULIP, Material.POTTED_RED_TULIP, Material.POTTED_PINK_TULIP, Material.POTTED_BLUE_ORCHID, Material.POTTED_ALLIUM, Material.POTTED_AZURE_BLUET, Material.POTTED_OXEYE_DAISY, Material.POTTED_CORNFLOWER, Material.POTTED_LILY_OF_THE_VALLEY, Material.POTTED_PINK_TULIP};
    private static final Material[] CARPETS = new Material[]{Material.WHITE_CARPET, Material.BLACK_CARPET, Material.BLUE_CARPET, Material.BROWN_CARPET, Material.CYAN_CARPET, Material.GRAY_CARPET, Material.GREEN_CARPET, Material.LIGHT_BLUE_CARPET, Material.LIGHT_GRAY_CARPET, Material.LIME_CARPET, Material.MAGENTA_CARPET, Material.ORANGE_CARPET, Material.PINK_CARPET, Material.PURPLE_CARPET, Material.RED_CARPET, Material.YELLOW_CARPET};
    public static final Material[] WOOLS = new Material[]{Material.WHITE_WOOL, Material.BLACK_WOOL, Material.BLUE_WOOL, Material.BROWN_WOOL, Material.CYAN_WOOL, Material.GRAY_WOOL, Material.GREEN_WOOL, Material.LIGHT_BLUE_WOOL, Material.LIGHT_GRAY_WOOL, Material.LIME_WOOL, Material.MAGENTA_WOOL, Material.ORANGE_WOOL, Material.PINK_WOOL, Material.PURPLE_WOOL, Material.RED_WOOL, Material.YELLOW_WOOL};
    private static final Material[] BED = new Material[]{Material.WHITE_BED, Material.BLACK_BED, Material.BLUE_BED, Material.BROWN_BED, Material.CYAN_BED, Material.GRAY_BED, Material.GREEN_BED, Material.LIGHT_BLUE_BED, Material.LIGHT_GRAY_BED, Material.LIME_BED, Material.MAGENTA_BED, Material.ORANGE_BED, Material.PINK_BED, Material.PURPLE_BED, Material.RED_BED, Material.YELLOW_BED};
    public static final Material[] GLAZED_TERRACOTTA = new Material[]{Material.WHITE_GLAZED_TERRACOTTA, Material.BLACK_GLAZED_TERRACOTTA, Material.BLUE_GLAZED_TERRACOTTA, Material.BROWN_GLAZED_TERRACOTTA, Material.CYAN_GLAZED_TERRACOTTA, Material.GRAY_GLAZED_TERRACOTTA, Material.GREEN_GLAZED_TERRACOTTA, Material.LIGHT_BLUE_GLAZED_TERRACOTTA, Material.LIGHT_GRAY_GLAZED_TERRACOTTA, Material.LIME_GLAZED_TERRACOTTA, Material.MAGENTA_GLAZED_TERRACOTTA, Material.ORANGE_GLAZED_TERRACOTTA, Material.PINK_GLAZED_TERRACOTTA, Material.PURPLE_GLAZED_TERRACOTTA, Material.RED_GLAZED_TERRACOTTA, Material.YELLOW_GLAZED_TERRACOTTA};

    public static void initBlockUtils() {
        for (Object mat : Material.values()) {
            if (!mat.toString().endsWith("_ORE")) continue;
            ores.add((Material)mat);
            stoneLike.add((Material)mat);
        }
        for (Material mat : stoneLike) {
            badlandsStoneLike.add(mat);
        }
        for (Object mat : Material.values()) {
            if (!mat.toString().endsWith("_GLASS_PANE")) continue;
            glassPanes.add((Material)mat);
        }
    }

    public static boolean isDirectBlockFace(BlockFace facing) {
        switch (facing) {
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                return true;
            }
        }
        return false;
    }

    public static BlockFace rotateFace(BlockFace original, int times) {
        block6: for (int i = 0; i < times; ++i) {
            switch (original) {
                case NORTH: {
                    original = BlockFace.EAST;
                    continue block6;
                }
                case EAST: {
                    original = BlockFace.SOUTH;
                    continue block6;
                }
                case SOUTH: {
                    original = BlockFace.WEST;
                    continue block6;
                }
                case WEST: {
                    original = BlockFace.NORTH;
                }
            }
        }
        return original;
    }

    public static BlockFace rotateXZPlaneBlockFace(BlockFace original, int times) {
        block10: for (int i = 0; i < times; ++i) {
            switch (original) {
                case NORTH: {
                    original = BlockFace.NORTH_EAST;
                    continue block10;
                }
                case NORTH_EAST: {
                    original = BlockFace.EAST;
                    continue block10;
                }
                case EAST: {
                    original = BlockFace.SOUTH_EAST;
                    continue block10;
                }
                case SOUTH_EAST: {
                    original = BlockFace.SOUTH;
                    continue block10;
                }
                case SOUTH: {
                    original = BlockFace.SOUTH_WEST;
                    continue block10;
                }
                case SOUTH_WEST: {
                    original = BlockFace.WEST;
                    continue block10;
                }
                case WEST: {
                    original = BlockFace.NORTH_WEST;
                    continue block10;
                }
                case NORTH_WEST: {
                    original = BlockFace.NORTH;
                }
            }
        }
        return original;
    }

    public static BlockFace rotateXZPlaneBlockFaceOppositeAngle(BlockFace original, int times) {
        block10: for (int i = 0; i < times; ++i) {
            switch (original) {
                case NORTH: {
                    original = BlockFace.NORTH_EAST;
                    continue block10;
                }
                case NORTH_EAST: {
                    original = BlockFace.EAST;
                    continue block10;
                }
                case EAST: {
                    original = BlockFace.SOUTH_EAST;
                    continue block10;
                }
                case SOUTH_EAST: {
                    original = BlockFace.SOUTH;
                    continue block10;
                }
                case SOUTH: {
                    original = BlockFace.SOUTH_WEST;
                    continue block10;
                }
                case SOUTH_WEST: {
                    original = BlockFace.WEST;
                    continue block10;
                }
                case WEST: {
                    original = BlockFace.NORTH_WEST;
                    continue block10;
                }
                case NORTH_WEST: {
                    original = BlockFace.NORTH;
                }
            }
        }
        return original;
    }

    public static BlockFace[] getRandomBlockfaceAxis(Random rand) {
        if (rand.nextInt(2) == 0) {
            return new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH};
        }
        return new BlockFace[]{BlockFace.WEST, BlockFace.EAST};
    }

    public static Material stoneBrick(Random rand) {
        return GenUtils.randMaterial(rand, stoneBricks);
    }

    public static Material stoneBrickSlab(Random rand) {
        return GenUtils.randMaterial(rand, stoneBrickSlabs);
    }

    public static BlockFace getXZPlaneBlockFace(Random rand) {
        return xzPlaneBlockFaces[rand.nextInt(8)];
    }

    public static BlockFace getBlockFaceFromAxis(Axis ax) {
        switch (ax) {
            case X: {
                return BlockFace.EAST;
            }
            case Z: {
                return BlockFace.SOUTH;
            }
            case Y: {
                return BlockFace.UP;
            }
        }
        return null;
    }

    public static Axis getAxisFromBlockFace(BlockFace face) {
        switch (face) {
            case NORTH: 
            case SOUTH: {
                return Axis.Z;
            }
            case EAST: 
            case WEST: {
                return Axis.X;
            }
            case UP: 
            case DOWN: {
                return Axis.Y;
            }
        }
        throw new IllegalArgumentException("Invalid block facing for axis: " + face);
    }

    public static Axis getPerpendicularHorizontalPlaneAxis(Axis x) {
        switch (x) {
            case X: {
                return Axis.Z;
            }
            case Z: {
                return Axis.X;
            }
        }
        return x;
    }

    public static BlockFace getDirectBlockFace(Random rand) {
        return directBlockFaces[rand.nextInt(4)];
    }

    public static BlockFace getSixBlockFace(Random rand) {
        return sixBlockFaces[rand.nextInt(6)];
    }

    public static Material pickCarpet() {
        return GenUtils.randMaterial(CARPETS);
    }

    public static Material pickWool() {
        return GenUtils.randMaterial(WOOLS);
    }

    public static Material pickBed() {
        return GenUtils.randMaterial(BED);
    }

    public static Material pickFlower() {
        return GenUtils.randMaterial(FLOWER);
    }

    public static Material pickPottedPlant() {
        return GenUtils.randMaterial(POTTED);
    }

    public static Material pickTallFlower() {
        return GenUtils.randMaterial(TALL_FLOWER);
    }

    public static void dropDownBlock(SimpleBlock block) {
        BlockUtils.dropDownBlock(block, Material.CAVE_AIR);
    }

    public static void dropDownBlock(SimpleBlock block, Material fluid) {
        if (block.getType().isSolid()) {
            Material type = block.getType();
            block.setType(fluid);
            int depth = 0;
            while (!block.getType().isSolid()) {
                block = block.getRelative(0, -1, 0);
                if (++depth <= 50) continue;
                return;
            }
            block.getRelative(0, 1, 0).setType(type);
        }
    }

    public static void horizontalGlazedTerracotta(PopulatorDataAbstract data, int x, int y, int z, Material glazedTerracotta) {
        Directional terracotta = (Directional)Bukkit.createBlockData((Material)glazedTerracotta);
        terracotta.setFacing(BlockFace.NORTH);
        data.setBlockData(x, y, z, (BlockData)terracotta);
        terracotta = (Directional)Bukkit.createBlockData((Material)glazedTerracotta);
        terracotta.setFacing(BlockFace.EAST);
        data.setBlockData(x + 1, y, z, (BlockData)terracotta);
        terracotta = (Directional)Bukkit.createBlockData((Material)glazedTerracotta);
        terracotta.setFacing(BlockFace.WEST);
        data.setBlockData(x, y, z + 1, (BlockData)terracotta);
        terracotta = (Directional)Bukkit.createBlockData((Material)glazedTerracotta);
        terracotta.setFacing(BlockFace.SOUTH);
        data.setBlockData(x + 1, y, z + 1, (BlockData)terracotta);
    }

    public static void setVines(PopulatorDataAbstract data, int x, int y, int z, int maxLength) {
        SimpleBlock rel = new SimpleBlock(data, x, y, z);
        for (BlockFace face : directBlockFaces) {
            MultipleFacing dir = (MultipleFacing)Bukkit.createBlockData((Material)Material.VINE);
            dir.setFace(face.getOppositeFace(), true);
            SimpleBlock vine = rel.getRelative(face);
            if (vine.getType().isSolid()) continue;
            vine.setType(Material.VINE);
            vine.setBlockData((BlockData)dir);
            for (int i = 0; i < GenUtils.randInt(1, maxLength); ++i) {
                vine.getRelative(0, -i, 0).setType(Material.VINE);
                vine.getRelative(0, -i, 0).setBlockData((BlockData)dir);
            }
        }
    }

    public static double distanceSquared(float x1, float y1, float z1, float x2, float y2, float z2) {
        return Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0);
    }

    public static void setDownUntilSolid(int x, int y, int z, PopulatorDataAbstract data, Material ... type) {
        while (!data.getType(x, y, z).isSolid()) {
            data.setType(x, y, z, GenUtils.randMaterial(type));
            --y;
        }
    }

    public static void downPillar(int x, int y, int z, int height, PopulatorDataAbstract data, Material ... type) {
        while (!data.getType(x, y, z).isSolid() && height > TerraformGeneratorPlugin.injector.getMinY()) {
            data.setType(x, y, z, GenUtils.randMaterial(type));
            --height;
            --y;
        }
    }

    public static boolean isStoneLike(Material mat) {
        return BlockUtils.isDirtLike(mat) || stoneLike.contains(mat) || ores.contains(mat);
    }

    public static boolean isDirtLike(Material mat) {
        switch (mat) {
            case DIRT: 
            case GRASS_BLOCK: 
            case PODZOL: 
            case COARSE_DIRT: 
            case MYCELIUM: {
                return true;
            }
        }
        return mat == OneOneSevenBlockHandler.DIRT_PATH() || mat == OneOneSevenBlockHandler.ROOTED_DIRT;
    }

    public static void setPersistentLeaves(PopulatorDataAbstract data, int x, int y, int z) {
        BlockUtils.setPersistentLeaves(data, x, y, z, Material.OAK_LEAVES);
    }

    public static void setPersistentLeaves(PopulatorDataAbstract data, int x, int y, int z, Material type) {
        data.setType(x, y, z, Material.OAK_LEAVES);
        Leaves bd = (Leaves)Bukkit.createBlockData((Material)type);
        bd.setPersistent(true);
        data.setBlockData(x, y, z, (BlockData)bd);
    }

    public static void setDoublePlant(PopulatorDataAbstract data, int x, int y, int z, Material doublePlant) {
        Bisected d = (Bisected)Bukkit.createBlockData((Material)doublePlant);
        d.setHalf(Bisected.Half.BOTTOM);
        data.setBlockData(x, y, z, (BlockData)d);
        d = (Bisected)Bukkit.createBlockData((Material)doublePlant);
        d.setHalf(Bisected.Half.TOP);
        data.setBlockData(x, y + 1, z, (BlockData)d);
    }

    public static boolean isSameChunk(Block a2, Block b) {
        return SimpleChunkLocation.of(a2).equals(SimpleChunkLocation.of(b));
    }

    public static boolean areAdjacentChunksLoaded(Chunk middle) {
        for (int nx = -1; nx <= 1; ++nx) {
            for (int nz = -1; nz <= 1; ++nz) {
                int x = middle.getX() + nx;
                int z = middle.getZ() + nz;
                if (middle.getWorld().isChunkLoaded(x, z)) continue;
                return false;
            }
        }
        return true;
    }

    public static Material getTerracotta(int height) {
        int mapped = (height + 10) % 17;
        if (mapped == 2 || mapped == 9 || mapped == 13 || mapped == 16) {
            return Material.TERRACOTTA;
        }
        if (mapped == 4 || mapped == 5 || mapped == 12 || mapped == 15) {
            return Material.RED_TERRACOTTA;
        }
        if (mapped == 6) {
            return Material.YELLOW_TERRACOTTA;
        }
        if (mapped == 8) {
            return Material.BROWN_TERRACOTTA;
        }
        return Material.ORANGE_TERRACOTTA;
    }

    public static int spawnPillar(Random rand, PopulatorDataAbstract data, int x, int y, int z, Material type, int minHeight, int maxHeight) {
        int height = GenUtils.randInt(rand, minHeight, maxHeight);
        for (int i = 0; i < height; ++i) {
            data.setType(x, y + i, z, type);
        }
        return height;
    }

    public static void generateClayDeposit(int x, int y, int z, PopulatorDataAbstract data, Random random) {
        BlockUtils.replaceCircularPatch(random.nextInt(9999), TConfigOption.BIOME_CLAY_DEPOSIT_SIZE.getFloat(), new SimpleBlock(data, x, y, z), Material.CLAY);
    }

    public static void vineUp(SimpleBlock base, int maxLength) {
        for (BlockFace face : directBlockFaces) {
            SimpleBlock relative;
            MultipleFacing dir = (MultipleFacing)Bukkit.createBlockData((Material)Material.VINE);
            dir.setFace(face.getOppositeFace(), true);
            SimpleBlock vine = base.getRelative(face);
            if (vine.getType().isSolid()) continue;
            vine.setType(Material.VINE);
            vine.setBlockData((BlockData)dir);
            for (int i = 1; i < GenUtils.randInt(1, maxLength) && (relative = vine.getRelative(0, -i, 0)).getType() == Material.AIR; ++i) {
                relative.setType(Material.VINE);
                relative.setBlockData((BlockData)dir);
            }
        }
    }

    public static void replaceCircle(int seed, float radius, SimpleBlock base, Material ... type) {
        if (radius <= 0.0f) {
            return;
        }
        if ((double)radius <= 0.5) {
            base.setType(GenUtils.randMaterial(new Random(seed), type));
            return;
        }
        FastNoise noise = new FastNoise(seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.09f);
        for (float x = -radius; x <= radius; x += 1.0f) {
            for (float z = -radius; z <= radius; z += 1.0f) {
                SimpleBlock rel = base.getRelative(Math.round(x), 0, Math.round(z));
                double equationResult = Math.pow(x, 2.0) / Math.pow(radius, 2.0) + Math.pow(z, 2.0) / Math.pow(radius, 2.0);
                if (!(equationResult <= 1.0 + 0.7 * (double)noise.GetNoise(rel.getX(), rel.getZ()))) continue;
                rel.lsetType(GenUtils.randMaterial(type));
            }
        }
    }

    public static void replaceCircularPatch(int seed, float radius, SimpleBlock base, Material ... type) {
        BlockUtils.replaceCircularPatch(seed, radius, base, false, type);
    }

    public static void replaceCircularPatch(int seed, float radius, SimpleBlock base, boolean snowy, Material ... type) {
        if (radius <= 0.0f) {
            return;
        }
        if ((double)radius <= 0.5) {
            base.setType(GenUtils.randMaterial(new Random(seed), type));
            return;
        }
        FastNoise noise = new FastNoise(seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.09f);
        for (float x = -radius; x <= radius; x += 1.0f) {
            for (float z = -radius; z <= radius; z += 1.0f) {
                SimpleBlock rel = base.getRelative(Math.round(x), 0, Math.round(z));
                rel = rel.getGround();
                double equationResult = Math.pow(x, 2.0) / Math.pow(radius, 2.0) + Math.pow(z, 2.0) / Math.pow(radius, 2.0);
                if (!(equationResult <= 1.0 + 0.7 * (double)noise.GetNoise(rel.getX(), rel.getZ()))) continue;
                rel.setType(GenUtils.randMaterial(type));
                if (!snowy || !rel.getUp().isAir()) continue;
                rel.getUp().setType(Material.SNOW);
            }
        }
    }

    public static void replaceSphere(int seed, float radius, SimpleBlock base, boolean hardReplace, Material ... type) {
        if (radius > 0.0f) {
            BlockUtils.replaceSphere(seed, radius, radius, radius, base, hardReplace, type);
        }
    }

    public static void replaceSphere(int seed, float rX, float rY, float rZ, SimpleBlock block, boolean hardReplace, Material ... type) {
        BlockUtils.replaceSphere(seed, rX, rY, rZ, block, hardReplace, false, type);
    }

    public static void replaceWaterSphere(int seed, float radius, SimpleBlock base) {
        if (radius <= 0.0f) {
            return;
        }
        if ((double)radius <= 0.5) {
            if (base.getY() <= TerraformGenerator.seaLevel) {
                base.setType(Material.WATER);
            } else {
                base.setType(Material.AIR);
            }
            return;
        }
        FastNoise noise = new FastNoise(seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.09f);
        for (float x = -radius; x <= radius; x += 1.0f) {
            for (float y = -radius; y <= radius; y += 1.0f) {
                for (float z = -radius; z <= radius; z += 1.0f) {
                    SimpleBlock rel = base.getRelative(Math.round(x), Math.round(y), Math.round(z));
                    double equationResult = Math.pow(x, 2.0) / Math.pow(radius, 2.0) + Math.pow(y, 2.0) / Math.pow(radius, 2.0) + Math.pow(z, 2.0) / Math.pow(radius, 2.0);
                    if (!(equationResult <= 1.0 + 0.7 * (double)noise.GetNoise(rel.getX(), rel.getY(), rel.getZ()))) continue;
                    if (rel.getY() <= TerraformGenerator.seaLevel) {
                        rel.setType(Material.WATER);
                        continue;
                    }
                    rel.setType(Material.AIR);
                }
            }
        }
    }

    public static void carveCaveAir(int seed, float rX, float rY, float rZ, SimpleBlock block, boolean waterToAir, EnumSet<Material> toReplace) {
        BlockUtils.carveCaveAir(seed, rX, rY, rZ, 0.09f, block, waterToAir, toReplace);
    }

    public static void carveCaveAir(int seed, float rX, float rY, float rZ, float frequency, SimpleBlock block, boolean waterToAir, EnumSet<Material> toReplace) {
        BlockUtils.carveCaveAir(seed, rX, rY, rZ, frequency, block, false, waterToAir, toReplace);
    }

    public static void carveCaveAir(int seed, float rX, float rY, float rZ, float frequency, SimpleBlock block, boolean blockWaterHoles, boolean waterToAir, EnumSet<Material> toReplace) {
        if (rX <= 0.0f && rY <= 0.0f && rZ <= 0.0f) {
            return;
        }
        if ((double)rX <= 0.5 && (double)rY <= 0.5 && (double)rZ <= 0.5) {
            if (waterToAir || block.getType() != Material.WATER) {
                block.setType(Material.CAVE_AIR);
            }
            return;
        }
        FastNoise noise = new FastNoise(seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(frequency);
        for (float x = -rX * 1.3f; x <= rX * 1.3f; x += 1.0f) {
            for (float y = -rY; y <= rY; y += 1.0f) {
                for (float z = -rZ * 1.3f; z <= rZ * 1.3f; z += 1.0f) {
                    double noiseVal;
                    SimpleBlock rel = block.getRelative(Math.round(x), Math.round(y), Math.round(z));
                    double equationResult = Math.pow(x, 2.0) / Math.pow(rX, 2.0) + Math.pow(y, 2.0) / Math.pow(rY, 2.0) + Math.pow(z, 2.0) / Math.pow(rZ, 2.0);
                    if (!(equationResult <= (noiseVal = 1.0 + 0.7 * (double)noise.GetNoise(rel.getX(), rel.getY(), rel.getZ())))) continue;
                    if (toReplace.contains(Material.BARRIER)) {
                        if (!(toReplace.contains(rel.getType()) || BlockUtils.isWet(rel) && !waterToAir)) {
                            rel.physicsSetType(Material.CAVE_AIR, false);
                        }
                    } else if (toReplace.contains(rel.getType())) {
                        if (!BlockUtils.isWet(rel) || waterToAir) {
                            rel.physicsSetType(Material.CAVE_AIR, false);
                        }
                    } else if (!(rel.getType().isSolid() || BlockUtils.isWet(rel) && !waterToAir)) {
                        rel.physicsSetType(Material.CAVE_AIR, false);
                    }
                    if (!blockWaterHoles) continue;
                    for (BlockFace face : sixBlockFaces) {
                        SimpleBlock relrel = rel.getRelative(face);
                        if (!BlockUtils.isWet(relrel) && relrel.getType() != Material.LAVA) continue;
                        Material setMat = relrel.getY() < 0 ? OneOneSevenBlockHandler.DEEPSLATE : Material.STONE;
                        relrel.physicsSetType(setMat, false);
                    }
                }
            }
        }
    }

    public static void replaceSphere(int seed, float rX, float rY, float rZ, SimpleBlock block, boolean hardReplace, boolean snowy, Material ... type) {
        if (rX <= 0.0f && rY <= 0.0f && rZ <= 0.0f) {
            return;
        }
        if ((double)rX <= 0.5 && (double)rY <= 0.5 && (double)rZ <= 0.5) {
            block.setType(GenUtils.randMaterial(new Random(seed), type));
            return;
        }
        Random rand = new Random(seed);
        FastNoise noise = new FastNoise(seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.09f);
        for (float x = -rX; x <= rX; x += 1.0f) {
            for (float y = -rY; y <= rY; y += 1.0f) {
                for (float z = -rZ; z <= rZ; z += 1.0f) {
                    SimpleBlock rel = block.getRelative(Math.round(x), Math.round(y), Math.round(z));
                    double equationResult = Math.pow(x, 2.0) / Math.pow(rX, 2.0) + Math.pow(y, 2.0) / Math.pow(rY, 2.0) + Math.pow(z, 2.0) / Math.pow(rZ, 2.0);
                    if (!(equationResult <= 1.0 + 0.7 * (double)noise.GetNoise(rel.getX(), rel.getY(), rel.getZ())) || !hardReplace && rel.getType().isSolid()) continue;
                    rel.setType(GenUtils.randMaterial(rand, type));
                    if (!snowy) continue;
                    rel.getRelative(0, 1, 0).lsetType(Material.SNOW);
                }
            }
        }
    }

    public static void replaceUpperSphere(int seed, float rX, float rY, float rZ, SimpleBlock block, boolean hardReplace, Material ... type) {
        if (rX <= 0.0f && rY <= 0.0f && rZ <= 0.0f) {
            return;
        }
        if ((double)rX <= 0.5 && (double)rY <= 0.5 && (double)rZ <= 0.5) {
            block.setType(GenUtils.randMaterial(new Random(seed), type));
            return;
        }
        Random rand = new Random(seed);
        FastNoise noise = new FastNoise(seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.09f);
        for (float x = -rX; x <= rX; x += 1.0f) {
            for (float y = 0.0f; y <= rY; y += 1.0f) {
                for (float z = -rZ; z <= rZ; z += 1.0f) {
                    SimpleBlock rel = block.getRelative(Math.round(x), Math.round(y), Math.round(z));
                    double equationResult = Math.pow(x, 2.0) / Math.pow(rX, 2.0) + Math.pow(y, 2.0) / Math.pow(rY, 2.0) + Math.pow(z, 2.0) / Math.pow(rZ, 2.0);
                    if (!(equationResult <= 1.0 + 0.7 * (double)noise.GetNoise(rel.getX(), rel.getY(), rel.getZ())) || !hardReplace && rel.getType().isSolid()) continue;
                    rel.setType(GenUtils.randMaterial(rand, type));
                }
            }
        }
    }

    public static void replaceLowerSphere(int seed, float rX, float rY, float rZ, SimpleBlock block, boolean hardReplace, Material ... type) {
        if (rX <= 0.0f && rY <= 0.0f && rZ <= 0.0f) {
            return;
        }
        if ((double)rX <= 0.5 && (double)rY <= 0.5 && (double)rZ <= 0.5) {
            block.setType(GenUtils.randMaterial(new Random(seed), type));
            return;
        }
        Random rand = new Random(seed);
        FastNoise noise = new FastNoise(seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.09f);
        for (float x = -rX; x <= rX; x += 1.0f) {
            for (float y = -rY; y <= 0.0f; y += 1.0f) {
                for (float z = -rZ; z <= rZ; z += 1.0f) {
                    SimpleBlock rel = block.getRelative(Math.round(x), Math.round(y), Math.round(z));
                    double equationResult = Math.pow(x, 2.0) / Math.pow(rX, 2.0) + Math.pow(y, 2.0) / Math.pow(rY, 2.0) + Math.pow(z, 2.0) / Math.pow(rZ, 2.0);
                    if (!(equationResult <= 1.0 + 0.7 * (double)noise.GetNoise(rel.getX(), rel.getY(), rel.getZ())) || !hardReplace && rel.getType().isSolid()) continue;
                    rel.setType(GenUtils.randMaterial(rand, type));
                }
            }
        }
    }

    public static BlockFace[] getAdjacentFaces(BlockFace original) {
        switch (original) {
            case EAST: {
                return new BlockFace[]{BlockFace.SOUTH, BlockFace.NORTH};
            }
            case NORTH: {
                return new BlockFace[]{BlockFace.EAST, BlockFace.WEST};
            }
            case SOUTH: {
                return new BlockFace[]{BlockFace.WEST, BlockFace.EAST};
            }
        }
        return new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH};
    }

    public static BlockFace getTurnBlockFace(Random rand, BlockFace original) {
        return BlockUtils.getAdjacentFaces(original)[GenUtils.randInt(rand, 0, 1)];
    }

    public static BlockFace getLeft(BlockFace original) {
        return BlockUtils.getAdjacentFaces(original)[0];
    }

    public static BlockFace getRight(BlockFace original) {
        return BlockUtils.getAdjacentFaces(original)[1];
    }

    public static void correctMultifacingData(SimpleBlock target) {
        if (!(target.getBlockData() instanceof MultipleFacing)) {
            if (Tag.WALLS.isTagged((Keyed)target.getType())) {
                v1_16_R1_BlockDataFixer.correctSurroundingWallData(target);
            }
            return;
        }
        MultipleFacing data = (MultipleFacing)target.getBlockData();
        for (BlockFace face : data.getAllowedFaces()) {
            boolean facing;
            Material type = target.getRelative(face).getType();
            boolean bl = facing = type.isSolid() && !Tag.PRESSURE_PLATES.isTagged((Keyed)type) && !Tag.BANNERS.isTagged((Keyed)type) && !Tag.SLABS.isTagged((Keyed)type) && !Tag.TRAPDOORS.isTagged((Keyed)type);
            if (glassPanes.contains(target.getType()) && (Tag.FENCE_GATES.isTagged((Keyed)type) || Tag.FENCES.isTagged((Keyed)type))) {
                facing = false;
            }
            data.setFace(face, facing);
            if (!Tag.STAIRS.isTagged((Keyed)type)) continue;
            Stairs stairs = (Stairs)target.getRelative(face).getBlockData();
            if (stairs.getFacing() == face.getOppositeFace()) {
                data.setFace(face, true);
                continue;
            }
            data.setFace(face, false);
        }
        target.setBlockData((BlockData)data);
    }

    public static boolean isExposedToNonSolid(SimpleBlock target) {
        for (BlockFace face : directBlockFaces) {
            if (target.getRelative(face).getType().isSolid()) continue;
            return true;
        }
        return false;
    }

    public static boolean isExposedToMaterial(SimpleBlock target, Material mat) {
        for (BlockFace face : directBlockFaces) {
            if (target.getRelative(face).getType() != mat) continue;
            return true;
        }
        return false;
    }

    public static void correctSurroundingMultifacingData(SimpleBlock target) {
        if (!(target.getBlockData() instanceof MultipleFacing)) {
            if (Version.isAtLeast(16.1) && Tag.WALLS.isTagged((Keyed)target.getType())) {
                v1_16_R1_BlockDataFixer.correctSurroundingWallData(target);
            }
            return;
        }
        BlockUtils.correctMultifacingData(target);
        if (!(target.getBlockData() instanceof MultipleFacing)) {
            return;
        }
        MultipleFacing data = (MultipleFacing)target.getBlockData();
        for (BlockFace face : data.getAllowedFaces()) {
            if (!(target.getRelative(face).getBlockData() instanceof MultipleFacing)) continue;
            BlockUtils.correctMultifacingData(target.getRelative(face));
        }
    }

    public static void correctStairData(SimpleBlock target) {
        if (!(target.getBlockData() instanceof Stairs)) {
            return;
        }
        Stairs data = (Stairs)target.getBlockData();
        BlockFace left = BlockUtils.getLeft(data.getFacing());
        BlockFace right = BlockUtils.getRight(data.getFacing());
        if (Tag.STAIRS.isTagged((Keyed)target.getRelative(left).getType()) && !Tag.STAIRS.isTagged((Keyed)target.getRelative(right).getType())) {
            if (((Stairs)target.getRelative(left).getBlockData()).getFacing() == data.getFacing()) {
                if (Tag.STAIRS.isTagged((Keyed)target.getRelative(data.getFacing()).getType())) {
                    if (((Stairs)target.getRelative(data.getFacing()).getBlockData()).getFacing() == BlockUtils.getLeft(data.getFacing())) {
                        data.setShape(Stairs.Shape.OUTER_RIGHT);
                    }
                } else if (Tag.STAIRS.isTagged((Keyed)target.getRelative(data.getFacing().getOppositeFace()).getType()) && ((Stairs)target.getRelative(data.getFacing().getOppositeFace()).getBlockData()).getFacing() == BlockUtils.getRight(data.getFacing())) {
                    data.setShape(Stairs.Shape.INNER_RIGHT);
                }
            }
        } else if (!Tag.STAIRS.isTagged((Keyed)target.getRelative(left).getType()) && Tag.STAIRS.isTagged((Keyed)target.getRelative(right).getType()) && ((Stairs)target.getRelative(right).getBlockData()).getFacing() == data.getFacing()) {
            if (Tag.STAIRS.isTagged((Keyed)target.getRelative(data.getFacing()).getType())) {
                if (((Stairs)target.getRelative(data.getFacing()).getBlockData()).getFacing() == BlockUtils.getRight(data.getFacing())) {
                    data.setShape(Stairs.Shape.OUTER_LEFT);
                }
            } else if (Tag.STAIRS.isTagged((Keyed)target.getRelative(data.getFacing().getOppositeFace()).getType()) && ((Stairs)target.getRelative(data.getFacing().getOppositeFace()).getBlockData()).getFacing() == BlockUtils.getLeft(data.getFacing())) {
                data.setShape(Stairs.Shape.INNER_LEFT);
            }
        }
        target.setBlockData((BlockData)data);
    }

    public static void correctSurroundingStairData(SimpleBlock target) {
        if (!(target.getBlockData() instanceof Stairs)) {
            return;
        }
        BlockUtils.correctStairData(target);
        Stairs data = (Stairs)target.getBlockData();
        for (BlockFace face : BlockUtils.getAdjacentFaces(data.getFacing())) {
            if (!(target.getRelative(face).getBlockData() instanceof Stairs)) continue;
            BlockUtils.correctStairData(target.getRelative(face));
        }
    }

    private static boolean isMushroom(SimpleBlock target) {
        Material material = target.getType();
        return material == Material.BROWN_MUSHROOM_BLOCK || material == Material.RED_MUSHROOM_BLOCK;
    }

    public static void correctMushroomData(SimpleBlock target) {
        if (!BlockUtils.isMushroom(target)) {
            return;
        }
        MultipleFacing data = (MultipleFacing)target.getBlockData();
        Iterator iterator = data.getAllowedFaces().iterator();
        while (iterator.hasNext()) {
            BlockFace face;
            data.setFace(face, !BlockUtils.isMushroom(target.getRelative(face = (BlockFace)iterator.next())));
        }
        target.setBlockData((BlockData)data);
    }

    public static void correctSurroundingMushroomData(SimpleBlock target) {
        BlockUtils.correctMushroomData(target);
        for (BlockFace face : sixBlockFaces) {
            BlockUtils.correctMushroomData(target.getRelative(face));
        }
    }

    public static void placeDoor(PopulatorDataAbstract data, Material mat, Wall w) {
        BlockUtils.placeDoor(data, mat, w.getX(), w.getY(), w.getZ(), w.getDirection());
    }

    public static void placeDoor(PopulatorDataAbstract data, Material mat, int x, int y, int z, BlockFace dir) {
        data.setType(x, y, z, mat);
        data.setType(x, y + 1, z, mat);
        Door door = (Door)Bukkit.createBlockData((Material)mat);
        door.setFacing(dir);
        door.setHalf(Bisected.Half.BOTTOM);
        data.setBlockData(x, y, z, (BlockData)door);
        door = (Door)Bukkit.createBlockData((Material)mat);
        door.setFacing(dir);
        door.setHalf(Bisected.Half.TOP);
        data.setBlockData(x, y + 1, z, (BlockData)door);
    }

    public static void placeBed(SimpleBlock block, Material mat, BlockFace dir) {
        if (BlockUtils.isAir(block.getType()) && BlockUtils.isAir(block.getRelative(dir).getType())) {
            Bed bed = (Bed)Bukkit.createBlockData((Material)mat);
            bed.setFacing(dir.getOppositeFace());
            bed.setPart(Bed.Part.HEAD);
            block.setBlockData((BlockData)bed);
            bed = (Bed)Bukkit.createBlockData((Material)mat);
            bed.setFacing(dir.getOppositeFace());
            bed.setPart(Bed.Part.FOOT);
            block.getRelative(dir).setBlockData((BlockData)bed);
        }
    }

    public static BlockFace[] getDirectFacesFromDiagonal(BlockFace face) {
        switch (face) {
            case NORTH_EAST: {
                return new BlockFace[]{BlockFace.NORTH, BlockFace.EAST};
            }
            case NORTH_WEST: {
                return new BlockFace[]{BlockFace.NORTH, BlockFace.WEST};
            }
            case SOUTH_EAST: {
                return new BlockFace[]{BlockFace.SOUTH, BlockFace.EAST};
            }
            case SOUTH_WEST: {
                return new BlockFace[]{BlockFace.SOUTH, BlockFace.EAST};
            }
        }
        throw new UnsupportedOperationException("getDirectFacesFromDiagonal can only be used for XZ-Plane diagonals");
    }

    public static void placeRail(SimpleBlock block, Material mat) {
        Rail rail = (Rail)Bukkit.createBlockData((Material)mat);
        EnumSet<BlockFace> faces = EnumSet.noneOf(BlockFace.class);
        BlockFace upperFace = null;
        for (BlockFace face : directBlockFaces) {
            SimpleBlock relative = block.getRelative(face);
            if (Tag.RAILS.isTagged((Keyed)relative.getType())) {
                faces.add(face);
            }
            if (!Tag.RAILS.isTagged((Keyed)relative.getUp().getType())) continue;
            upperFace = face;
        }
        if (upperFace != null) {
            switch (upperFace) {
                case NORTH: {
                    rail.setShape(Rail.Shape.ASCENDING_NORTH);
                    break;
                }
                case SOUTH: {
                    rail.setShape(Rail.Shape.ASCENDING_SOUTH);
                    break;
                }
                case EAST: {
                    rail.setShape(Rail.Shape.ASCENDING_EAST);
                    break;
                }
                case WEST: {
                    rail.setShape(Rail.Shape.ASCENDING_WEST);
                    break;
                }
            }
        } else if (!faces.isEmpty()) {
            if (faces.contains(BlockFace.NORTH) && faces.contains(BlockFace.EAST)) {
                rail.setShape(Rail.Shape.NORTH_EAST);
            } else if (faces.contains(BlockFace.NORTH) && faces.contains(BlockFace.WEST)) {
                rail.setShape(Rail.Shape.NORTH_WEST);
            } else if (faces.contains(BlockFace.SOUTH) && faces.contains(BlockFace.EAST)) {
                rail.setShape(Rail.Shape.SOUTH_EAST);
            } else if (faces.contains(BlockFace.NORTH) || faces.contains(BlockFace.SOUTH)) {
                rail.setShape(Rail.Shape.NORTH_SOUTH);
            } else if (faces.contains(BlockFace.EAST) || faces.contains(BlockFace.WEST)) {
                rail.setShape(Rail.Shape.EAST_WEST);
            }
        }
        block.setBlockData((BlockData)rail);
    }

    public static void correctSurroundingRails(SimpleBlock target) {
        if (!(target.getBlockData() instanceof Rail)) {
            return;
        }
        BlockUtils.placeRail(target, target.getType());
        for (BlockFace face : directBlockFaces) {
            SimpleBlock relative = target.getRelative(face);
            if (relative.getBlockData() instanceof Rail) {
                BlockUtils.placeRail(relative, relative.getType());
            }
            if (!(target.getRelative(face).getRelative(0, -1, 0).getBlockData() instanceof Rail)) continue;
            BlockUtils.placeRail(relative.getRelative(0, -1, 0), target.getRelative(0, -1, 0).getRelative(face).getType());
        }
    }

    public static boolean emitsLight(Material mat) {
        switch (mat) {
            case TORCH: 
            case SEA_PICKLE: 
            case SEA_LANTERN: 
            case GLOWSTONE: 
            case LANTERN: 
            case LAVA: 
            case CAMPFIRE: 
            case REDSTONE_LAMP: 
            case FIRE: {
                return true;
            }
        }
        return false;
    }

    public static BlockData infestStone(BlockData mat) {
        switch (mat.getMaterial()) {
            case STONE_BRICKS: {
                return Bukkit.createBlockData((Material)Material.INFESTED_STONE_BRICKS);
            }
            case MOSSY_STONE_BRICKS: {
                return Bukkit.createBlockData((Material)Material.INFESTED_MOSSY_STONE_BRICKS);
            }
            case CRACKED_STONE_BRICKS: {
                return Bukkit.createBlockData((Material)Material.INFESTED_CRACKED_STONE_BRICKS);
            }
            case CHISELED_STONE_BRICKS: {
                return Bukkit.createBlockData((Material)Material.INFESTED_CHISELED_STONE_BRICKS);
            }
            case COBBLESTONE: {
                return Bukkit.createBlockData((Material)Material.INFESTED_COBBLESTONE);
            }
            case STONE: {
                return Bukkit.createBlockData((Material)Material.INFESTED_STONE);
            }
        }
        return mat;
    }

    public static void stairwayUntilSolid(SimpleBlock start, BlockFace extensionDir, Material[] downTypes, Material ... stairTypes) {
        while (!start.getType().isSolid()) {
            new StairBuilder(stairTypes).setFacing(extensionDir.getOppositeFace()).apply(start);
            BlockUtils.setDownUntilSolid(start.getX(), start.getY() - 1, start.getZ(), start.getPopData(), downTypes);
            start = start.getRelative(extensionDir).getRelative(0, -1, 0);
        }
    }

    public static boolean isAir(Material mat) {
        return airs.contains(mat);
    }

    public static BlockData getRandomBarrel() {
        Directional barrel = (Directional)Bukkit.createBlockData((Material)Material.BARREL);
        barrel.setFacing(sixBlockFaces[GenUtils.randInt(0, sixBlockFaces.length - 1)]);
        return barrel;
    }

    public static void angledStairwayUntilSolid(SimpleBlock start, BlockFace extensionDir, Material[] downTypes, Material ... stairTypes) {
        int threshold = 5;
        while (!start.getType().isSolid()) {
            if (threshold == 0) {
                extensionDir = BlockUtils.getTurnBlockFace(new Random(), extensionDir);
            }
            new StairBuilder(stairTypes).setFacing(extensionDir.getOppositeFace()).apply(start);
            BlockUtils.setDownUntilSolid(start.getX(), start.getY() - 1, start.getZ(), start.getPopData(), downTypes);
            --threshold;
            start = start.getRelative(extensionDir).getRelative(0, -1, 0);
        }
    }

    public static boolean isWet(SimpleBlock target) {
        return wetMaterials.contains(target.getType()) || target.getBlockData() instanceof Waterlogged && ((Waterlogged)target.getBlockData()).isWaterlogged();
    }

    public static float yawFromBlockFace(BlockFace face) {
        switch (face) {
            case EAST: {
                return -90.0f;
            }
            case NORTH: {
                return 180.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
            case WEST: {
                return 90.0f;
            }
        }
        return 180.0f;
    }

    public static void randRotateBlockData(Random rand, BlockData data) {
        if (data instanceof Directional) {
            Set faces = ((Directional)data).getFaces();
            ((Directional)data).setFacing((BlockFace)faces.stream().skip((int)((double)faces.size() * rand.nextDouble())).findAny().get());
        } else if (data instanceof Rotatable) {
            ((Rotatable)data).setRotation(BlockUtils.getXZPlaneBlockFace(rand));
        }
    }

    public static boolean isOre(Material mat) {
        for (Material ore : ores) {
            if (ore != mat) continue;
            return true;
        }
        return false;
    }
}

