/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils;

import java.util.ArrayList;
import java.util.Random;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockFace;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Rotatable;
import org.terraform.coregen.populatordata.PopulatorDataPostGen;
import org.terraform.data.SimpleBlock;

public class BannerUtils {
    private static final Material[] BANNERS = new Material[]{Material.RED_BANNER, Material.ORANGE_BANNER, Material.YELLOW_BANNER, Material.LIME_BANNER, Material.GREEN_BANNER, Material.CYAN_BANNER, Material.BLUE_BANNER, Material.PURPLE_BANNER, Material.MAGENTA_BANNER, Material.BLACK_BANNER, Material.BROWN_BANNER, Material.PINK_BANNER, Material.WHITE_BANNER};
    private static final Material[] WALL_BANNERS = new Material[]{Material.RED_WALL_BANNER, Material.ORANGE_WALL_BANNER, Material.YELLOW_WALL_BANNER, Material.LIME_WALL_BANNER, Material.GREEN_WALL_BANNER, Material.CYAN_WALL_BANNER, Material.BLUE_WALL_BANNER, Material.PURPLE_WALL_BANNER, Material.MAGENTA_WALL_BANNER, Material.BLACK_WALL_BANNER, Material.BROWN_WALL_BANNER, Material.PINK_WALL_BANNER, Material.WHITE_WALL_BANNER};

    public static Banner generateBanner(SimpleBlock base, BlockFace facing, Material type, ArrayList<Pattern> patterns) {
        base.setType(type);
        Directional bd = (Directional)base.getBlockData();
        bd.setFacing(facing);
        base.setBlockData((BlockData)bd);
        Banner banner = (Banner)((PopulatorDataPostGen)base.getPopData()).getBlockState(base.getX(), base.getY(), base.getZ());
        if (patterns == null) {
            patterns = new ArrayList();
        }
        banner.setPatterns(patterns);
        banner.update();
        return banner;
    }

    public static Banner generateBanner(Random rand, SimpleBlock base, BlockFace facing, boolean wallBanner) {
        Material type = null;
        if (wallBanner) {
            type = BannerUtils.randomWallBannerMaterial(rand);
        } else {
            BannerUtils.randomBannerMaterial(rand);
        }
        base.setType(type);
        if (!wallBanner) {
            bd = (Rotatable)base.getBlockData();
            bd.setRotation(facing);
            base.setBlockData((BlockData)bd);
        } else {
            bd = (Directional)base.getBlockData();
            bd.setFacing(facing);
            base.setBlockData((BlockData)bd);
        }
        Banner banner = (Banner)((PopulatorDataPostGen)base.getPopData()).getBlockState(base.getX(), base.getY(), base.getZ());
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (int i = 1 + rand.nextInt(3); i < 4 + rand.nextInt(3); ++i) {
            patterns.add(new Pattern(DyeColor.values()[rand.nextInt(DyeColor.values().length)], PatternType.values()[rand.nextInt(PatternType.values().length)]));
        }
        banner.setPatterns(patterns);
        banner.update();
        return banner;
    }

    public static Banner generatePillagerBanner(SimpleBlock base, BlockFace facing, boolean wallBanner) {
        Material type = null;
        type = wallBanner ? Material.WHITE_WALL_BANNER : Material.WHITE_BANNER;
        base.setType(type);
        if (!wallBanner) {
            bd = (Rotatable)base.getBlockData();
            bd.setRotation(facing);
            base.setBlockData((BlockData)bd);
        } else {
            bd = (Directional)base.getBlockData();
            bd.setFacing(facing);
            base.setBlockData((BlockData)bd);
        }
        Banner banner = (Banner)((PopulatorDataPostGen)base.getPopData()).getBlockState(base.getX(), base.getY(), base.getZ());
        banner.setPatterns(BannerUtils.getOminousBannerPatterns());
        banner.update();
        return banner;
    }

    public static Material randomBannerMaterial(Random rand) {
        return BANNERS[rand.nextInt(BANNERS.length)];
    }

    public static Material randomWallBannerMaterial(Random rand) {
        return WALL_BANNERS[rand.nextInt(WALL_BANNERS.length)];
    }

    public static ArrayList<Pattern> getOminousBannerPatterns() {
        return new ArrayList<Pattern>(){
            {
                this.add(new Pattern(DyeColor.CYAN, PatternType.RHOMBUS_MIDDLE));
                this.add(new Pattern(DyeColor.LIGHT_GRAY, PatternType.STRIPE_BOTTOM));
                this.add(new Pattern(DyeColor.GRAY, PatternType.STRIPE_CENTER));
                this.add(new Pattern(DyeColor.LIGHT_GRAY, PatternType.BORDER));
                this.add(new Pattern(DyeColor.BLACK, PatternType.STRIPE_MIDDLE));
                this.add(new Pattern(DyeColor.LIGHT_GRAY, PatternType.HALF_HORIZONTAL));
                this.add(new Pattern(DyeColor.LIGHT_GRAY, PatternType.CIRCLE_MIDDLE));
                this.add(new Pattern(DyeColor.BLACK, PatternType.BORDER));
            }
        };
    }
}

