/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.utils;

import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.terraform.coregen.populatordata.PopulatorDataPostGen;
import org.terraform.data.SimpleBlock;
import org.terraform.utils.BlockUtils;

public class ArmorStandUtils {
    public static void placeArmorStand(SimpleBlock target, BlockFace facing, Random rand) {
        ArmorStandUtils.placeArmorStand(target, facing, ArmorStandQuality.rollQuality(rand));
    }

    public static void placeArmorStand(SimpleBlock target, BlockFace facing, ArmorStandQuality quality) {
        if (target.getPopData() instanceof PopulatorDataPostGen) {
            PopulatorDataPostGen postGen = (PopulatorDataPostGen)target.getPopData();
            ArmorStand stand = (ArmorStand)postGen.getWorld().spawnEntity(new Location(postGen.getWorld(), (double)((float)target.getX() + 0.5f), (double)target.getY(), (double)((float)target.getZ() + 0.5f)), EntityType.ARMOR_STAND);
            stand.setRotation(BlockUtils.yawFromBlockFace(facing), 0.0f);
            quality.apply(stand);
        }
    }

    public static enum ArmorStandQuality {
        LEATHER(Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS),
        IRON(Material.IRON_HELMET, Material.IRON_CHESTPLATE, Material.IRON_LEGGINGS, Material.IRON_BOOTS),
        GOLD(Material.GOLDEN_HELMET, Material.GOLDEN_CHESTPLATE, Material.GOLDEN_LEGGINGS, Material.GOLDEN_BOOTS),
        DIAMOND(Material.DIAMOND_HELMET, Material.DIAMOND_CHESTPLATE, Material.DIAMOND_LEGGINGS, Material.DIAMOND_BOOTS);

        private Material[] pieces;

        private ArmorStandQuality(Material ... pieces) {
            this.pieces = pieces;
        }

        public void apply(ArmorStand entity) {
            entity.getEquipment().setHelmet(new ItemStack(this.pieces[0]));
            entity.getEquipment().setChestplate(new ItemStack(this.pieces[1]));
            entity.getEquipment().setLeggings(new ItemStack(this.pieces[2]));
            entity.getEquipment().setBoots(new ItemStack(this.pieces[3]));
        }

        public static ArmorStandQuality rollQuality(Random rand) {
            int weight = rand.nextInt(100);
            if (weight > 95) {
                return DIAMOND;
            }
            if (weight > 60) {
                return IRON;
            }
            if (weight > 30) {
                return GOLD;
            }
            return LEATHER;
        }
    }
}

