/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.tree;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.main.config.TConfigOption;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class TreeDB {
    private static final FractalTypes.Tree[] FRACTAL_CORAL_TYPES = new FractalTypes.Tree[]{FractalTypes.Tree.FIRE_CORAL, FractalTypes.Tree.BRAIN_CORAL, FractalTypes.Tree.TUBE_CORAL, FractalTypes.Tree.HORN_CORAL, FractalTypes.Tree.BUBBLE_CORAL};

    public static void spawnAzalea(Random random, TerraformWorld tw, PopulatorDataAbstract data, int x, int y, int z) {
        FractalTreeBuilder builder = new FractalTreeBuilder(FractalTypes.Tree.AZALEA_TOP);
        builder.build(tw, data, x, y, z);
        SimpleBlock rooter = new SimpleBlock(data, x, y - 1, z);
        rooter.setType(OneOneSevenBlockHandler.ROOTED_DIRT);
        rooter = rooter.getRelative(0, -1, 0);
        while (!BlockUtils.isAir(rooter.getType())) {
            rooter.setType(OneOneSevenBlockHandler.ROOTED_DIRT);
            for (BlockFace face : BlockUtils.xzPlaneBlockFaces) {
                SimpleBlock rel = rooter.getRelative(face);
                if (!random.nextBoolean() || !BlockUtils.isStoneLike(rel.getType())) continue;
                rel.setType(OneOneSevenBlockHandler.ROOTED_DIRT);
                if (!BlockUtils.isAir(rel.getRelative(0, -1, 0).getType())) continue;
                rel.getRelative(0, -1, 0).setType(OneOneSevenBlockHandler.HANGING_ROOTS);
            }
            rooter = rooter.getRelative(0, -1, 0);
        }
        rooter.setType(OneOneSevenBlockHandler.HANGING_ROOTS);
    }

    public static void spawnCoconutTree(TerraformWorld tw, PopulatorDataAbstract data, int x, int y, int z) {
        SimpleBlock base = new SimpleBlock(data, x, y, z);
        FractalTreeBuilder builder = new FractalTreeBuilder(FractalTypes.Tree.COCONUT_TOP);
        if (!builder.checkGradient(data, x, z)) {
            return;
        }
        Material log = Material.JUNGLE_WOOD;
        if (TConfigOption.MISC_TREES_FORCE_LOGS.getBoolean()) {
            log = Material.JUNGLE_LOG;
        }
        for (BlockFace face : BlockUtils.directBlockFaces) {
            new Wall(base.getRelative(face), BlockFace.NORTH).downUntilSolid(new Random(), log);
        }
        builder.build(tw, data, x, y, z);
    }

    public static void spawnSmallJungleTree(boolean skipGradientCheck, TerraformWorld tw, PopulatorDataAbstract data, int x, int y, int z) {
        FractalTreeBuilder ftb = GenUtils.chance(1, 8) ? new FractalTreeBuilder(FractalTypes.Tree.JUNGLE_EXTRA_SMALL) : new FractalTreeBuilder(FractalTypes.Tree.JUNGLE_SMALL);
        if (skipGradientCheck) {
            ftb.skipGradientCheck();
        }
        ftb.build(tw, data, x, y, z);
    }

    public static void spawnBigDarkOakTree(TerraformWorld tw, PopulatorDataAbstract data, int x, int y, int z) {
        FractalTreeBuilder bottomBuilder = new FractalTreeBuilder(FractalTypes.Tree.DARK_OAK_BIG_BOTTOM);
        if (!bottomBuilder.checkGradient(data, x, z)) {
            return;
        }
        new FractalTreeBuilder(FractalTypes.Tree.DARK_OAK_BIG_TOP).skipGradientCheck().build(tw, data, x, y, z);
        bottomBuilder.build(tw, data, x, y - 5, z);
    }

    public static void spawnRandomGiantCoral(TerraformWorld tw, PopulatorDataAbstract data, int x, int y, int z) {
        FractalTypes.Tree type = FRACTAL_CORAL_TYPES[tw.getHashedRand(x, y, z).nextInt(5)];
        FractalTreeBuilder ftb = new FractalTreeBuilder(type);
        ftb.setMaxHeight(TerraformGenerator.seaLevel - y - 1);
        ftb.build(tw, data, x, y - 2, z);
    }
}

