/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.tree;

import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiFunction;
import org.bukkit.Material;
import org.bukkit.util.Vector;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.tree.FractalLeaves;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;
import org.terraform.utils.version.BeeHiveSpawner;

public class NewFractalTreeBuilder {
    private int maxDepth = 3;
    private int originalTrunkLength = 20;
    private float lengthVariance = 4.0f;
    private float firstEnd = 0.8f;
    private int crownBranches = 3;
    private float initialBranchRadius = 3.0f;
    private double branchSpawnChance = 0.08f;
    private float minBranchSpawnLength = 0.4f;
    private int randomBranchSegmentCount = 3;
    private Vector initialNormal = new Vector(0, 1, 0);
    private double maxInitialNormalDelta = 0.3;
    private double minBranchHorizontalComponent = 0.5;
    private double maxBranchHorizontalComponent = 1.3;
    private int treeRootThreshold = 2;
    private float noisePriority = 0.1f;
    private FractalLeaves fractalLeaves;
    private BiFunction<Float, Float, Float> branchDecrement = (currentBranchLength, totalTreeHeight) -> Float.valueOf(currentBranchLength.floatValue() * 0.7f);
    private BiFunction<Float, Float, Float> getBranchWidth = (initialBranchWidth, branchRatio) -> Float.valueOf(initialBranchWidth.floatValue() * (1.0f - branchRatio.floatValue() / 2.0f));
    private float bendChance = 0.0f;
    private float bendMaxAngle = 0.0f;
    int maxHeight = 9999;
    private Material branchMaterial = Material.OAK_LOG;
    private boolean spawnBees = false;
    Random random;
    TerraformWorld tw;
    int oriY;
    private final HashSet<SimpleBlock> prospectiveHives = new HashSet();
    private double currentBranchTheta = 0.0;
    private static final int[][] rotationMatrixX = new int[][]{{1, 0, 0}, {0, 0, -1}, {0, 1, 0}};
    private static final int[][] rotationMatrixZ = new int[][]{{0, -1, 0}, {1, 0, 0}, {0, 0, 1}};

    public void build(TerraformWorld tw, SimpleBlock base) {
        this.prospectiveHives.clear();
        this.random = tw.getHashedRand(base.getX(), base.getY(), base.getZ());
        this.tw = tw;
        this.oriY = base.getY();
        this.currentBranchTheta = GenUtils.randInt(this.random, 0, this.randomBranchSegmentCount);
        this.fractalLeaves.purgeOccupiedLeavesCache();
        this.branch(base, this.initialNormal.clone().add(new Vector(GenUtils.randDouble(this.random, -this.maxInitialNormalDelta, this.maxInitialNormalDelta), 0.0, GenUtils.randDouble(this.random, -this.maxInitialNormalDelta, this.maxInitialNormalDelta))).normalize(), (float)this.originalTrunkLength + (float)GenUtils.randDouble(this.random, -this.lengthVariance, this.lengthVariance), this.firstEnd, 0, this.initialBranchRadius);
        if (this.spawnBees) {
            for (SimpleBlock b : this.prospectiveHives) {
                if (b.isSolid()) continue;
                BeeHiveSpawner.spawnFullBeeNest(b);
                break;
            }
        }
    }

    public void branch(SimpleBlock base, Vector normal, float length, float end, int depth, float currentWidth) {
        boolean spawnedNewBranch = false;
        SimpleBlock lastOperatedCentre = base;
        if (length > 0.0f && depth < this.maxDepth) {
            float initialWidth = currentWidth;
            FastNoise noiseGen = NoiseCacheHandler.getNoise(this.tw, NoiseCacheHandler.NoiseCacheEntry.FRACTALTREES_BASE_NOISE, world -> {
                FastNoise n = new FastNoise((int)world.getSeed());
                n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
                n.SetFractalOctaves(5);
                n.SetFrequency(0.05f);
                return n;
            });
            Vector branchVect = normal.clone().multiply(length);
            float subBranchLength = this.branchDecrement.apply(Float.valueOf(length), Float.valueOf(base.getY() - this.oriY)).floatValue();
            boolean placedPatcherLeaves = false;
            for (float i = 0.0f; i < length && !(i / length > end); i += 0.5f) {
                float appliedWidth = currentWidth;
                float appliedNoisePriority = this.noisePriority;
                Vector appliedNormal = normal;
                if (depth == 0 && i % 1.0f == 0.0f && i < (float)this.treeRootThreshold) {
                    appliedWidth = (float)((double)appliedWidth * (-0.5 * (double)(i / length) + 1.5));
                    appliedNoisePriority = 0.8f;
                    appliedNormal = new Vector(0, 1, 0);
                }
                lastOperatedCentre = this.generateRotatedCircle(lastOperatedCentre.getPopData(), branchVect.clone().multiply(i / length).add(base.toVector()), appliedNormal, appliedNoisePriority, appliedWidth, noiseGen, i);
                if (!placedPatcherLeaves && lastOperatedCentre.getY() < base.getY()) {
                    placedPatcherLeaves = true;
                    this.fractalLeaves.placeLeaves(this.tw, this.oriY, this.maxHeight, base);
                }
                currentWidth = this.getBranchWidth.apply(Float.valueOf(initialWidth), Float.valueOf(i / length)).floatValue();
                if (!(i / length > this.minBranchSpawnLength) || !GenUtils.chance(this.random, (int)(100.0 * this.branchSpawnChance), 100)) continue;
                spawnedNewBranch = true;
                this.branch(lastOperatedCentre, this.calculateNextProjection(normal, this.getNextTheta(this.randomBranchSegmentCount)), subBranchLength, 1.0f, depth + 1, currentWidth);
            }
            if (depth == 0 && this.crownBranches > 0) {
                double thetaDelta = Math.PI * 2 / (double)this.crownBranches;
                for (int i = 0; i < this.crownBranches; ++i) {
                    spawnedNewBranch = true;
                    this.branch(lastOperatedCentre, this.calculateNextProjection(normal, thetaDelta * (double)i), subBranchLength, 1.0f, depth + 1, currentWidth);
                }
            }
        }
        if (length <= 0.0f || !spawnedNewBranch || depth >= this.maxDepth) {
            this.fractalLeaves.placeLeaves(this.tw, this.oriY, this.maxHeight, lastOperatedCentre);
        }
    }

    private double getNextTheta(int numSegments) {
        double thetaDelta = Math.PI * 2 / (double)numSegments;
        this.currentBranchTheta += 1.0;
        return this.currentBranchTheta * thetaDelta;
    }

    private Vector calculateNextProjection(Vector normal, double theta) {
        Vector A = normal.clone();
        A.setX((double)rotationMatrixX[0][0] * normal.getX() + (double)rotationMatrixX[0][1] * normal.getY() + (double)rotationMatrixX[0][2] * normal.getZ());
        A.setY((double)rotationMatrixX[1][0] * normal.getX() + (double)rotationMatrixX[1][1] * normal.getY() + (double)rotationMatrixX[1][2] * normal.getZ());
        A.setZ((double)rotationMatrixX[2][0] * normal.getX() + (double)rotationMatrixX[2][1] * normal.getY() + (double)rotationMatrixX[2][2] * normal.getZ());
        double[][] rotationMatrixNormal = new double[][]{{Math.cos(theta), 0.0, Math.sin(theta)}, {0.0, 1.0, 0.0}, {-Math.sin(theta), 0.0, Math.cos(theta)}};
        A.setX(rotationMatrixNormal[0][0] * A.getX() + rotationMatrixNormal[0][1] * A.getY() + rotationMatrixNormal[0][2] * A.getZ());
        A.setY(rotationMatrixNormal[1][0] * A.getX() + rotationMatrixNormal[1][1] * A.getY() + rotationMatrixNormal[1][2] * A.getZ());
        A.setZ(rotationMatrixNormal[2][0] * A.getX() + rotationMatrixNormal[2][1] * A.getY() + rotationMatrixNormal[2][2] * A.getZ());
        return normal.clone().add(A.multiply(GenUtils.randDouble(this.random, this.minBranchHorizontalComponent, this.maxBranchHorizontalComponent))).normalize();
    }

    private SimpleBlock generateRotatedCircle(PopulatorDataAbstract data, Vector centre, Vector normal, float noisePriority, float radius, FastNoise noiseGen, float heightIndex) {
        if (radius <= 0.5f) {
            data.setType(centre, this.branchMaterial);
            return new SimpleBlock(data, centre);
        }
        Vector A = normal.clone();
        Vector B = normal.clone();
        A.setX((double)rotationMatrixX[0][0] * normal.getX() + (double)rotationMatrixX[0][1] * normal.getY() + (double)rotationMatrixX[0][2] * normal.getZ());
        A.setY((double)rotationMatrixX[1][0] * normal.getX() + (double)rotationMatrixX[1][1] * normal.getY() + (double)rotationMatrixX[1][2] * normal.getZ());
        A.setZ((double)rotationMatrixX[2][0] * normal.getX() + (double)rotationMatrixX[2][1] * normal.getY() + (double)rotationMatrixX[2][2] * normal.getZ());
        B.setX((double)rotationMatrixZ[0][0] * normal.getX() + (double)rotationMatrixZ[0][1] * normal.getY() + (double)rotationMatrixZ[0][2] * normal.getZ());
        B.setY((double)rotationMatrixZ[1][0] * normal.getX() + (double)rotationMatrixZ[1][1] * normal.getY() + (double)rotationMatrixZ[1][2] * normal.getZ());
        B.setZ((double)rotationMatrixZ[2][0] * normal.getX() + (double)rotationMatrixZ[2][1] * normal.getY() + (double)rotationMatrixZ[2][2] * normal.getZ());
        boolean didNotGenerate = true;
        double maxPossibleRadius = (1.0f + noisePriority * 2.0f) * radius;
        for (double rA = -maxPossibleRadius; rA <= maxPossibleRadius; rA += 1.0) {
            for (double rB = -maxPossibleRadius; rB <= maxPossibleRadius; rB += 1.0) {
                double newRadius;
                double distFromCentre = Math.sqrt(Math.pow(rA, 2.0) + Math.pow(rB, 2.0));
                double theta = Math.atan2(rB, rA);
                if (theta < 0.0) {
                    theta = Math.PI * 2 - theta;
                }
                if (!(distFromCentre <= (newRadius = noisePriority > 0.0f ? (double)(radius + noisePriority * radius * noiseGen.GetNoise(Objects.hash(centre.getX(), centre.getZ()), (float)theta, heightIndex)) : (double)radius))) continue;
                data.setType(centre.clone().add(A.clone().multiply(rA)).add(B.clone().multiply(rB)), this.branchMaterial);
                didNotGenerate = false;
                if (!this.spawnBees || !(centre.getY() > (double)((float)this.oriY + (float)this.originalTrunkLength / 2.0f)) || !GenUtils.chance(this.random, 1, 200)) continue;
                this.prospectiveHives.add(new SimpleBlock(data, centre.clone().add(A.clone().multiply(rA)).add(B.clone().multiply(rB)).add(new Vector(0, -1, 0))));
            }
        }
        if (didNotGenerate) {
            data.setType(centre, this.branchMaterial);
        }
        return new SimpleBlock(data, centre);
    }

    public NewFractalTreeBuilder setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    public NewFractalTreeBuilder setOriginalTrunkLength(int originalTrunkLength) {
        this.originalTrunkLength = originalTrunkLength;
        return this;
    }

    public NewFractalTreeBuilder setFirstEnd(float firstEnd) {
        this.firstEnd = firstEnd;
        return this;
    }

    public NewFractalTreeBuilder setCrownBranches(int crownBranches) {
        this.crownBranches = crownBranches;
        return this;
    }

    public NewFractalTreeBuilder setInitialBranchRadius(float initialBranchRadius) {
        this.initialBranchRadius = initialBranchRadius;
        return this;
    }

    public NewFractalTreeBuilder setBranchSpawnChance(double branchSpawnChance) {
        this.branchSpawnChance = branchSpawnChance;
        return this;
    }

    public NewFractalTreeBuilder setMinBranchSpawnLength(float minBranchSpawnLength) {
        this.minBranchSpawnLength = minBranchSpawnLength;
        return this;
    }

    public NewFractalTreeBuilder setTreeRootThreshold(int treeRootThreshold) {
        this.treeRootThreshold = treeRootThreshold;
        return this;
    }

    public NewFractalTreeBuilder setRandomBranchSegmentCount(int randomBranchSegmentCount) {
        this.randomBranchSegmentCount = randomBranchSegmentCount;
        return this;
    }

    public NewFractalTreeBuilder setInitialNormal(Vector initialNormal) {
        this.initialNormal = initialNormal;
        return this;
    }

    public NewFractalTreeBuilder setMaxInitialNormalDelta(double maxInitialNormalDelta) {
        this.maxInitialNormalDelta = maxInitialNormalDelta;
        return this;
    }

    public NewFractalTreeBuilder setMinBranchHorizontalComponent(double minBranchHorizontalComponent) {
        this.minBranchHorizontalComponent = minBranchHorizontalComponent;
        return this;
    }

    public NewFractalTreeBuilder setMaxBranchHorizontalComponent(double maxBranchHorizontalComponent) {
        this.maxBranchHorizontalComponent = maxBranchHorizontalComponent;
        return this;
    }

    public NewFractalTreeBuilder setFractalLeaves(FractalLeaves fractalLeaves) {
        this.fractalLeaves = fractalLeaves;
        return this;
    }

    public NewFractalTreeBuilder setBranchDecrement(BiFunction<Float, Float, Float> branchDecrement) {
        this.branchDecrement = branchDecrement;
        return this;
    }

    public NewFractalTreeBuilder setGetBranchWidth(BiFunction<Float, Float, Float> getBranchWidth) {
        this.getBranchWidth = getBranchWidth;
        return this;
    }

    public NewFractalTreeBuilder setSpawnBees(boolean spawnBees) {
        this.spawnBees = spawnBees;
        return this;
    }

    public NewFractalTreeBuilder setLengthVariance(float lengthVariance) {
        this.lengthVariance = lengthVariance;
        return this;
    }

    public NewFractalTreeBuilder setBendChance(float bendChance) {
        this.bendChance = bendChance;
        return this;
    }

    public NewFractalTreeBuilder setBendMaxAngle(float bendMaxAngle) {
        this.bendMaxAngle = bendMaxAngle;
        return this;
    }

    public NewFractalTreeBuilder setBranchMaterial(Material branchMaterial) {
        this.branchMaterial = branchMaterial;
        return this;
    }

    public NewFractalTreeBuilder setNoisePriority(float noisePriority) {
        this.noisePriority = noisePriority;
        return this;
    }

    public NewFractalTreeBuilder setMinInitialNormalDelta(float minInitialNormalDelta) {
        this.maxInitialNormalDelta = minInitialNormalDelta;
        return this;
    }
}

