/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.util.Vector;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfigOption;
import org.terraform.tree.FractalTypes;
import org.terraform.tree.VanillaMushroomBuilder;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.Vector2f;
import org.terraform.utils.noise.BezierCurve;
import org.terraform.utils.noise.BresenhamLine;
import org.terraform.utils.noise.FastNoise;

public class MushroomBuilder {
    Random rand;
    FastNoise noiseGen;
    SimpleBlock stemTop;
    FractalTypes.Mushroom type;
    FractalTypes.MushroomCap capShape = FractalTypes.MushroomCap.ROUND;
    Material stemType = Material.MUSHROOM_STEM;
    Material capType = Material.RED_MUSHROOM_BLOCK;
    Material spotType = Material.MUSHROOM_STEM;
    int baseHeight = 18;
    int heightVariation = 0;
    float baseThickness = 3.8f;
    float segmentFactor = 2.0f;
    Vector2f curvatureControlPoint1 = new Vector2f(-2.0f, 0.5f);
    Vector2f curvatureControlPoint2 = new Vector2f(1.6f, 0.4f);
    double thicknessIncrement = 1.0;
    Vector2f thicknessControlPoint1 = new Vector2f(0.5f, 0.5f);
    Vector2f thicknessControlPoint2 = new Vector2f(0.5f, 0.5f);
    float capRadius = 10.0f;
    int capYOffset = -5;
    double minTilt = 0.06544984694978735;
    double maxTilt = 0.15707963267948966;
    boolean fourAxisRotationOnly = false;

    public MushroomBuilder(FractalTypes.Mushroom type) {
        this.type = type;
        switch (type) {
            case GIANT_BROWN_FUNNEL_MUSHROOM: {
                this.setCapType(Material.BROWN_MUSHROOM_BLOCK).setCapRadius(13.0f).setCapYOffset(-2).setCapShape(FractalTypes.MushroomCap.FUNNEL);
                break;
            }
            case GIANT_BROWN_MUSHROOM: {
                this.setCapType(Material.BROWN_MUSHROOM_BLOCK);
                break;
            }
            case GIANT_RED_MUSHROOM: {
                this.setBaseThickness(6.0f).setThicknessIncrement(1.5).setCapRadius(15.0f).setCapYOffset(-10);
                break;
            }
            case MEDIUM_BROWN_FUNNEL_MUSHROOM: {
                this.setCapType(Material.BROWN_MUSHROOM_BLOCK).setCapRadius(5.0f).setCapYOffset(-1).setBaseHeight(8).setBaseThickness(1.2f).setCapShape(FractalTypes.MushroomCap.FUNNEL);
                break;
            }
            case MEDIUM_BROWN_MUSHROOM: {
                this.setCapType(Material.BROWN_MUSHROOM_BLOCK).setCapRadius(5.0f).setCapYOffset(-2).setBaseHeight(8).setBaseThickness(1.2f);
                break;
            }
            case MEDIUM_RED_MUSHROOM: {
                this.setBaseThickness(1.3f).setBaseHeight(8).setThicknessIncrement(1.2f).setCapRadius(4.5f).setCapYOffset(-3);
                break;
            }
            case SMALL_BROWN_MUSHROOM: {
                this.setBaseThickness(0.0f).setThicknessIncrement(0.0).setBaseHeight(5).setCapType(Material.BROWN_MUSHROOM_BLOCK).setMinTilt(0.0).setMaxTilt(0.39269908169872414).setStemCurve(0.8f, 0.2f, 0.8f, 0.4f).setFourAxisRotationOnly(true).setCapShape(FractalTypes.MushroomCap.FLAT).setCapRadius(3.0f).setCapYOffset(0);
                break;
            }
            case SMALL_RED_MUSHROOM: {
                this.setBaseThickness(0.0f).setThicknessIncrement(0.5).setBaseHeight(4).setMaxTilt(0.39269908169872414).setMinTilt(0.0).setStemCurve(0.8f, 0.2f, 0.8f, 0.4f).setFourAxisRotationOnly(true).setCapRadius(2.3f).setCapYOffset(-1);
                break;
            }
            case SMALL_POINTY_RED_MUSHROOM: {
                this.setBaseThickness(0.0f).setThicknessIncrement(0.0).setBaseHeight(6).setMaxTilt(0.17453292519943295).setMinTilt(0.0).setFourAxisRotationOnly(true).setStemCurve(0.8f, 0.2f, 0.8f, 0.4f).setCapRadius(2.3f).setCapYOffset(-2).setCapShape(FractalTypes.MushroomCap.POINTY);
                break;
            }
            case TINY_RED_MUSHROOM: {
                this.setBaseThickness(0.0f).setThicknessIncrement(0.0).setBaseHeight(4).setMinTilt(0.0).setMaxTilt(0.0).setStemCurve(0.5f, 0.5f, 0.5f, 0.5f).setSegmentFactor(1.0f).setCapRadius(1.2f).setCapYOffset(-2).setCapShape(FractalTypes.MushroomCap.POINTY);
            }
            case TINY_BROWN_MUSHROOM: {
                this.setBaseThickness(0.0f).setThicknessIncrement(0.0).setBaseHeight(2).setMinTilt(0.0).setMaxTilt(0.0).setStemCurve(0.5f, 0.5f, 0.5f, 0.5f).setSegmentFactor(1.0f).setCapRadius(1.5f).setCapYOffset(1).setCapShape(FractalTypes.MushroomCap.ROUND).setCapType(Material.BROWN_MUSHROOM_BLOCK);
            }
        }
    }

    private void replaceSphere(float radius, SimpleBlock base, Material type) {
        if ((double)radius < 0.5) {
            if (!base.getType().isSolid()) {
                base.setType(type);
            }
            return;
        }
        this.noiseGen.SetNoiseType(FastNoise.NoiseType.Simplex);
        this.noiseGen.SetFrequency(0.09f);
        for (int x = -Math.round(radius); x <= Math.round(radius); ++x) {
            for (int y = -Math.round(radius); y <= Math.round(radius); ++y) {
                for (int z = -Math.round(radius); z <= Math.round(radius); ++z) {
                    SimpleBlock block = base.getRelative(x, y, z);
                    if (!(Math.pow(x, 2.0) / Math.pow(radius, 2.0) + Math.pow(y, 2.0) / Math.pow(radius, 2.0) + Math.pow(z, 2.0) / Math.pow(radius, 2.0) <= 1.0 + 0.7 * (double)this.noiseGen.GetNoise(block.getX(), block.getY(), block.getZ())) || block.getType().isSolid()) continue;
                    block.setType(type);
                }
            }
        }
    }

    public void spawnSphericalCap(int seed, float r, float ry, SimpleBlock base, boolean hardReplace, Material ... type) {
        Random rand = new Random(seed);
        this.noiseGen.SetNoiseType(FastNoise.NoiseType.Simplex);
        this.noiseGen.SetFrequency(1.4f);
        float belowY = -0.5f * ry;
        float lowThreshold = Math.min((float)(0.12 * (double)Math.min(r, ry)), 0.6f);
        for (int x = Math.round(-r); x <= Math.round(r); ++x) {
            for (int y = Math.round(belowY); y <= Math.round(ry); ++y) {
                for (int z = Math.round(-r); z <= Math.round(r); ++z) {
                    float factor = (float)y / belowY;
                    if (y < 0 && (double)(factor + Math.abs(this.noiseGen.GetNoise((float)x / r, (float)z / r))) > 0.6) continue;
                    SimpleBlock rel = base.getRelative(x, y, z);
                    double equationResult = Math.pow(x, 2.0) / Math.pow(r, 2.0) + Math.pow(y, 2.0) / Math.pow(ry, 2.0) + Math.pow(z, 2.0) / Math.pow(r, 2.0);
                    if (!(equationResult <= 1.0 + 0.25 * (double)Math.abs(this.noiseGen.GetNoise((float)x / r, (float)y / ry, (float)z / r))) || !(equationResult >= (double)lowThreshold) || !hardReplace && rel.getType().isSolid()) continue;
                    rel.setType(GenUtils.randMaterial(rand, type));
                    BlockUtils.correctSurroundingMushroomData(rel);
                }
            }
        }
    }

    public void build(TerraformWorld tw, PopulatorDataAbstract data, int x, int y, int z) {
        if (TConfigOption.DEVSTUFF_VANILLA_MUSHROOMS.getBoolean()) {
            String schemName = this.type.toString().contains("RED") ? "redmushroomcap" : "brownmushroomcap";
            VanillaMushroomBuilder.buildVanillaMushroom(tw, data, x, y, z, schemName);
            return;
        }
        this.noiseGen = new FastNoise((int)tw.getSeed());
        this.rand = tw.getRand(256L * (long)x + 16L * (long)y + (long)z);
        SimpleBlock base = new SimpleBlock(data, x, y, z);
        if (this.stemTop == null) {
            this.stemTop = base;
        }
        double initialAngle = this.fourAxisRotationOnly ? 1.5707963267948966 * (double)Math.round(Math.random() * 4.0) : Math.PI * 2 * Math.random();
        int initialHeight = this.baseHeight + GenUtils.randInt(-this.heightVariation, this.heightVariation);
        this.createStem(base, GenUtils.randDouble(this.rand, this.minTilt, this.maxTilt), initialAngle, this.baseThickness, initialHeight);
        switch (this.capShape) {
            case ROUND: {
                this.spawnSphericalCap(tw.getHashedRand(x, y, z).nextInt(94929297), this.capRadius, this.capRadius, this.stemTop.getRelative(0, this.capYOffset, 0), true, this.capType);
                break;
            }
            case FLAT: {
                this.spawnSphericalCap(tw.getHashedRand(x, y, z).nextInt(94929297), this.capRadius, 0.6f * this.capRadius, this.stemTop.getRelative(0, this.capYOffset, 0), true, this.capType);
                break;
            }
            case POINTY: {
                this.spawnSphericalCap(tw.getHashedRand(x, y, z).nextInt(94929297), this.capRadius, this.capRadius * 1.8f, this.stemTop.getRelative(0, this.capYOffset, 0), true, this.capType);
                break;
            }
            case FUNNEL: {
                this.spawnFunnelCap(tw.getHashedRand(x, y, z).nextInt(94929297), this.capRadius, this.capRadius * 0.7f, this.capRadius * 0.1f, this.stemTop.getRelative(0, this.capYOffset, 0), true, this.capType);
            }
        }
    }

    public void createStem(SimpleBlock base, double tilt, double yaw, double thickness, double length) {
        int totalSegments = (int)(length * (double)this.segmentFactor);
        boolean oneBlockWide = thickness == 0.0;
        Vector2f stem2d = new Vector2f((float)(length * Math.cos(1.5707963267948966 - tilt)), (float)(length * Math.sin(1.5707963267948966 - tilt)));
        Vector2f controlPoint1 = new Vector2f(this.curvatureControlPoint1.x * stem2d.x, this.curvatureControlPoint1.y * stem2d.y);
        Vector2f controlPoint2 = new Vector2f(this.curvatureControlPoint2.x * stem2d.x, this.curvatureControlPoint2.y * stem2d.y);
        BezierCurve curvature = new BezierCurve(new Vector2f(0.0f, 0.0f), controlPoint1, controlPoint2, stem2d);
        BezierCurve thicknessIncrementCurve = new BezierCurve(this.thicknessControlPoint1, this.thicknessControlPoint2);
        ArrayList<Integer> changedYs = new ArrayList<Integer>();
        SimpleBlock lastSegment = null;
        for (int i = 0; i <= totalSegments; ++i) {
            float progress = (float)i / (float)totalSegments;
            Vector2f nextPos = curvature.calculate(progress);
            Vector stem3d = new Vector((double)nextPos.x * Math.sin(yaw), (double)nextPos.y, (double)nextPos.x * Math.cos(yaw));
            lastSegment = base.getRelative(stem3d);
            if (changedYs.contains(lastSegment.getY()) && oneBlockWide) continue;
            this.replaceSphere((float)(thickness / 2.0 + this.thicknessIncrement * (double)thicknessIncrementCurve.calculate((float)(1.0f - progress)).y), lastSegment, this.stemType);
            changedYs.add(lastSegment.getY());
        }
        this.stemTop = lastSegment;
    }

    private void spawnFunnelCap(int seed, float r, float height, float thickness, SimpleBlock base, boolean hardReplace, Material ... type) {
        Random rand = new Random(seed);
        this.noiseGen.SetNoiseType(FastNoise.NoiseType.Simplex);
        this.noiseGen.SetFrequency(1.4f);
        for (int x = Math.round(-r); x <= Math.round(r); ++x) {
            for (int y = 0; y <= Math.round(3.0f * thickness); ++y) {
                for (int z = Math.round(-r); z <= Math.round(r); ++z) {
                    if (this.stemTop.getRelative(0, y, 0).getType() == this.stemType) {
                        this.stemTop.getRelative(0, y, 0).setType(GenUtils.randMaterial(rand, type));
                    }
                    double distToCenter = Math.sqrt(x * x + z * z) / (double)r;
                    double realY = (double)y + (double)height * (Math.pow(distToCenter + 0.02, 0.5) - Math.pow(distToCenter - 0.15, 8.0));
                    SimpleBlock rel = base.getRelative(x, (int)Math.round(realY += (double)(thickness * Math.abs(this.noiseGen.GetNoise((float)x / r, (float)z / r)))), z);
                    double equationResult = Math.pow((float)x / r, 2.0) + Math.pow((double)Math.abs(y) / ((double)thickness / (1.0 - Math.pow(1.0 - (distToCenter + 0.1), 6.0))), 4.0) + Math.pow((float)z / r, 2.0);
                    if (!(equationResult <= 1.0) || !hardReplace && rel.getType().isSolid()) continue;
                    rel.setType(GenUtils.randMaterial(rand, type));
                    BlockUtils.correctSurroundingMushroomData(rel);
                }
            }
        }
        double angle = Math.random() * Math.PI * 2.0;
        int heightLimit = base.getY() + Math.round(height);
        int gillAmount = 16;
        for (int i = 0; i < gillAmount; ++i) {
            List<Vector2f> points = new BresenhamLine(new Vector2f(0.0f, 0.0f), new Vector2f((float)(0.9 * (double)r * Math.cos(angle += Math.PI / ((double)gillAmount / 2.0))), (float)(0.9 * (double)r * Math.sin(angle)))).getPoints();
            block4: for (Vector2f point : points) {
                SimpleBlock pointBase = base.getRelative(Math.round(point.x), 0, Math.round(point.y));
                do {
                    if (!pointBase.getType().isSolid()) continue;
                    if (!BlockUtils.isAir(pointBase.getRelative(0, -1, 0).getType())) continue block4;
                    pointBase.getRelative(0, -1, 0).setType(Material.MUSHROOM_STEM);
                    continue block4;
                } while ((pointBase = pointBase.getRelative(0, 1, 0)).getY() <= heightLimit);
            }
        }
    }

    public MushroomBuilder setBaseThickness(float baseThickness) {
        this.baseThickness = baseThickness;
        return this;
    }

    public MushroomBuilder setBaseHeight(int h2) {
        this.baseHeight = h2;
        return this;
    }

    public MushroomBuilder setStemType(Material stemType) {
        this.stemType = stemType;
        return this;
    }

    public MushroomBuilder setCapType(Material capType) {
        this.capType = capType;
        return this;
    }

    public MushroomBuilder setSpotType(Material spotType) {
        this.spotType = spotType;
        return this;
    }

    public MushroomBuilder setMinTilt(double minTilt) {
        this.minTilt = minTilt;
        return this;
    }

    public MushroomBuilder setMaxTilt(double maxTilt) {
        this.maxTilt = maxTilt;
        return this;
    }

    public MushroomBuilder setCapRadius(float capRadius) {
        this.capRadius = capRadius;
        return this;
    }

    public MushroomBuilder setCapYOffset(int capYOffset) {
        this.capYOffset = capYOffset;
        return this;
    }

    public MushroomBuilder setSegmentFactor(float segmentFactor) {
        this.segmentFactor = segmentFactor;
        return this;
    }

    public MushroomBuilder setStemCurve(Vector2f controlPoint1, Vector2f controlPoint2) {
        this.curvatureControlPoint1 = controlPoint1;
        this.curvatureControlPoint2 = controlPoint2;
        return this;
    }

    public MushroomBuilder setStemCurve(float controlP1x, float controlP1y, float controlP2x, float controlP2y) {
        return this.setStemCurve(new Vector2f(controlP1x, controlP1y), new Vector2f(controlP2x, controlP2y));
    }

    public MushroomBuilder setThicknessIncrement(double thicknessIncrement) {
        this.thicknessIncrement = thicknessIncrement;
        return this;
    }

    public MushroomBuilder setThicknessIncrementCurve(Vector2f controlPoint1, Vector2f controlPoint2) {
        this.thicknessControlPoint1 = controlPoint1;
        this.thicknessControlPoint2 = controlPoint2;
        return this;
    }

    public MushroomBuilder setThicknessIncrementCurve(float controlP1x, float controlP1y, float controlP2x, float controlP2y) {
        return this.setThicknessIncrementCurve(new Vector2f(controlP1x, controlP1y), new Vector2f(controlP2x, controlP2y));
    }

    public MushroomBuilder setCapShape(FractalTypes.MushroomCap capShape) {
        this.capShape = capShape;
        return this;
    }

    public MushroomBuilder setFourAxisRotationOnly(boolean fourAxisRotationOnly) {
        this.fourAxisRotationOnly = fourAxisRotationOnly;
        return this;
    }
}

