/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.tree;

import java.util.Objects;
import org.bukkit.Material;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.tree.FractalLeaves;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.NewFractalTreeBuilder;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class FractalTypes {

    public static enum MushroomCap {
        ROUND,
        FLAT,
        FUNNEL,
        POINTY;

        public static final MushroomCap[] VALUES;

        static {
            VALUES = MushroomCap.values();
        }
    }

    public static enum Mushroom {
        TINY_BROWN_MUSHROOM,
        TINY_RED_MUSHROOM,
        SMALL_RED_MUSHROOM,
        SMALL_POINTY_RED_MUSHROOM,
        SMALL_BROWN_MUSHROOM,
        MEDIUM_BROWN_MUSHROOM,
        MEDIUM_RED_MUSHROOM,
        MEDIUM_BROWN_FUNNEL_MUSHROOM,
        GIANT_BROWN_MUSHROOM,
        GIANT_BROWN_FUNNEL_MUSHROOM,
        GIANT_RED_MUSHROOM;

        public static final Mushroom[] VALUES;

        static {
            VALUES = Mushroom.values();
        }
    }

    public static enum Tree {
        FOREST,
        NORMAL_SMALL(new NewFractalTreeBuilder().setTreeRootThreshold(1).setOriginalTrunkLength(6).setLengthVariance(1.0f).setMaxDepth(1).setCrownBranches(3).setInitialBranchRadius(0.8f).setNoisePriority(0.05f).setFirstEnd(1.0f).setMinBranchHorizontalComponent(1.2).setMaxBranchHorizontalComponent(2.0).setMaxInitialNormalDelta(0.0).setMinInitialNormalDelta(0.0f).setGetBranchWidth((initialBranchWidth, branchRatio) -> Float.valueOf(initialBranchWidth.floatValue() - branchRatio.floatValue() * 0.2f)).setBranchDecrement((currentBranchLength, totalTreeHeight) -> Float.valueOf(currentBranchLength.floatValue() - 2.0f)).setMinBranchSpawnLength(0.8f).setBranchSpawnChance(0.1).setFractalLeaves(new FractalLeaves().setWeepingLeaves(0.3f, 1).setRadius(3.0f).setRadiusY(1.5f).setLeafNoiseFrequency(0.2f).setMaterial(Material.OAK_LEAVES))),
        AZALEA_TOP(new NewFractalTreeBuilder().setTreeRootThreshold(1).setOriginalTrunkLength(6).setLengthVariance(1.0f).setMaxDepth(1).setCrownBranches(3).setInitialBranchRadius(0.8f).setNoisePriority(0.05f).setFirstEnd(1.0f).setMinBranchHorizontalComponent(1.2).setMaxBranchHorizontalComponent(2.0).setMaxInitialNormalDelta(0.0).setMinInitialNormalDelta(0.0f).setGetBranchWidth((initialBranchWidth, branchRatio) -> Float.valueOf(initialBranchWidth.floatValue() - branchRatio.floatValue() * 0.2f)).setBranchDecrement((currentBranchLength, totalTreeHeight) -> Float.valueOf(currentBranchLength.floatValue() - 2.0f)).setMinBranchSpawnLength(0.8f).setBranchSpawnChance(0.1).setFractalLeaves(new FractalLeaves().setWeepingLeaves(0.5f, 2).setRadius(4.0f).setRadiusY(1.5f).setLeafNoiseFrequency(0.2f).setMaterial(OneOneSevenBlockHandler.AZALEA_LEAVES, OneOneSevenBlockHandler.FLOWERING_AZALEA_LEAVES))),
        TAIGA_BIG,
        TAIGA_SMALL,
        SCARLET_BIG,
        SCARLET_SMALL,
        SAVANNA_SMALL,
        SAVANNA_BIG,
        WASTELAND_BIG,
        SWAMP_TOP,
        SWAMP_BOTTOM,
        BIRCH_BIG,
        BIRCH_SMALL,
        CHERRY_SMALL,
        CHERRY_THICK,
        JUNGLE_BIG,
        JUNGLE_SMALL,
        JUNGLE_EXTRA_SMALL,
        COCONUT_TOP,
        DARK_OAK_SMALL,
        DARK_OAK_BIG_TOP,
        DARK_OAK_BIG_BOTTOM,
        FROZEN_TREE_BIG,
        FROZEN_TREE_SMALL,
        FIRE_CORAL,
        HORN_CORAL,
        BRAIN_CORAL,
        TUBE_CORAL,
        BUBBLE_CORAL,
        GIANT_PUMPKIN,
        ANDESITE_PETRIFIED_SMALL,
        GRANITE_PETRIFIED_SMALL,
        DIORITE_PETRIFIED_SMALL;

        private final NewFractalTreeBuilder[] builders;
        public static final Tree[] VALUES;

        private Tree() {
            this.builders = new NewFractalTreeBuilder[0];
        }

        private Tree(NewFractalTreeBuilder ... builder) {
            this.builders = builder;
        }

        public void build(TerraformWorld tw, SimpleBlock base) {
            if (this.builders.length > 0) {
                Objects.requireNonNull(GenUtils.choice(tw.getHashedRand(base.getX(), base.getY(), base.getZ()), this.builders)).build(tw, base);
            } else {
                new FractalTreeBuilder(this).build(tw, base);
            }
        }

        static {
            VALUES = Tree.values();
        }
    }
}

