/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.tree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Leaves;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;
import org.terraform.utils.version.OneOneNineBlockHandler;
import org.terraform.utils.version.Version;

public class FractalLeaves {
    int oriY;
    int maxHeight;
    TerraformWorld tw;
    public float radiusX = 4.0f;
    public float radiusY = 2.0f;
    public int numYSegments = 5;
    public float radiusZ = 4.0f;
    public int offsetY = 0;
    public Material[] material = new Material[]{Material.OAK_LEAVES};
    BiFunction<FractalLeaves, Float, Float> getNextRadius = (fractalLeaves, radiusIndex) -> Float.valueOf((float)((double)this.radiusX * Math.sin((double)radiusIndex.floatValue() * (Math.PI / (double)this.numYSegments))));
    Random rand = new Random();
    float leafNoiseMultiplier = 0.7f;
    float leafNoiseFrequency = 0.09f;
    double hollowLeaves = 0.0;
    boolean coneLeaves = false;
    boolean snowy = false;
    float weepingLeavesChance = 0.0f;
    int weepingLeavesLength = 0;
    boolean coralDecoration = false;
    boolean mangrovePropagules = false;
    int unitLeafSize = 0;
    float unitLeafChance = 0.0f;
    private final HashSet<SimpleBlock> occupiedLeaves = new HashSet();

    public void purgeOccupiedLeavesCache() {
        this.occupiedLeaves.clone();
    }

    public void placeLeaves(SimpleBlock centre) {
        this.placeLeaves(centre.getPopData().getTerraformWorld(), -999, 999, centre);
    }

    public void placeLeaves(TerraformWorld tw, int oriY, int maxHeight, SimpleBlock centre) {
        this.tw = tw;
        this.oriY = oriY;
        this.maxHeight = maxHeight;
        FastNoise noiseGen = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.FRACTALTREES_LEAVES_NOISE, world -> {
            FastNoise n = new FastNoise((int)world.getSeed());
            n.SetFractalOctaves(5);
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            return n;
        });
        noiseGen.SetFrequency(this.leafNoiseFrequency);
        if (this.radiusX <= 0.0f && this.radiusY <= 0.0f && this.radiusZ <= 0.0f) {
            return;
        }
        if ((double)this.radiusX <= 0.5 && (double)this.radiusY <= 0.5 && (double)this.radiusZ <= 0.5) {
            centre.setType(this.material);
            return;
        }
        float noiseMultiplier = this.leafNoiseMultiplier;
        double maxR = this.radiusX;
        if (this.radiusX < this.radiusY) {
            maxR = this.radiusY;
        }
        if (this.radiusY < this.radiusZ) {
            maxR = this.radiusZ;
        }
        ArrayList<SimpleBlock> changed = new ArrayList<SimpleBlock>();
        int y = -Math.round(this.radiusY);
        while ((float)y <= this.radiusY) {
            int x = -Math.round(this.radiusX);
            while ((float)x <= this.radiusX) {
                int z = -Math.round(this.radiusZ);
                while ((float)z <= this.radiusZ) {
                    double equationResult;
                    Material material = this.material[this.rand.nextInt(this.material.length)];
                    SimpleBlock relativeBlock = centre.getRelative(Math.round(x), Math.round(y) + this.offsetY, Math.round(z));
                    if (relativeBlock.getY() - oriY > maxHeight) {
                        return;
                    }
                    if (relativeBlock.getY() - oriY == maxHeight && this.rand.nextBoolean()) {
                        return;
                    }
                    float effectiveY = y;
                    if (this.coneLeaves) {
                        if ((effectiveY += this.radiusY / 2.0f) < 0.0f) {
                            effectiveY *= 2.0f;
                        }
                        if (effectiveY > 0.0f) {
                            effectiveY *= 0.6666667f;
                            if ((effectiveY = (float)Math.pow(effectiveY, 1.3)) > this.radiusY) {
                                effectiveY = this.radiusY;
                            }
                        }
                        relativeBlock = relativeBlock.getRelative(0, (int)(this.radiusY / 2.0f), 0);
                    }
                    if (!this.occupiedLeaves.contains(relativeBlock) && (equationResult = Math.pow(x, 2.0) / Math.pow(this.radiusX, 2.0) + Math.pow(effectiveY, 2.0) / Math.pow(this.radiusY, 2.0) + Math.pow(z, 2.0) / Math.pow(this.radiusZ, 2.0)) <= (double)(1.0f + noiseMultiplier * noiseGen.GetNoise(relativeBlock.getX(), relativeBlock.getY(), relativeBlock.getZ())) && !(equationResult < this.hollowLeaves)) {
                        this.occupiedLeaves.add(relativeBlock);
                        if (this.mangrovePropagules && Version.isAtLeast(19.0) && !BlockUtils.isWet(relativeBlock.getDown()) && GenUtils.chance(1, 50)) {
                            relativeBlock.getDown().lsetBlockData(OneOneNineBlockHandler.getHangingMangrovePropagule());
                        }
                        if (Tag.CORALS.isTagged((Keyed)material) && !changed.contains(relativeBlock)) {
                            changed.add(relativeBlock);
                        }
                        if (this.coralDecoration) {
                            CoralGenerator.generateSingleCoral(relativeBlock.getPopData(), relativeBlock.getX(), relativeBlock.getY(), relativeBlock.getZ(), this.material[0].toString());
                        }
                        if (!relativeBlock.getType().isSolid()) {
                            this.unitSet(relativeBlock, material);
                            if (this.unitLeafSize > 0 && this.unitLeafChance > 0.0f && GenUtils.chance(this.rand, (int)(this.unitLeafChance * 100.0f), 100)) {
                                for (int scaleX = -this.unitLeafSize; scaleX < this.unitLeafSize; ++scaleX) {
                                    for (int scaleZ = -this.unitLeafSize; scaleZ < this.unitLeafSize; ++scaleZ) {
                                        for (int scaleY = -this.unitLeafSize; scaleY < this.unitLeafSize; ++scaleY) {
                                            this.unitSet(relativeBlock.getRelative(scaleX, scaleY, scaleZ), material);
                                        }
                                    }
                                }
                            }
                        }
                        if (this.snowy && !relativeBlock.getRelative(0, 1, 0).getType().isSolid()) {
                            relativeBlock.getRelative(0, 1, 0).setType(Material.SNOW);
                        }
                        if (this.weepingLeavesChance > 0.0f && Math.random() < (double)this.weepingLeavesChance) {
                            this.weepingLeaves(relativeBlock, Math.round(this.weepingLeavesChance * (float)this.weepingLeavesLength), this.weepingLeavesLength);
                        }
                    }
                    ++z;
                }
                ++x;
            }
            ++y;
        }
        while (!changed.isEmpty()) {
            SimpleBlock sb = (SimpleBlock)changed.remove(new Random().nextInt(changed.size()));
            if (!CoralGenerator.isSaturatedCoral(sb)) {
                for (BlockFace face : BlockUtils.directBlockFaces) {
                    if (!Tag.WALL_CORALS.isTagged((Keyed)sb.getRelative(face).getType())) continue;
                    sb.getRelative(face).setType(Material.WATER);
                }
                if (sb.getRelative(0, 1, 0).getType() == Material.SEA_PICKLE || Tag.CORAL_PLANTS.isTagged((Keyed)sb.getRelative(0, 1, 0).getType())) {
                    sb.getRelative(0, 1, 0).setType(Material.WATER);
                }
                sb.setType(Material.WATER);
                continue;
            }
            sb.setType(this.material);
        }
    }

    private void unitSet(SimpleBlock relativeBlock, Material material) {
        if (Tag.LEAVES.isTagged((Keyed)material)) {
            Leaves leaf = (Leaves)Bukkit.createBlockData((Material)material);
            leaf.setDistance(1);
            relativeBlock.lsetBlockData((BlockData)leaf);
        } else {
            relativeBlock.lsetType(material);
        }
    }

    private void weepingLeaves(SimpleBlock base, int minDist, int maxDist) {
        Material material = this.material[this.rand.nextInt(this.material.length)];
        BlockData type = Bukkit.createBlockData((Material)material);
        if (Tag.LEAVES.isTagged((Keyed)material)) {
            Leaves leaf = (Leaves)type;
            leaf.setDistance(1);
        }
        for (int i = 1; i <= GenUtils.randInt(minDist, maxDist) && BlockUtils.isAir(base.getRelative(0, -i, 0).getType()); ++i) {
            base.getRelative(0, -i, 0).lsetBlockData(type);
        }
    }

    public FractalLeaves setMaterial(Material ... material) {
        this.material = material;
        return this;
    }

    public FractalLeaves setOffsetY(int offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    public FractalLeaves setRadiusX(float radiusX) {
        this.radiusX = radiusX;
        return this;
    }

    public FractalLeaves setRadiusY(float radiusY) {
        this.radiusY = radiusY;
        this.numYSegments = (int)Math.ceil(radiusY * 2.0f + 1.0f);
        return this;
    }

    public FractalLeaves setRadiusZ(float radiusZ) {
        this.radiusZ = radiusZ;
        return this;
    }

    public FractalLeaves setRadius(float radius) {
        this.radiusX = radius;
        this.setRadiusY(radius);
        this.radiusZ = radius;
        return this;
    }

    public FractalLeaves setRadius(float x, float y, float z) {
        this.radiusX = x;
        this.setRadiusY(y);
        this.radiusZ = z;
        return this;
    }

    public FractalLeaves setHollowLeaves(double hollow) {
        this.hollowLeaves = hollow;
        return this;
    }

    public FractalLeaves setConeLeaves(boolean coneLeaves) {
        this.coneLeaves = coneLeaves;
        return this;
    }

    public FractalLeaves setLeafNoiseMultiplier(float multiplier) {
        this.leafNoiseMultiplier = multiplier;
        return this;
    }

    public FractalLeaves setLeafNoiseFrequency(float freq) {
        this.leafNoiseFrequency = freq;
        return this;
    }

    public FractalLeaves setSnowy(boolean snowy) {
        this.snowy = snowy;
        return this;
    }

    public FractalLeaves setMangrovePropagules(boolean mangrovePropagules) {
        this.mangrovePropagules = mangrovePropagules;
        return this;
    }

    public FractalLeaves setWeepingLeaves(float chance, int maxLength) {
        this.weepingLeavesChance = chance;
        this.weepingLeavesLength = maxLength;
        return this;
    }

    public FractalLeaves setUnitLeafChance(float unitLeafChance) {
        this.unitLeafChance = unitLeafChance;
        return this;
    }

    public FractalLeaves setUnitLeafSize(int unitSize) {
        this.unitLeafSize = unitSize;
        return this;
    }

    public int getOriY() {
        return this.oriY;
    }

    public void setOriY(int oriY) {
        this.oriY = oriY;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public TerraformWorld getTw() {
        return this.tw;
    }

    public void setTw(TerraformWorld tw) {
        this.tw = tw;
    }
}

