/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.villagehouse.animalfarm;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.schematic.SchematicParser;
import org.terraform.utils.GenUtils;
import org.terraform.utils.WoodUtils;

public class AnimalFarmSchematicParser
extends SchematicParser {
    private final BiomeBank biome;
    private final Random rand;
    private final PopulatorDataAbstract pop;

    public AnimalFarmSchematicParser(BiomeBank biome, Random rand, PopulatorDataAbstract pop) {
        this.biome = biome;
        this.rand = rand;
        this.pop = pop;
    }

    @Override
    public void applyData(SimpleBlock block, BlockData data) {
        if (data.getMaterial() == Material.COBBLESTONE && GenUtils.chance(this.rand, 1, 5)) {
            data = Bukkit.createBlockData((Material)Material.STONE);
        }
        if (data.getMaterial().toString().contains("COBBLESTONE")) {
            data = Bukkit.createBlockData((String)data.getAsString().replaceAll("cobblestone", GenUtils.randMaterial(this.rand, Material.COBBLESTONE, Material.COBBLESTONE, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE).toString().toLowerCase()));
            super.applyData(block, data);
            return;
        }
        if (data.getMaterial().toString().contains("STONE_BRICK")) {
            if (GenUtils.chance(this.rand, 1, 5)) {
                data = Bukkit.createBlockData((String)data.getAsString().replaceAll("stone_brick", "mossy_stone_brick"));
            }
            super.applyData(block, data);
            return;
        }
        if (data.getMaterial().toString().contains("OAK")) {
            data = Bukkit.createBlockData((String)data.getAsString().replaceAll(data.getMaterial().toString().toLowerCase(), WoodUtils.getWoodForBiome(this.biome, WoodUtils.WoodType.parse(data.getMaterial())).toString().toLowerCase()).toString().toLowerCase());
            super.applyData(block, data);
            return;
        }
        if (data.getMaterial() == Material.CHEST) {
            if (GenUtils.chance(this.rand, 1, 5)) {
                block.setType(Material.AIR);
                return;
            }
            super.applyData(block, data);
            int i = this.rand.nextInt(3);
            if (i == 0) {
                this.pop.lootTableChest(block.getX(), block.getY(), block.getZ(), TerraLootTable.VILLAGE_BUTCHER);
            } else if (i == 1) {
                this.pop.lootTableChest(block.getX(), block.getY(), block.getZ(), TerraLootTable.VILLAGE_TANNERY);
            } else if (i == 2) {
                this.pop.lootTableChest(block.getX(), block.getY(), block.getZ(), TerraLootTable.VILLAGE_SHEPHERD);
            }
            return;
        }
        super.applyData(block, data);
    }
}

