/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.villagehouse.animalfarm;

import java.util.Random;
import org.bukkit.Material;
import org.terraform.data.Wall;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.PathPopulatorAbstract;
import org.terraform.structure.room.PathPopulatorData;
import org.terraform.structure.room.RoomLayoutGenerator;
import org.terraform.utils.GenUtils;

public class AnimalFarmPathPopulator
extends PathPopulatorAbstract {
    private final Random rand;
    private final RoomLayoutGenerator gen;

    public AnimalFarmPathPopulator(RoomLayoutGenerator gen, Random rand) {
        this.gen = gen;
        this.rand = rand;
    }

    @Override
    public void populate(PathPopulatorData ppd) {
        Wall w = new Wall(ppd.base, ppd.dir);
        for (CubeRoom room : this.gen.getRooms()) {
            if (!room.isPointInside(new int[]{w.get().getX(), w.get().getZ()})) continue;
            return;
        }
        if (GenUtils.chance(this.rand, 1, 50)) {
            w.getLeft().getGround().getRelative(0, 1, 0).setType(Material.CAMPFIRE);
        }
        if (GenUtils.chance(this.rand, 2, 10)) {
            w.getGround().setType(GenUtils.randMaterial(Material.COBBLESTONE, Material.COARSE_DIRT, Material.MOSSY_COBBLESTONE));
        }
        if (GenUtils.chance(this.rand, 2, 10)) {
            w.getLeft().getGround().setType(GenUtils.randMaterial(Material.COBBLESTONE, Material.COARSE_DIRT, Material.MOSSY_COBBLESTONE));
        }
        if (GenUtils.chance(this.rand, 2, 10)) {
            w.getRight().getGround().setType(GenUtils.randMaterial(Material.COBBLESTONE, Material.COARSE_DIRT, Material.MOSSY_COBBLESTONE));
        }
    }
}

