/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains.temple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Lantern;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.jigsaw.JigsawStructurePiece;
import org.terraform.structure.village.plains.PlainsVillagePopulator;
import org.terraform.structure.village.plains.temple.PlainsVillageTempleJigsawBuilder;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.blockdata.DirectionalBuilder;
import org.terraform.utils.blockdata.OrientableBuilder;
import org.terraform.utils.blockdata.StairBuilder;

public class PlainsVillageTempleRoofHandler {
    public static void handleTempleRoof(PlainsVillagePopulator plainsVillagePopulator, PopulatorDataAbstract data, JigsawStructurePiece piece, ArrayList<JigsawStructurePiece> wallPieces) {
        Wall base = new Wall(new SimpleBlock(data, piece.getRoom().getX(), piece.getRoom().getY() + 5, piece.getRoom().getZ()), piece.getRotation());
        for (BlockFace face : BlockUtils.getAdjacentFaces(piece.getRotation())) {
            int multiplier = 0;
            multiplier = PlainsVillageTempleJigsawBuilder.hasAdjacentWall(piece, face, wallPieces) ? 0 : (PlainsVillageTempleJigsawBuilder.hasAdjacentInwardWall(piece, face, wallPieces) ? 1 : -1);
            for (int height = 0; height < 3; ++height) {
                for (int horDepth = 0; horDepth < 3 + height * multiplier; ++horDepth) {
                    Wall w = base.getRelative(face, horDepth);
                    new StairBuilder(Material.COBBLESTONE_STAIRS).setFacing(w.getDirection().getOppositeFace()).apply(w.getRear(height + 2).getRelative(0, height * 2, 0)).correct();
                    if (multiplier == -1 && horDepth == 2 + height * multiplier) {
                        pillar = w.getRelative(face).getRear(height + 2).getRelative(0, height * 2, 0);
                        pillar.Pillar(3, new Random(), Material.COBBLESTONE_WALL, Material.COBBLESTONE_WALL, Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL);
                        pillar.setType(Material.CHISELED_STONE_BRICKS);
                        pillar = w.getRear(height + 3).getRelative(0, (height + 1) * 2, 0);
                        pillar.getRelative(0, -2, 0).setType(plainsVillagePopulator.woodLog);
                        l = (Lantern)Bukkit.createBlockData((Material)Material.LANTERN);
                        l.setHanging(true);
                        pillar.getRelative(0, -3, 0).setBlockData((BlockData)l);
                    } else if (multiplier == 1 && horDepth == 2 + height * multiplier) {
                        pillar = w.getRelative(face, 1).getRear(height + 3).getRelative(0, (height + 1) * 2, 0);
                        pillar.getRelative(0, -1, 0).get().lsetType(plainsVillagePopulator.woodLog);
                        pillar.getRelative(0, -2, 0).setType(plainsVillagePopulator.woodLog);
                        l = (Lantern)Bukkit.createBlockData((Material)Material.LANTERN);
                        l.setHanging(true);
                        pillar.getRelative(0, -3, 0).setBlockData((BlockData)l);
                    }
                    if (height != 2) {
                        new StairBuilder(Material.STONE_BRICK_STAIRS).setFacing(w.getDirection()).setHalf(Bisected.Half.TOP).lapply(w.getRear(height + 3).getRelative(0, height * 2, 0)).correct();
                    } else {
                        new OrientableBuilder(plainsVillagePopulator.woodLog).setAxis(BlockUtils.getAxisFromBlockFace(face)).lapply(w.getRear(height + 3).getRelative(0, height * 2, 0));
                    }
                    w.getRelative(0, height * 2 + 1, 0).getRear(height + 3).setType(Material.POLISHED_ANDESITE);
                }
            }
        }
    }

    public static void placeCeilingTerracotta(PopulatorDataAbstract data, Collection<JigsawStructurePiece> structurePieces) {
        Material glazedTerracotta = BlockUtils.GLAZED_TERRACOTTA[new Random().nextInt(BlockUtils.GLAZED_TERRACOTTA.length)];
        for (JigsawStructurePiece piece : structurePieces) {
            int[] lowerCorner = piece.getRoom().getLowerCorner();
            int[] upperCorner = piece.getRoom().getUpperCorner();
            for (int x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
                for (int z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                    SimpleBlock b = new SimpleBlock(data, x, piece.getRoom().getY() + 1, z);
                    int i = 0;
                    for (i = 0; i < 9 && !b.getType().isSolid(); ++i) {
                        b = b.getRelative(0, 1, 0);
                    }
                    if (i != 9 || b.getType().isSolid()) continue;
                    PlainsVillageTempleRoofHandler.placeGlazedTerracotta(b, glazedTerracotta);
                    b.getRelative(0, 1, 0).setType(Material.POLISHED_ANDESITE);
                }
            }
        }
    }

    private static void placeGlazedTerracotta(SimpleBlock target, Material glazedTerracotta) {
        BlockFace dir = BlockFace.NORTH;
        dir = target.getX() % 2 == 0 ? (target.getZ() % 2 == 0 ? BlockFace.SOUTH : BlockFace.WEST) : (target.getZ() % 2 == 0 ? BlockFace.EAST : BlockFace.NORTH);
        new DirectionalBuilder(glazedTerracotta).setFacing(dir).apply(target);
    }
}

