/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains.temple;

import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.jigsaw.JigsawBuilder;
import org.terraform.structure.room.jigsaw.JigsawStructurePiece;
import org.terraform.structure.room.jigsaw.JigsawType;
import org.terraform.structure.village.plains.PlainsVillagePopulator;
import org.terraform.structure.village.plains.temple.PlainsVillageTempleClericAltarPiece;
import org.terraform.structure.village.plains.temple.PlainsVillageTempleEntrancePiece;
import org.terraform.structure.village.plains.temple.PlainsVillageTempleLootPiece;
import org.terraform.structure.village.plains.temple.PlainsVillageTempleLoungePiece;
import org.terraform.structure.village.plains.temple.PlainsVillageTempleRelicPiece;
import org.terraform.structure.village.plains.temple.PlainsVillageTempleRoofHandler;
import org.terraform.structure.village.plains.temple.PlainsVillageTempleStandardPiece;
import org.terraform.structure.village.plains.temple.PlainsVillageTempleWallPiece;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.blockdata.StairBuilder;

public class PlainsVillageTempleJigsawBuilder
extends JigsawBuilder {
    PlainsVillagePopulator plainsVillagePopulator;

    public PlainsVillageTempleJigsawBuilder(PlainsVillagePopulator plainsVillagePopulator, int widthX, int widthZ, PopulatorDataAbstract data, int x, int y, int z) {
        super(widthX, widthZ, data, x, y, z);
        this.plainsVillagePopulator = plainsVillagePopulator;
        this.pieceRegistry = new JigsawStructurePiece[]{new PlainsVillageTempleLoungePiece(plainsVillagePopulator, 5, 3, 5, JigsawType.STANDARD, BlockUtils.directBlockFaces), new PlainsVillageTempleRelicPiece(plainsVillagePopulator, 5, 3, 5, JigsawType.STANDARD, true, BlockUtils.directBlockFaces), new PlainsVillageTempleLootPiece(plainsVillagePopulator, 5, 3, 5, JigsawType.STANDARD, BlockUtils.directBlockFaces), new PlainsVillageTempleWallPiece(5, 3, 5, JigsawType.END, BlockUtils.directBlockFaces), new PlainsVillageTempleEntrancePiece(plainsVillagePopulator, 5, 3, 5, JigsawType.ENTRANCE, BlockUtils.directBlockFaces)};
        this.chanceToAddNewPiece = 50;
    }

    @Override
    public JigsawStructurePiece getFirstPiece(Random random) {
        return new PlainsVillageTempleClericAltarPiece(this.plainsVillagePopulator, 5, 3, 5, JigsawType.STANDARD, true, this, BlockUtils.directBlockFaces);
    }

    @Override
    public void build(Random random) {
        super.build(random);
        for (JigsawStructurePiece piece : this.pieces.values()) {
            Wall target;
            SimpleBlock core = new SimpleBlock(this.core.getPopData(), piece.getRoom().getX(), piece.getRoom().getY(), piece.getRoom().getZ());
            if (piece.getWalledFaces().contains(BlockFace.NORTH) && piece.getWalledFaces().contains(BlockFace.WEST)) {
                target = new Wall(core.getRelative(-3, 0, -3));
                this.decorateAwkwardCorner(target, random, BlockFace.NORTH, BlockFace.WEST);
            }
            if (piece.getWalledFaces().contains(BlockFace.NORTH) && piece.getWalledFaces().contains(BlockFace.EAST)) {
                target = new Wall(core.getRelative(3, 0, -3));
                this.decorateAwkwardCorner(target, random, BlockFace.NORTH, BlockFace.EAST);
            }
            if (piece.getWalledFaces().contains(BlockFace.SOUTH) && piece.getWalledFaces().contains(BlockFace.WEST)) {
                target = new Wall(core.getRelative(-3, 0, 3));
                this.decorateAwkwardCorner(target, random, BlockFace.SOUTH, BlockFace.WEST);
            }
            if (!piece.getWalledFaces().contains(BlockFace.SOUTH) || !piece.getWalledFaces().contains(BlockFace.EAST)) continue;
            target = new Wall(core.getRelative(3, 0, 3));
            this.decorateAwkwardCorner(target, random, BlockFace.SOUTH, BlockFace.EAST);
        }
        int randIndex = random.nextInt(this.pieces.size());
        int i = 0;
        for (JigsawStructurePiece p : this.pieces.values()) {
            if (i != randIndex) continue;
            ((PlainsVillageTempleStandardPiece)p).setTower(true);
        }
        for (JigsawStructurePiece piece : this.overlapperPieces) {
            PlainsVillageTempleRoofHandler.handleTempleRoof(this.plainsVillagePopulator, this.core.getPopData(), piece, this.overlapperPieces);
        }
        for (JigsawStructurePiece wallPiece : this.overlapperPieces) {
            for (BlockFace face : BlockUtils.getAdjacentFaces(wallPiece.getRotation())) {
                if (!PlainsVillageTempleJigsawBuilder.hasAdjacentWall(wallPiece, face, this.overlapperPieces)) continue;
                PlainsVillageTempleWallPiece.setLargeWindow(this.core.getPopData(), wallPiece.getRotation(), wallPiece.getRoom(), face);
            }
        }
        PlainsVillageTempleRoofHandler.placeCeilingTerracotta(this.core.getPopData(), this.pieces.values());
        for (JigsawStructurePiece piece : this.pieces.values()) {
            piece.postBuildDecoration(random, this.core.getPopData());
        }
    }

    protected static boolean hasAdjacentWall(JigsawStructurePiece piece, BlockFace face, ArrayList<JigsawStructurePiece> overlapperPieces) {
        for (JigsawStructurePiece other : overlapperPieces) {
            if (!other.getRoom().getSimpleLocation().equals(piece.getRoom().getSimpleLocation().getRelative(face, 5)) || other.getRotation() != piece.getRotation()) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasAdjacentInwardWall(JigsawStructurePiece piece, BlockFace face, ArrayList<JigsawStructurePiece> overlapperPieces) {
        for (JigsawStructurePiece other : overlapperPieces) {
            if (!other.getRoom().getSimpleLocation().equals(piece.getRoom().getSimpleLocation()) || other.getRotation() != face.getOppositeFace()) continue;
            return true;
        }
        return false;
    }

    public void decorateAwkwardCorner(Wall target, Random random, BlockFace one, BlockFace two) {
        Material[] cobblestone = new Material[]{Material.COBBLESTONE, Material.MOSSY_COBBLESTONE};
        Material[] stoneBricks = new Material[]{Material.STONE_BRICKS, Material.STONE_BRICKS, Material.STONE_BRICKS, Material.CRACKED_STONE_BRICKS};
        target.Pillar(5, random, BlockUtils.stoneBricks);
        target.getRelative(0, -1, 0).downUntilSolid(random, cobblestone);
        target = target.getRelative(0, 1, 0);
        target.getRelative(one).Pillar(3, random, stoneBricks);
        new StairBuilder(Material.STONE_BRICK_STAIRS).setFacing(one.getOppositeFace()).apply(target.getRelative(one).getRelative(0, 3, 0));
        target.getRelative(two).Pillar(3, random, stoneBricks);
        new StairBuilder(Material.STONE_BRICK_STAIRS).setFacing(two.getOppositeFace()).apply(target.getRelative(two).getRelative(0, 3, 0));
        target = target.getRelative(0, -1, 0);
        target.getRelative(one).downUntilSolid(random, cobblestone);
        target.getRelative(two).downUntilSolid(random, cobblestone);
    }
}

