/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains.house;

import java.util.AbstractMap;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Ladder;
import org.bukkit.block.data.type.Slab;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.jigsaw.JigsawType;
import org.terraform.structure.village.plains.PlainsVillagePopulator;
import org.terraform.structure.village.plains.house.PlainsVillageHouseVariant;
import org.terraform.structure.village.plains.house.PlainsVillageStandardPiece;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.DirectionalBuilder;
import org.terraform.utils.blockdata.SlabBuilder;
import org.terraform.utils.blockdata.StairBuilder;

public class PlainsVillageLibraryPiece
extends PlainsVillageStandardPiece {
    public PlainsVillageLibraryPiece(PlainsVillagePopulator plainsVillagePopulator, PlainsVillageHouseVariant variant, int widthX, int height, int widthZ, JigsawType type, BlockFace[] validDirs) {
        super(plainsVillagePopulator, variant, widthX, height, widthZ, type, validDirs);
    }

    @Override
    public void postBuildDecoration(Random random, PopulatorDataAbstract data) {
        super.postBuildDecoration(random, data);
        SimpleBlock core = new SimpleBlock(data, this.getRoom().getX(), this.getRoom().getY() + 1, this.getRoom().getZ());
        new DirectionalBuilder(Material.LECTERN).setFacing(BlockUtils.getDirectBlockFace(random)).apply(core);
        for (BlockFace face : this.getWalledFaces()) {
            AbstractMap.SimpleEntry<Wall, Integer> entry = this.getRoom().getWall(data, face, 0);
            Wall w = entry.getKey();
            for (int i = 0; i < entry.getValue(); ++i) {
                if (i == 0 || i == 4) {
                    w.LPillar(25, random, Material.BOOKSHELF);
                    if (GenUtils.chance(random, 1, 10)) {
                        Ladder ladder = (Ladder)Bukkit.createBlockData((Material)Material.LADDER);
                        ladder.setFacing(w.getDirection());
                        for (int h2 = 0; h2 < 25 && !w.getFront().getRelative(0, h2, 0).getType().isSolid(); ++h2) {
                            w.getFront().getRelative(0, h2, 0).setBlockData((BlockData)ladder);
                        }
                    }
                } else if (i == 1 || i == 3) {
                    new StairBuilder(this.plainsVillagePopulator.woodStairs).setFacing(w.getDirection().getOppositeFace()).apply(w);
                    new StairBuilder(Material.STONE_BRICK_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS).setFacing(w.getDirection().getOppositeFace()).setHalf(Bisected.Half.TOP).apply(w.getRelative(0, 2, 0));
                    w.getRelative(0, 3, 0).LPillar(25, random, Material.BOOKSHELF);
                } else {
                    if (w.getRear().getType() != this.plainsVillagePopulator.woodDoor) {
                        new SlabBuilder(this.plainsVillagePopulator.woodSlab).apply(w);
                    }
                    new SlabBuilder(Material.STONE_BRICK_SLAB, Material.MOSSY_STONE_BRICK_SLAB).setType(Slab.Type.TOP).apply(w.getRelative(0, 2, 0));
                    w.getRelative(0, 3, 0).LPillar(25, random, Material.BOOKSHELF);
                }
                w = w.getLeft();
            }
        }
    }
}

