/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains.house;

import java.util.AbstractMap;
import java.util.Random;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Slab;
import org.bukkit.entity.EntityType;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.jigsaw.JigsawType;
import org.terraform.structure.village.plains.PlainsVillagePopulator;
import org.terraform.structure.village.plains.house.PlainsVillageHouseVariant;
import org.terraform.structure.village.plains.house.PlainsVillageStandardPiece;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.ChestBuilder;
import org.terraform.utils.blockdata.SlabBuilder;
import org.terraform.utils.blockdata.StairBuilder;

public class PlainsVillageBedroomPiece
extends PlainsVillageStandardPiece {
    public PlainsVillageBedroomPiece(PlainsVillagePopulator plainsVillagePopulator, PlainsVillageHouseVariant variant, int widthX, int height, int widthZ, JigsawType type, BlockFace[] validDirs) {
        super(plainsVillagePopulator, variant, widthX, height, widthZ, type, validDirs);
    }

    @Override
    public void build(PopulatorDataAbstract data, Random rand) {
        super.build(data, rand);
    }

    @Override
    public void postBuildDecoration(Random random, PopulatorDataAbstract data) {
        super.postBuildDecoration(random, data);
        if (this.getWalledFaces().size() == 0) {
            SimpleBlock core = new SimpleBlock(data, this.getRoom().getX(), this.getRoom().getY() + 1, this.getRoom().getZ());
            core.setType(Material.SMOOTH_STONE);
            for (BlockFace face : BlockUtils.xzPlaneBlockFaces) {
                new SlabBuilder(Material.SMOOTH_STONE_SLAB).setType(Slab.Type.TOP).apply(core.getRelative(face));
            }
            for (BlockFace face : BlockUtils.directBlockFaces) {
                new StairBuilder(Material.POLISHED_ANDESITE_STAIRS).setFacing(face).apply(core.getRelative(face, 2));
            }
            core.getRelative(0, 1, 0).setType(BlockUtils.pickPottedPlant());
            return;
        }
        int placedBeds = 0;
        for (BlockFace face : this.getWalledFaces()) {
            int i;
            AbstractMap.SimpleEntry<Wall, Integer> entry = this.getRoom().getWall(data, face, 0);
            Wall w = entry.getKey();
            for (i = 0; i < entry.getValue(); ++i) {
                if (!w.getFront().getType().isSolid() && placedBeds < 2 && w.getRear().getType() != this.plainsVillagePopulator.woodDoor && (GenUtils.chance(random, 2, 5) && placedBeds == 0 || GenUtils.chance(random, 1, 10) && placedBeds == 1)) {
                    BlockUtils.placeBed(w.get(), BlockUtils.pickBed(), w.getDirection());
                    ++placedBeds;
                    data.addEntity(w.getX(), w.getY() + 1, w.getZ(), EntityType.VILLAGER);
                }
                w = w.getLeft();
            }
            w = entry.getKey();
            for (i = 0; i < entry.getValue(); ++i) {
                if (w.getRear().getType() != this.plainsVillagePopulator.woodDoor && !Tag.BEDS.isTagged((Keyed)w.getType())) {
                    if (Tag.BEDS.isTagged((Keyed)w.getRight().getType()) || Tag.BEDS.isTagged((Keyed)w.getLeft().getType())) {
                        if (random.nextBoolean()) {
                            new StairBuilder(Material.STONE_BRICK_STAIRS, Material.POLISHED_ANDESITE_STAIRS).setFacing(w.getDirection().getOppositeFace()).setHalf(Bisected.Half.TOP).apply(w);
                            w.getRelative(0, 1, 0).setType(BlockUtils.pickPottedPlant());
                        } else {
                            w.setType(Material.CRAFTING_TABLE);
                        }
                    } else if (GenUtils.chance(random, 1, 10)) {
                        new ChestBuilder(Material.CHEST).setFacing(w.getDirection()).setLootTable(TerraLootTable.VILLAGE_PLAINS_HOUSE).apply(w);
                    } else if (GenUtils.chance(random, 1, 5) && !w.getFront().getType().isSolid()) {
                        new SlabBuilder(Material.SMOOTH_STONE_SLAB, Material.POLISHED_ANDESITE_SLAB).setType(Slab.Type.TOP).apply(w);
                        new StairBuilder(Material.POLISHED_ANDESITE_STAIRS).setFacing(w.getDirection()).apply(w.getFront());
                    }
                }
                w = w.getLeft();
            }
        }
    }
}

