/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains.forge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Axis;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Slab;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.Wall;
import org.terraform.structure.room.jigsaw.JigsawStructurePiece;
import org.terraform.structure.village.plains.PlainsVillagePopulator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.OrientableBuilder;
import org.terraform.utils.blockdata.SlabBuilder;

public class PlainsVillageForgeRoofHandler {
    private static final int pieceWidth = 5;

    public static void placeRoof(PlainsVillagePopulator plainsVillagePopulator, SimpleBlock core, ArrayList<SimpleLocation> rectangleLocations) {
        SimpleLocation lowerBound = null;
        SimpleLocation upperBound = null;
        Material roofCornerMaterial = GenUtils.randMaterial(Material.STONE_BRICKS, Material.COBBLESTONE);
        Material roofSlabCornerMaterial = Material.STONE_BRICK_SLAB;
        if (roofCornerMaterial == Material.COBBLESTONE) {
            roofSlabCornerMaterial = Material.COBBLESTONE_SLAB;
        }
        for (SimpleLocation sLoc : rectangleLocations) {
            if (lowerBound == null) {
                lowerBound = sLoc;
            }
            if (upperBound == null) {
                upperBound = sLoc;
            }
            if (lowerBound.getX() >= sLoc.getX() && lowerBound.getZ() >= sLoc.getZ()) {
                lowerBound = sLoc;
            }
            if (upperBound.getX() > sLoc.getX() || upperBound.getZ() > sLoc.getZ()) continue;
            upperBound = sLoc;
        }
        lowerBound = lowerBound.getRelative(-4, 0, -4);
        upperBound = upperBound.getRelative(4, 0, 4);
        Axis roofAxis = Axis.X;
        if (upperBound.getZ() - lowerBound.getZ() > upperBound.getX() - lowerBound.getX()) {
            roofAxis = Axis.Z;
        }
        for (int x = lowerBound.getX(); x <= upperBound.getX(); ++x) {
            for (int z = lowerBound.getZ(); z <= upperBound.getZ(); ++z) {
                double percent = roofAxis == Axis.X ? ((double)x - (double)lowerBound.getX()) / ((double)upperBound.getX() - (double)lowerBound.getX()) : ((double)z - (double)lowerBound.getZ()) / ((double)upperBound.getZ() - (double)lowerBound.getZ());
                int height = (int)(-12.0 * Math.pow(percent - 0.5, 2.0) + 3.0);
                SimpleBlock target = new SimpleBlock(core.getPopData(), x, core.getY() + 4 + (int)((double)height / 2.0), z);
                if (height % 2 == 1) {
                    if (x == lowerBound.getX() || x == upperBound.getX() || z == lowerBound.getZ() || z == upperBound.getZ()) {
                        target.setType(roofCornerMaterial);
                        Wall adj = new Wall(target, BlockUtils.getBlockFaceFromAxis(roofAxis));
                        new SlabBuilder(roofSlabCornerMaterial).setType(Slab.Type.TOP).lapply(adj.getFront()).lapply(adj.getRear());
                    } else {
                        target.setType(plainsVillagePopulator.woodPlank);
                    }
                    if (height != 3) continue;
                    new OrientableBuilder(plainsVillagePopulator.woodLog).setAxis(BlockUtils.getPerpendicularHorizontalPlaneAxis(roofAxis)).apply(target);
                    if ((roofAxis != Axis.X || z != lowerBound.getZ() + 1 && z != upperBound.getZ() - 1) && (roofAxis != Axis.Z || x != lowerBound.getX() + 1 && x != upperBound.getX() - 1) || !BlockUtils.isStoneLike(target.getRelative(0, -2, 0).getType()) && target.getRelative(0, -2, 0).getType() != plainsVillagePopulator.woodDoor) continue;
                    new Wall(target.getRelative(0, -1, 0)).downUntilSolid(new Random(), Material.STONE, Material.COBBLESTONE, Material.ANDESITE);
                    continue;
                }
                if (x == lowerBound.getX() || x == upperBound.getX() || z == lowerBound.getZ() || z == upperBound.getZ()) {
                    new SlabBuilder(roofSlabCornerMaterial).apply(target);
                    continue;
                }
                new SlabBuilder(plainsVillagePopulator.woodSlab).apply(target);
            }
        }
    }

    public static ArrayList<SimpleLocation> identifyRectangle(HashMap<SimpleLocation, JigsawStructurePiece> pieces) {
        ArrayList<SimpleLocation> rectangleList = new ArrayList<SimpleLocation>();
        SimpleLocation cornerLoc = null;
        Iterator<SimpleLocation> iterator = pieces.keySet().iterator();
        if (iterator.hasNext()) {
            SimpleLocation loc;
            cornerLoc = loc = iterator.next();
        }
        BlockFace sideToMove = BlockUtils.getDirectBlockFace(new Random());
        JigsawStructurePiece target = PlainsVillageForgeRoofHandler.getAdjacentPiece(pieces, cornerLoc, sideToMove);
        while (target != null) {
            cornerLoc = target.getRoom().getSimpleLocation();
            target = PlainsVillageForgeRoofHandler.getAdjacentPiece(pieces, cornerLoc, sideToMove);
        }
        target = pieces.get(cornerLoc);
        while (target != null) {
            cornerLoc = target.getRoom().getSimpleLocation();
            rectangleList.add(target.getRoom().getSimpleLocation());
            target = PlainsVillageForgeRoofHandler.getAdjacentPiece(pieces, cornerLoc, sideToMove.getOppositeFace());
        }
        sideToMove = BlockUtils.getTurnBlockFace(new Random(), sideToMove);
        int shortestLength = 99;
        for (SimpleLocation pLoc : rectangleList) {
            JigsawStructurePiece piece = pieces.get(pLoc);
            int expansionLength = 0;
            piece = PlainsVillageForgeRoofHandler.getAdjacentPiece(pieces, piece.getRoom().getSimpleLocation(), sideToMove);
            while (piece != null) {
                ++expansionLength;
                piece = PlainsVillageForgeRoofHandler.getAdjacentPiece(pieces, piece.getRoom().getSimpleLocation(), sideToMove);
            }
            if (expansionLength < shortestLength) {
                shortestLength = expansionLength;
            }
            if (expansionLength != 0) continue;
            break;
        }
        ArrayList<SimpleLocation> toAdd = new ArrayList<SimpleLocation>();
        for (SimpleLocation pLoc : rectangleList) {
            JigsawStructurePiece piece = pieces.get(pLoc);
            piece = PlainsVillageForgeRoofHandler.getAdjacentPiece(pieces, piece.getRoom().getSimpleLocation(), sideToMove);
            for (int i = 0; i < shortestLength; ++i) {
                toAdd.add(piece.getRoom().getSimpleLocation());
                piece = PlainsVillageForgeRoofHandler.getAdjacentPiece(pieces, piece.getRoom().getSimpleLocation(), sideToMove);
            }
        }
        rectangleList.addAll(toAdd);
        return rectangleList;
    }

    private static JigsawStructurePiece getAdjacentPiece(HashMap<SimpleLocation, JigsawStructurePiece> pieces, SimpleLocation loc, BlockFace face) {
        SimpleLocation other = new SimpleLocation(loc.getX() + face.getModX() * 5, loc.getY() + face.getModY() * 5, loc.getZ() + face.getModZ() * 5);
        return pieces.get(other);
    }
}

