/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains.forge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.jigsaw.JigsawType;
import org.terraform.structure.village.plains.PlainsVillagePopulator;
import org.terraform.structure.village.plains.forge.PlainsVillageForgeStandardPiece;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.blockdata.DirectionalBuilder;

public class PlainsVillageForgeMasonPiece
extends PlainsVillageForgeStandardPiece {
    public PlainsVillageForgeMasonPiece(PlainsVillagePopulator plainsVillagePopulator, int widthX, int height, int widthZ, JigsawType type, BlockFace[] validDirs) {
        super(plainsVillagePopulator, widthX, height, widthZ, type, validDirs);
    }

    @Override
    public void postBuildDecoration(Random random, PopulatorDataAbstract data) {
        SimpleBlock core = new SimpleBlock(data, this.getRoom().getX(), this.getRoom().getY(), this.getRoom().getZ());
        if (this.getWalledFaces().size() == 0) {
            this.spawnCenteredPileOfRocks(random, new Wall(core));
        }
        if (this.getWalledFaces().size() == 1 && core.getRelative(this.getWalledFaces().get(0), 3).getType() == Material.CHISELED_STONE_BRICKS) {
            this.spawnCenteredPileOfRocks(random, new Wall(core));
            return;
        }
        ArrayList<BlockFace> walledFaces = this.getWalledFaces();
        Collections.shuffle(walledFaces);
        for (BlockFace face : walledFaces) {
            if (core.getRelative(face, 3).getType() == Material.CHISELED_STONE_BRICKS) continue;
            Wall target = new Wall(core, face);
            this.spawnedWalledPileOfRocks(random, target);
            return;
        }
    }

    private void spawnCenteredPileOfRocks(Random random, Wall core) {
        core = core.getRelative(0, 1, 0);
        Material[] ores = new Material[]{Material.IRON_ORE, Material.COAL_ORE, Material.GOLD_ORE, Material.LAPIS_ORE, Material.ANDESITE, Material.DIORITE, Material.GRANITE, Material.STONE, Material.ANDESITE, Material.DIORITE, Material.GRANITE, Material.STONE, Material.ANDESITE, Material.DIORITE, Material.GRANITE, Material.STONE};
        core.Pillar(random.nextInt(3) + 1, random, ores);
        for (BlockFace face : BlockUtils.xzPlaneBlockFaces) {
            core.getRelative(face).Pillar(random.nextInt(3), random, ores);
        }
        Wall target = core.getRelative(BlockUtils.getXZPlaneBlockFace(random));
        while (target.getType().isSolid()) {
            target = target.getRelative(0, 1, 0);
        }
        new DirectionalBuilder(Material.STONECUTTER).setFacing(BlockUtils.getDirectBlockFace(new Random())).apply(target);
        for (int i = 0; i < random.nextInt(2) + 1; ++i) {
            target = target.getAtY(core.getY() + 1).getRelative(BlockUtils.getDirectBlockFace(random));
            while (target.getType().isSolid()) {
                target = target.getRelative(0, 1, 0);
            }
            if (target.getRelative(0, -1, 0).getType() == Material.LANTERN) continue;
            target.setType(Material.LANTERN);
        }
    }

    private void spawnedWalledPileOfRocks(Random random, Wall core) {
        core = core.getRelative(0, 1, 0);
        Material[] ores = new Material[]{Material.IRON_ORE, Material.COAL_ORE, Material.GOLD_ORE, Material.LAPIS_ORE, Material.ANDESITE, Material.DIORITE, Material.GRANITE, Material.STONE, Material.ANDESITE, Material.DIORITE, Material.GRANITE, Material.STONE, Material.ANDESITE, Material.DIORITE, Material.GRANITE, Material.STONE};
        new DirectionalBuilder(Material.STONECUTTER).setFacing(BlockUtils.getDirectBlockFace(new Random())).apply(core);
        core = core.getRelative(core.getDirection(), 2);
        core.Pillar(random.nextInt(3) + 1, random, ores);
        core.getLeft().Pillar(random.nextInt(3) + 1, random, ores);
        core.getRight().Pillar(random.nextInt(3) + 1, random, ores);
        core.getLeft(2).Pillar(random.nextInt(3), random, ores);
        core.getRight(2).Pillar(random.nextInt(3), random, ores);
        core.getRear().Pillar(random.nextInt(3), random, ores);
        core.getRear().getLeft().Pillar(random.nextInt(3), random, ores);
        core.getRear().getRight().Pillar(random.nextInt(3), random, ores);
        for (int i = 0; i < random.nextInt(2) + 1; ++i) {
            Wall target = core.getRelative(core.getDirection().getOppositeFace(), 2).getRelative(BlockUtils.getDirectBlockFace(random));
            while (target.getType().isSolid()) {
                target = target.getRelative(0, 1, 0);
            }
            target.setType(Material.LANTERN);
        }
    }
}

