/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains;

import java.io.FileNotFoundException;
import java.util.Random;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfigOption;
import org.terraform.schematic.SchematicParser;
import org.terraform.schematic.TerraSchematic;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.village.plains.DirectionalCubeRoom;
import org.terraform.structure.village.plains.PlainsVillageAbstractRoomPopulator;
import org.terraform.structure.village.plains.PlainsVillagePathPopulator;
import org.terraform.structure.village.plains.PlainsVillagePopulator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.OneOneSevenBlockHandler;
import org.terraform.utils.version.Version;

public class PlainsVillageWellPopulator
extends PlainsVillageAbstractRoomPopulator {
    private static final String[] villageWellSchems = new String[]{"plainsvillage-well1", "plainsvillage-well2"};
    private PlainsVillagePopulator plainsVillagePopulator;

    public PlainsVillageWellPopulator(PlainsVillagePopulator plainsVillagePopulator, Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
        this.plainsVillagePopulator = plainsVillagePopulator;
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        int z;
        int x;
        SimpleBlock tester;
        int y = super.calculateRoomY(data, room);
        int worldHeight = TerraformGeneratorPlugin.injector.getMaxY() - TerraformGeneratorPlugin.injector.getMinY() + 1;
        for (int[] corner : room.getAllCorners()) {
            SimpleBlock sb = new SimpleBlock(data, corner[0], y, corner[1]);
            int lowSb = sb.findFloor(worldHeight).getY();
            if (Math.abs(lowSb - y) <= TConfigOption.STRUCTURES_PLAINSVILLAGE_HEIGHT_TOLERANCE.getInt()) continue;
            this.placeFixerPlatform(y, data, room);
            break;
        }
        if (BlockUtils.isWet(tester = new SimpleBlock(data, x = room.getX(), y + 1, z = room.getZ()))) {
            y = tester.getGroundOrDry().getY();
        }
        BlockFace roomDir = ((DirectionalCubeRoom)room).getDirection();
        try {
            SimpleBlock core = new SimpleBlock(data, x, y + 1, z);
            TerraSchematic schem = TerraSchematic.load(villageWellSchems[this.rand.nextInt(villageWellSchems.length)], core.getRelative(0, -1, 0));
            schem.parser = new PlainsVillageWellSchematicParser();
            schem.apply();
            int depth = GenUtils.randInt(this.rand, 5, 20);
            for (int i = 0; i < depth; ++i) {
                boolean breakOut = false;
                if (i > 0) {
                    for (BlockFace face : BlockUtils.flatBlockFaces3x3) {
                        if (core.getRelative(face).getDown(depth + 1).getType().isSolid()) continue;
                        breakOut = true;
                        break;
                    }
                }
                if (breakOut) break;
                if (i == 0) {
                    core.setType(Material.AIR);
                } else {
                    core.getRelative(0, -i, 0).setType(Material.WATER);
                }
                for (BlockFace face : BlockUtils.xzPlaneBlockFaces) {
                    if (i == 0) {
                        core.getRelative(face).setType(Material.AIR);
                        continue;
                    }
                    core.getRelative(0, -i, 0).getRelative(face).setType(Material.WATER);
                }
            }
            for (int nx = -3; nx <= 3; ++nx) {
                for (int nz = -3; nz <= 3; ++nz) {
                    Wall target = new Wall(core.getRelative(nx, -1, nz));
                    if (target.getType() != Material.COBBLESTONE && target.getType() != Material.MOSSY_COBBLESTONE) continue;
                    target.getRelative(0, -1, 0).downUntilSolid(this.rand, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE);
                }
            }
            Wall w = new Wall(core.getRelative(roomDir, 3), roomDir);
            int pathLength = room.getWidthX() / 2;
            if (BlockUtils.getAxisFromBlockFace(roomDir) == Axis.Z) {
                pathLength = room.getWidthZ() / 2;
            }
            for (int i = 0; i < pathLength - 1; ++i) {
                BlockFace lampFace;
                SimpleBlock target;
                w.getGround().setType(OneOneSevenBlockHandler.DIRT_PATH());
                w.getLeft().getGround().setType(OneOneSevenBlockHandler.DIRT_PATH());
                w.getRight().getGround().setType(OneOneSevenBlockHandler.DIRT_PATH());
                if (GenUtils.chance(this.rand, 1, 10) && (target = w.getRelative(lampFace = BlockUtils.getTurnBlockFace(this.rand, roomDir), 2).getGround().getRelative(0, 1, 0).get()).getRelative(0, -1, 0).getType() != OneOneSevenBlockHandler.DIRT_PATH() && PlainsVillagePathPopulator.canPlaceLamp(target)) {
                    PlainsVillagePathPopulator.placeLamp(this.rand, target);
                }
                w = w.getRelative(roomDir);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return room.getWidthX() <= 10;
    }

    private class PlainsVillageWellSchematicParser
    extends SchematicParser {
        private PlainsVillageWellSchematicParser() {
        }

        @Override
        public void applyData(SimpleBlock block, BlockData data) {
            if (data.getMaterial().toString().contains("COBBLESTONE")) {
                data = Bukkit.createBlockData((String)data.getAsString().replaceAll("cobblestone", GenUtils.randMaterial(PlainsVillageWellPopulator.this.rand, Material.COBBLESTONE, Material.COBBLESTONE, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE).toString().toLowerCase()));
                super.applyData(block, data);
            } else if (data.getMaterial() == Material.IRON_BARS) {
                if (Version.isAtLeast(16.0)) {
                    data = Bukkit.createBlockData((Material)Material.CHAIN);
                }
                super.applyData(block, data);
            } else if (data.getMaterial().toString().startsWith("OAK_")) {
                data = Bukkit.createBlockData((String)data.getAsString().replaceAll("oak_", PlainsVillageWellPopulator.this.plainsVillagePopulator.wood));
                super.applyData(block, data);
            } else {
                super.applyData(block, data);
            }
        }
    }
}

