/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains;

import java.util.Collection;
import java.util.Random;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.PathPopulatorAbstract;
import org.terraform.structure.room.PathPopulatorData;
import org.terraform.structure.village.plains.DirectionalCubeRoom;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class PlainsVillagePathPopulator
extends PathPopulatorAbstract {
    TerraformWorld tw;
    private final Random random;
    private final Collection<DirectionalCubeRoom> knownRooms;

    public PlainsVillagePathPopulator(TerraformWorld tw, Collection<DirectionalCubeRoom> collection, Random rand) {
        this.tw = tw;
        this.random = rand;
        this.knownRooms = collection;
    }

    public static void placeLamp(Random rand, SimpleBlock b) {
        b.setType(GenUtils.randMaterial(rand, Material.STONE_BRICKS, Material.MOSSY_STONE_BRICKS));
        b.getRelative(0, 1, 0).setType(GenUtils.randMaterial(rand, Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL));
        b.getRelative(0, 2, 0).setType(GenUtils.randMaterial(rand, Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL));
        b.getRelative(0, 3, 0).setType(GenUtils.randMaterial(rand, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE));
        b.getRelative(0, 4, 0).setType(Material.CAMPFIRE);
        b.getRelative(0, 5, 0).setType(GenUtils.randMaterial(rand, Material.STONE_BRICKS, Material.MOSSY_STONE_BRICKS));
        for (BlockFace face : BlockUtils.directBlockFaces) {
            Slab tSlab = (Slab)Bukkit.createBlockData((Material)GenUtils.randMaterial(rand, Material.STONE_BRICK_SLAB, Material.MOSSY_STONE_BRICK_SLAB));
            tSlab.setType(Slab.Type.TOP);
            b.getRelative(face).getRelative(0, 3, 0).setBlockData((BlockData)tSlab);
            b.getRelative(face).getRelative(0, 4, 0).setType(GenUtils.randMaterial(rand, Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL));
            b.getRelative(face).getRelative(0, 5, 0).setType(GenUtils.randMaterial(rand, Material.STONE_BRICK_SLAB, Material.MOSSY_STONE_BRICK_SLAB));
        }
    }

    public static boolean canPlaceLamp(SimpleBlock target) {
        if (target.getType() == Material.WATER) {
            return false;
        }
        for (BlockFace face : BlockUtils.xzPlaneBlockFaces) {
            for (int i = 0; i < 6; ++i) {
                if (!target.getRelative(face).getRelative(0, i, 0).getType().isSolid()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void populate(PathPopulatorData ppd) {
        ppd.base = new SimpleBlock(ppd.base.getPopData(), ppd.base.getX(), GenUtils.getHighestGround(ppd.base.getPopData(), ppd.base.getX(), ppd.base.getZ()), ppd.base.getZ());
        if (BlockUtils.isWet(ppd.base.getRelative(0, 1, 0))) {
            Wall pathCore = new Wall(ppd.base, ppd.dir).getAtY(TerraformGenerator.seaLevel);
            if (BlockUtils.getAxisFromBlockFace(ppd.dir) == Axis.X && ppd.base.getX() % 2 == 0 || BlockUtils.getAxisFromBlockFace(ppd.dir) == Axis.Z && ppd.base.getZ() % 2 == 0) {
                pathCore.getRelative(0, -1, 0).downLPillar(this.random, 50, Material.OAK_LOG);
                pathCore.setType(Material.CHISELED_STONE_BRICKS);
            }
            return;
        }
        Wall pathCore = new Wall(ppd.base, ppd.dir);
        block0: for (BlockFace blockFace : BlockUtils.getAdjacentFaces(ppd.dir)) {
            for (int i = 0; i < 4; ++i) {
                Wall target = pathCore.getRelative(blockFace, i).getGround();
                if (target.getRelative(0, 1, 0).getType().isSolid() || target.getRelative(0, 1, 0).getType() == Material.WATER || !BlockUtils.isDirtLike(target.getType()) || target.getType() == OneOneSevenBlockHandler.DIRT_PATH()) continue;
                if (GenUtils.chance(2, 5)) {
                    target.getRelative(0, 1, 0).setType(Material.OAK_LEAVES);
                    continue block0;
                }
                if (GenUtils.chance(1, 5)) {
                    BlockUtils.setDoublePlant(target.get().getPopData(), target.getX(), target.getY() + 1, target.getZ(), BlockUtils.pickTallFlower());
                    continue block0;
                }
                if (!GenUtils.chance(1, 10)) continue block0;
                target.getRelative(0, 1, 0).setType(Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL);
                target.getRelative(0, 2, 0).setType(Material.LANTERN);
                continue block0;
            }
        }
        if (GenUtils.chance(this.random, 1, 15)) {
            BlockFace side = BlockUtils.getTurnBlockFace(this.random, ppd.dir);
            SimpleBlock target = new SimpleBlock(ppd.base.getPopData(), ppd.base.getX() + side.getModX() * 3, GenUtils.getHighestGround(ppd.base.getPopData(), ppd.base.getX() + side.getModX() * 3, ppd.base.getZ() + side.getModZ() * 3), ppd.base.getZ() + side.getModZ() * 3);
            if (target.getType() == OneOneSevenBlockHandler.DIRT_PATH()) {
                return;
            }
            for (BlockFace face : BlockUtils.xzPlaneBlockFaces) {
                if (!target.getRelative(face).getGround().getRelative(0, 1, 0).getType().isSolid()) continue;
                return;
            }
            for (CubeRoom cubeRoom : this.knownRooms) {
                if (!cubeRoom.isPointInside(target)) continue;
                return;
            }
            PlainsVillagePathPopulator.placeLamp(this.random, target.getRelative(0, 1, 0));
        }
    }

    @Override
    public int getPathWidth() {
        return 3;
    }
}

