/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains;

import java.io.FileNotFoundException;
import java.util.Random;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.schematic.SchematicParser;
import org.terraform.schematic.TerraSchematic;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.structure.village.plains.DirectionalCubeRoom;
import org.terraform.structure.village.plains.PlainsVillagePathPopulator;
import org.terraform.structure.village.plains.PlainsVillagePopulator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class PlainsVillageFountainPopulator
extends RoomPopulatorAbstract {
    private static final String[] villageFountainSchems = new String[]{"plainsvillage-fountain1", "plainsvillage-fountain2"};
    private PlainsVillagePopulator plainsVillagePopulator;

    public PlainsVillageFountainPopulator(PlainsVillagePopulator plainsVillagePopulator, Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
        this.plainsVillagePopulator = plainsVillagePopulator;
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        int x = room.getX();
        int z = room.getZ();
        int y = GenUtils.getHighestGround(data, x, z);
        BlockFace roomDir = ((DirectionalCubeRoom)room).getDirection();
        try {
            SimpleBlock core = new SimpleBlock(data, x, y + 1, z);
            TerraSchematic schem = TerraSchematic.load(villageFountainSchems[this.rand.nextInt(villageFountainSchems.length)], core.getRelative(0, -1, 0));
            schem.parser = new PlainsVillageFountainSchematicParser();
            schem.apply();
            for (int nx = -3; nx <= 3; ++nx) {
                for (int nz = -3; nz <= 3; ++nz) {
                    Wall target = new Wall(core.getRelative(nx, 0, nz));
                    if (target.getType() == Material.COBBLESTONE || target.getType() == Material.MOSSY_COBBLESTONE) {
                        target.getRelative(0, -1, 0).downUntilSolid(this.rand, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE);
                        continue;
                    }
                    if (target.getType() != Material.POLISHED_ANDESITE) continue;
                    target.getRelative(0, -1, 0).downUntilSolid(this.rand, Material.POLISHED_ANDESITE);
                }
            }
            Wall w = new Wall(core.getRelative(roomDir, 3), roomDir);
            int pathLength = room.getWidthX() / 2;
            if (BlockUtils.getAxisFromBlockFace(roomDir) == Axis.Z) {
                pathLength = room.getWidthZ() / 2;
            }
            for (int i = 0; i < pathLength - 1; ++i) {
                BlockFace lampFace;
                SimpleBlock target;
                w.getGround().setType(OneOneSevenBlockHandler.DIRT_PATH());
                w.getLeft().getGround().setType(OneOneSevenBlockHandler.DIRT_PATH());
                w.getRight().getGround().setType(OneOneSevenBlockHandler.DIRT_PATH());
                if (GenUtils.chance(this.rand, 1, 10) && (target = w.getRelative(lampFace = BlockUtils.getTurnBlockFace(this.rand, roomDir), 2).getGround().getRelative(0, 1, 0).get()).getRelative(0, -1, 0).getType() != OneOneSevenBlockHandler.DIRT_PATH() && PlainsVillagePathPopulator.canPlaceLamp(target)) {
                    PlainsVillagePathPopulator.placeLamp(this.rand, target);
                }
                w = w.getRelative(roomDir);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return room.getWidthX() <= 10;
    }

    private class PlainsVillageFountainSchematicParser
    extends SchematicParser {
        private PlainsVillageFountainSchematicParser() {
        }

        @Override
        public void applyData(SimpleBlock block, BlockData data) {
            if (data.getMaterial().toString().contains("COBBLESTONE")) {
                data = Bukkit.createBlockData((String)data.getAsString().replaceAll("cobblestone", GenUtils.randMaterial(PlainsVillageFountainPopulator.this.rand, Material.COBBLESTONE, Material.COBBLESTONE, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE).toString().toLowerCase()));
                super.applyData(block, data);
            } else if (data.getMaterial().toString().startsWith("OAK_")) {
                data = Bukkit.createBlockData((String)data.getAsString().replaceAll("oak_", PlainsVillageFountainPopulator.this.plainsVillagePopulator.wood));
                super.applyData(block, data);
            } else {
                super.applyData(block, data);
            }
        }
    }
}

