/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains;

import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.block.data.type.Lantern;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.main.config.TConfigOption;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.village.plains.DirectionalCubeRoom;
import org.terraform.structure.village.plains.PlainsVillageAbstractRoomPopulator;
import org.terraform.structure.village.plains.PlainsVillagePopulator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.AgeableBuilder;
import org.terraform.utils.blockdata.DirectionalBuilder;
import org.terraform.utils.blockdata.TrapdoorBuilder;
import org.terraform.utils.version.OneOneSixBlockHandler;
import org.terraform.utils.version.Version;

public class PlainsVillageCropFarmPopulator
extends PlainsVillageAbstractRoomPopulator {
    private static final Material[] crops = new Material[]{Material.WHEAT, Material.CARROTS, Material.POTATOES, Material.BEETROOTS, Material.PUMPKIN_STEM, Material.MELON_STEM};
    private PlainsVillagePopulator plainsVillagePopulator;

    public PlainsVillageCropFarmPopulator(PlainsVillagePopulator plainsVillagePopulator, Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
        this.plainsVillagePopulator = plainsVillagePopulator;
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        int roomY = super.calculateRoomY(data, room);
        boolean areaFailedTolerance = super.doesAreaFailTolerance(data, room);
        if (areaFailedTolerance) {
            return;
        }
        super.populate(data, room);
        BlockFace dir = ((DirectionalCubeRoom)room).getDirection();
        boolean hasScareCrow = false;
        int pad = GenUtils.randInt(1, 3);
        for (Map.Entry<Wall, Integer> entry : room.getFourWalls(data, pad).entrySet()) {
            Wall w = entry.getKey().getGroundOrSeaLevel().getRelative(0, 1, 0);
            for (int i = 0; i < entry.getValue(); ++i) {
                if (Math.abs(w.getY() - roomY) <= TConfigOption.STRUCTURES_PLAINSVILLAGE_HEIGHT_TOLERANCE.getInt()) {
                    if (w.getDirection().getOppositeFace() == dir) {
                        if (i <= 1 || i >= entry.getValue() - 1) {
                            w.setType(this.plainsVillagePopulator.woodLog);
                            w.getRelative(0, -1, 0).downUntilSolid(this.rand, this.plainsVillagePopulator.woodLog);
                            if (i == 1 || i == entry.getValue() - 1) {
                                new TrapdoorBuilder(this.plainsVillagePopulator.woodTrapdoor).setFacing(dir).setOpen(true).setHalf(Bisected.Half.BOTTOM).apply(w.getRear());
                                w.getRelative(0, 1, 0).setType(this.plainsVillagePopulator.woodLeaves);
                            }
                        } else if (i == 2 || i == entry.getValue() - 2) {
                            w.setType(this.plainsVillagePopulator.woodFence);
                            w.getRelative(0, -1, 0).downUntilSolid(this.rand, this.plainsVillagePopulator.woodLog);
                            w.CorrectMultipleFacing(1);
                            w.getRelative(0, 1, 0).setType(Material.TORCH);
                        } else if (i == entry.getValue() / 2) {
                            w.setType(Material.COMPOSTER);
                        }
                    } else {
                        w.downUntilSolid(this.rand, this.plainsVillagePopulator.woodLog);
                        if (i % 3 == 0) {
                            w.getRelative(0, 1, 0).setType(this.plainsVillagePopulator.woodLeaves);
                        } else {
                            w.getRelative(0, 1, 0).setType(this.plainsVillagePopulator.woodFence);
                            w.getRelative(0, 1, 0).CorrectMultipleFacing(1);
                            if (i > 1 && i < entry.getValue() - 2 && GenUtils.chance(this.rand, 1, 13)) {
                                int lampHeight = GenUtils.randInt(this.rand, 4, 6);
                                w.getRelative(0, 2, 0).Pillar(lampHeight, this.rand, this.plainsVillagePopulator.woodFence);
                                Wall lampWall = w.getRelative(0, 1 + lampHeight, 0).getFront();
                                for (int j = 0; j < GenUtils.randInt(this.rand, 1, 2); ++j) {
                                    lampWall.setType(this.plainsVillagePopulator.woodFence);
                                    lampWall.CorrectMultipleFacing(1);
                                    lampWall = lampWall.getFront();
                                }
                                lampWall = lampWall.getRear().getRelative(0, -1, 0);
                                Material chain = Material.IRON_BARS;
                                if (Version.isAtLeast(16.0)) {
                                    chain = OneOneSixBlockHandler.getChainMaterial();
                                }
                                for (int j = 0; j < GenUtils.randInt(this.rand, 0, 1); ++j) {
                                    lampWall.setType(chain);
                                    lampWall = lampWall.getRelative(0, -1, 0);
                                }
                                Lantern lantern = (Lantern)Bukkit.createBlockData((Material)Material.LANTERN);
                                lantern.setHanging(true);
                                lampWall.setBlockData((BlockData)lantern);
                            }
                        }
                    }
                }
                w = w.getLeft().getGroundOrSeaLevel().getRelative(0, 1, 0);
            }
        }
        int[] lowerCorner = room.getLowerCorner(++pad);
        int[] upperCorner = room.getUpperCorner(pad);
        Material crop = crops[this.rand.nextInt(crops.length)];
        for (int x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            block5: for (int z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                int height = GenUtils.getHighestGroundOrSeaLevel(data, x, z);
                if (Math.abs(height - roomY) > TConfigOption.STRUCTURES_PLAINSVILLAGE_HEIGHT_TOLERANCE.getInt()) continue;
                BlockUtils.setDownUntilSolid(x, height - 1, z, data, Material.DIRT);
                if (x % 4 == 0 && z % 4 == 0) {
                    for (BlockFace face : BlockUtils.directBlockFaces) {
                        data.setType(x + face.getModX(), height, z + face.getModZ(), Material.FARMLAND);
                        BlockUtils.setDownUntilSolid(x + face.getModX(), height - 1, z + face.getModZ(), data, Material.DIRT);
                    }
                    data.setType(x, height, z, Material.WATER);
                    continue;
                }
                if (crop != Material.PUMPKIN_STEM && crop != Material.MELON_STEM || GenUtils.chance(this.rand, 1, 3)) {
                    if (GenUtils.chance(this.rand, 1, 30) && !hasScareCrow) {
                        if (x <= lowerCorner[0] + 1 || x >= upperCorner[0] - 1 || z <= lowerCorner[1] + 1 || z >= upperCorner[1] - 1) continue;
                        hasScareCrow = true;
                        this.setScareCrow(data, x, height + 1, z);
                        continue;
                    }
                    Farmland land = (Farmland)Bukkit.createBlockData((Material)Material.FARMLAND);
                    land.setMoisture(7);
                    data.setBlockData(x, height, z, (BlockData)land);
                    new AgeableBuilder(crop).setRandomAge(this.rand).apply(data, x, height + 1, z);
                    continue;
                }
                if (GenUtils.chance(this.rand, 1, 3)) {
                    Material stem;
                    Material block;
                    data.setType(x, height, z, Material.DIRT);
                    if (crop == Material.PUMPKIN_STEM) {
                        block = Material.PUMPKIN;
                        stem = Material.ATTACHED_PUMPKIN_STEM;
                    } else {
                        block = Material.MELON;
                        stem = Material.ATTACHED_MELON_STEM;
                    }
                    SimpleBlock target = new SimpleBlock(data, x, height + 1, z);
                    for (BlockFace near : BlockUtils.directBlockFaces) {
                        if (!(target.getRelative(near).getBlockData() instanceof Ageable)) continue;
                        target.setType(block);
                        new DirectionalBuilder(stem).setFacing(near.getOppositeFace()).apply(target.getRelative(near));
                        continue block5;
                    }
                    continue;
                }
                data.setType(x, height, z, Material.COARSE_DIRT);
            }
        }
    }

    private void setScareCrow(PopulatorDataAbstract data, int x, int y, int z) {
        BlockFace facing = BlockUtils.getDirectBlockFace(this.rand);
        Wall w = new Wall(new SimpleBlock(data, x, y, z), facing);
        w.setType(Material.COBBLESTONE, Material.MOSSY_COBBLESTONE);
        w.getRelative(0, 1, 0).setType(this.plainsVillagePopulator.woodFence);
        w.getRelative(0, 2, 0).setType(this.plainsVillagePopulator.woodFence);
        w.getLeft().getRelative(0, 2, 0).setType(this.plainsVillagePopulator.woodFence);
        w.getRight().getRelative(0, 2, 0).setType(this.plainsVillagePopulator.woodFence);
        w.getRelative(0, 2, 0).CorrectMultipleFacing(1);
        new DirectionalBuilder(Material.CARVED_PUMPKIN, Material.JACK_O_LANTERN).setFacing(facing).apply(w.getRelative(0, 3, 0));
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return room.getWidthX() >= 15 && (room.getWidthX() < 18 || room.getWidthZ() < 18);
    }
}

