/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.village.plains;

import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.data.Bisected;
import org.bukkit.entity.EntityType;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.main.config.TConfigOption;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.village.plains.DirectionalCubeRoom;
import org.terraform.structure.village.plains.PlainsVillageAbstractRoomPopulator;
import org.terraform.structure.village.plains.PlainsVillagePopulator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.DirectionalBuilder;
import org.terraform.utils.blockdata.SlabBuilder;
import org.terraform.utils.blockdata.StairBuilder;

public class PlainsVillageAnimalPenPopulator
extends PlainsVillageAbstractRoomPopulator {
    private static final EntityType[] farmAnimals = new EntityType[]{EntityType.PIG, EntityType.SHEEP, EntityType.COW, EntityType.HORSE, EntityType.CHICKEN};
    private PlainsVillagePopulator plainsVillagePopulator;

    public PlainsVillageAnimalPenPopulator(PlainsVillagePopulator plainsVillagePopulator, Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
        this.plainsVillagePopulator = plainsVillagePopulator;
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        int z;
        int x;
        if (super.doesAreaFailTolerance(data, room)) {
            return;
        }
        int roomY = super.calculateRoomY(data, room);
        Wall jobBlock = null;
        boolean spawnedWater = false;
        for (Map.Entry<Wall, Integer> entry : room.getFourWalls(data, 2).entrySet()) {
            Wall w = entry.getKey();
            for (int i = 0; i < entry.getValue(); ++i) {
                Wall target = w.getAtY(roomY).findNearestAirPocket(15);
                if (target != null) {
                    if (target.getDown().getType() != Material.COBBLESTONE_SLAB && target.getDown().getType() != this.plainsVillagePopulator.woodFence) {
                        int wallHeight = 3;
                        if (target.getY() < roomY) {
                            wallHeight = 2 + (roomY - target.getY());
                        }
                        if (i % 2 == 0) {
                            target.Pillar(wallHeight, this.plainsVillagePopulator.woodLog);
                            target.getUp(wallHeight).setType(Material.COBBLESTONE_SLAB);
                            target.getDown(2).getRight().CorrectMultipleFacing(wallHeight + 2);
                            target.getDown(2).getLeft().CorrectMultipleFacing(wallHeight + 2);
                        } else {
                            target.Pillar(wallHeight, this.plainsVillagePopulator.woodFence);
                            target.CorrectMultipleFacing(wallHeight);
                        }
                    }
                    if (w.getDirection() == ((DirectionalCubeRoom)room).getDirection().getOppositeFace() && i == entry.getValue() / 2) {
                        jobBlock = target.getRear();
                    }
                }
                w = w.getLeft();
            }
        }
        int[] lowerCorner = room.getLowerCorner(3);
        int[] upperCorner = room.getUpperCorner(3);
        for (x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                int highest = GenUtils.getHighestGroundOrSeaLevel(data, x, z);
                if (Math.abs(highest - roomY) > TConfigOption.STRUCTURES_PLAINSVILLAGE_HEIGHT_TOLERANCE.getInt()) continue;
                BlockUtils.setDownUntilSolid(x, highest, z, data, Material.DIRT);
                if (this.rand.nextBoolean()) {
                    data.setType(x, highest, z, GenUtils.randMaterial(Material.PODZOL, Material.COARSE_DIRT, Material.GRASS_BLOCK));
                    continue;
                }
                if (!this.rand.nextBoolean() || data.getType(x, highest + 1, z).isSolid()) continue;
                BlockUtils.setDoublePlant(data, x, highest + 1, z, Material.TALL_GRASS);
            }
        }
        lowerCorner = room.getLowerCorner(5);
        upperCorner = room.getUpperCorner(5);
        block9: for (x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                SimpleBlock core;
                if (!GenUtils.chance(this.rand, 1, 70)) continue;
                if (!spawnedWater && this.rand.nextBoolean()) {
                    spawnedWater = true;
                    core = new Wall(new SimpleBlock(data, x, 0, z), BlockUtils.getDirectBlockFace(this.rand));
                    if (Math.abs((core = ((Wall)core).getGroundOrSeaLevel().getRelative(0, 1, 0)).getY() - roomY) > TConfigOption.STRUCTURES_PLAINSVILLAGE_HEIGHT_TOLERANCE.getInt()) continue;
                    new StairBuilder(Material.COBBLESTONE_STAIRS).setHalf(Bisected.Half.TOP).setFacing(((Wall)core).getDirection()).apply(((Wall)core).getRear()).setFacing(((Wall)core).getDirection().getOppositeFace()).apply(((Wall)core).getFront(2)).setFacing(BlockUtils.getRight(((Wall)core).getDirection())).apply(((Wall)core).getFront().getLeft()).apply(((Wall)core).getLeft()).setFacing(BlockUtils.getLeft(((Wall)core).getDirection())).apply(((Wall)core).getFront().getRight()).apply(((Wall)core).getRight());
                    new SlabBuilder(Material.COBBLESTONE_SLAB).setWaterlogged(true).apply((Wall)core).apply(((Wall)core).getFront());
                    ((Wall)core).getRelative(0, -1, 0).downUntilSolid(new Random(), Material.DIRT);
                    ((Wall)core).getFront().getRelative(0, -1, 0).downUntilSolid(new Random(), Material.DIRT);
                    continue block9;
                }
                core = new SimpleBlock(data, x, roomY, z).findAirPocket(15);
                if (core == null) continue;
                BlockUtils.replaceUpperSphere(x + 7 * z + 289, 1.5f, 2.5f, 1.5f, core, false, Material.HAY_BLOCK);
                continue block9;
            }
        }
        EntityType animal = farmAnimals[this.rand.nextInt(farmAnimals.length)];
        int[] coords = new int[]{room.getX(), 0, room.getZ()};
        int highest = GenUtils.getTrueHighestBlock(data, coords[0], coords[2]);
        int threshold = 0;
        while (data.getType(coords[0], highest + 1, coords[2]).isSolid() && threshold < 6) {
            ++threshold;
            ++highest;
        }
        if (threshold < 6 && Math.abs(highest - roomY) <= TConfigOption.STRUCTURES_PLAINSVILLAGE_HEIGHT_TOLERANCE.getInt()) {
            for (int i = 0; i < GenUtils.randInt(3, 7); ++i) {
                data.addEntity(coords[0], highest + 1, coords[2], animal);
            }
        }
        if (jobBlock != null) {
            switch (animal) {
                case PIG: 
                case CHICKEN: {
                    new DirectionalBuilder(Material.SMOKER).setFacing(((DirectionalCubeRoom)room).getDirection()).apply((SimpleBlock)jobBlock);
                    break;
                }
                case SHEEP: {
                    jobBlock.setType(Material.LOOM);
                    break;
                }
                case COW: 
                case HORSE: {
                    jobBlock.setType(Material.CAULDRON);
                    break;
                }
            }
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return room.getWidthX() >= 15 && (room.getWidthX() < 18 || room.getWidthZ() < 18);
    }
}

