/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.stronghold;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Chest;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class TrapChestRoomPopulator
extends RoomPopulatorAbstract {
    public TrapChestRoomPopulator(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        int z;
        int x;
        for (int i = 0; i < GenUtils.randInt(this.rand, 0, 5); ++i) {
            x = room.getX() + GenUtils.randInt(this.rand, -room.getWidthX() / 2, room.getWidthX() / 2);
            z = room.getZ() + GenUtils.randInt(this.rand, -room.getWidthZ() / 2, room.getWidthZ() / 2);
            data.setType(x, room.getY() + 1, z, Material.STONE_PRESSURE_PLATE);
            if (!GenUtils.chance(this.rand, 4, 5)) continue;
            data.setType(x, room.getY() - 1, z, Material.TNT);
        }
        int y = room.getY() + 1;
        x = room.getX();
        z = room.getZ();
        if (GenUtils.chance(this.rand, 1, 2)) {
            data.setType(x, y, z, Material.TNT);
        } else {
            data.setType(x, y, z, Material.SMOOTH_STONE);
        }
        SimpleBlock core = new SimpleBlock(data, x, y, z);
        for (BlockFace face : BlockUtils.directBlockFaces) {
            core.getRelative(face).setType(Material.SMOOTH_STONE);
            core.getRelative(face).getRelative(0, 1, 0).setType(Material.STONE_BRICK_STAIRS);
            Directional rot = (Directional)Bukkit.createBlockData((Material)Material.STONE_BRICK_STAIRS);
            rot.setFacing(face.getOppositeFace());
            core.getRelative(face).getRelative(0, 1, 0).setBlockData((BlockData)rot);
            for (BlockFace f : BlockUtils.directBlockFaces) {
                core.getRelative(face).getRelative(f).lsetType(Material.SMOOTH_STONE_SLAB);
            }
        }
        core.getRelative(0, 1, 0).setType(Material.CHISELED_STONE_BRICKS);
        y = core.getRelative(0, 2, 0).getY();
        Chest chest = (Chest)Bukkit.createBlockData((Material)Material.TRAPPED_CHEST);
        chest.setFacing(BlockUtils.getDirectBlockFace(this.rand));
        data.setBlockData(x, y, z, (BlockData)chest);
        data.lootTableChest(x, y, z, TerraLootTable.STRONGHOLD_CROSSING);
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return !room.isBig();
    }
}

